/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.ScaleOp;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ScaledImagePainter {
    protected ImageOp srcOp;
    protected ScaleOp scaleOp;

    public void setImageName(String string) {
        this.setSource(string == null || string.trim().length() == 0 ? null : Op.load(string));
    }

    public Dimension getImageSize() {
        return this.srcOp == null ? new Dimension() : this.srcOp.getSize();
    }

    public void draw(Graphics graphics, int n, int n2, double d, ImageObserver imageObserver) {
        BufferedImage bufferedImage;
        if (this.srcOp == null || d <= 0.0) {
            return;
        }
        if (d == 1.0) {
            bufferedImage = this.srcOp.getImage();
        } else {
            if (this.scaleOp == null || this.scaleOp.getScale() != d) {
                this.scaleOp = Op.scale(this.srcOp, d);
            }
            bufferedImage = this.scaleOp.getImage();
        }
        if (bufferedImage == null) {
            return;
        }
        graphics.drawImage(bufferedImage, n, n2, imageObserver);
    }

    public ImageOp getSource() {
        return this.srcOp;
    }

    public void setSource(ImageOp imageOp) {
        this.srcOp = imageOp;
        this.scaleOp = null;
    }
}

