/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.io.IOUtils;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class ObfuscatingOutputStream
extends FilterOutputStream {
    public static final String HEADER = "!VCSK";
    private static final Random rand = new Random();
    private final byte key;
    private final byte[] pair = new byte[2];
    private static final byte[] hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public ObfuscatingOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, (byte)rand.nextInt(256));
    }

    public ObfuscatingOutputStream(OutputStream outputStream, byte by) throws IOException {
        super(outputStream);
        this.key = by;
        outputStream.write(HEADER.getBytes("UTF-8"));
        this.pair[0] = hex[(by & 0xF0) >>> 4];
        this.pair[1] = hex[by & 0xF];
        outputStream.write(this.pair);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    public void write(int n) throws IOException {
        this.pair[0] = hex[((n ^= this.key) & 0xF0) >>> 4];
        this.pair[1] = hex[n & 0xF];
        this.out.write(this.pair);
    }

    public static void main(String[] stringArray) throws IOException {
        InputStream inputStream = null;
        ObfuscatingOutputStream obfuscatingOutputStream = null;
        try {
            inputStream = stringArray.length > 0 ? new FileInputStream(stringArray[0]) : System.in;
            obfuscatingOutputStream = new ObfuscatingOutputStream(new BufferedOutputStream(System.out));
            IOUtils.copy((InputStream)inputStream, (OutputStream)obfuscatingOutputStream);
            ((OutputStream)obfuscatingOutputStream).close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        System.exit(0);
    }
}

