/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class ThisMachine {
    private static InetAddress[] OurInetAddresses;

    private ThisMachine() {
    }

    public static String getName() {
        if (!ThisMachine.FetchOurInetAddresses()) {
            return "";
        }
        return OurInetAddresses[0].getHostName();
    }

    public static String getIPAddress(int n) {
        return ThisMachine.getIPAddress(ThisMachine.getNthAddress(n));
    }

    public static String getIPAddress(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + "." + (byArray[i] & 0xFF);
        }
        return string.substring(1);
    }

    private static byte[] getNthAddress(int n) {
        if (ThisMachine.FetchOurInetAddresses() && 0 <= n && n < OurInetAddresses.length) {
            return OurInetAddresses[n].getAddress();
        }
        return null;
    }

    private static synchronized boolean FetchOurInetAddresses() {
        if (OurInetAddresses != null) {
            return true;
        }
        try {
            OurInetAddresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            OurInetAddresses = null;
        }
        return OurInetAddresses != null;
    }
}

