/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.SudokuGenerator;
import generator.SudokuGeneratorFactory;
import java.awt.EventQueue;
import java.util.List;
import solver.SudokuSolver;
import solver.SudokuSolverFactory;
import sudoku.ClipboardMode;
import sudoku.DifficultyLevel;
import sudoku.GameMode;
import sudoku.GenerateSudokuProgressDialog;
import sudoku.Options;
import sudoku.SolutionStep;
import sudoku.Sudoku2;

public class BackgroundGenerator {
    private static final int MAX_TRIES = 20000;
    private int anz = 0;
    private GenerateSudokuProgressDialog progressDialog = null;

    public String generate(DifficultyLevel level, GameMode mode) {
        Sudoku2 sudoku = this.generate(level, mode, null);
        if (sudoku != null) {
            return sudoku.getSudoku(ClipboardMode.CLUES_ONLY);
        }
        return null;
    }

    public Sudoku2 generate(DifficultyLevel level, GameMode mode, GenerateSudokuProgressDialog dlg) {
        long actMillis = System.currentTimeMillis();
        this.progressDialog = dlg;
        Sudoku2 sudoku = null;
        SudokuGenerator creator = null;
        SudokuSolver solver = null;
        this.setAnz(0);
        if (dlg == null) {
            solver = SudokuSolverFactory.getInstance();
            creator = SudokuGeneratorFactory.getInstance();
        } else {
            solver = SudokuSolverFactory.getDefaultSolverInstance();
            creator = SudokuGeneratorFactory.getDefaultGeneratorInstance();
        }
        while (dlg == null || !Thread.currentThread().isInterrupted()) {
            sudoku = creator.generateSudoku(true);
            if (sudoku == null) {
                return null;
            }
            Sudoku2 solvedSudoku = sudoku.clone();
            boolean ok = solver.solve(level, solvedSudoku, true, null, false, Options.getInstance().solverSteps, mode);
            boolean containsTrainingStep = true;
            if (mode != GameMode.PLAYING) {
                containsTrainingStep = false;
                List<SolutionStep> steps = solver.getSteps();
                for (SolutionStep step : steps) {
                    if (!step.getType().getStepConfig().isEnabledTraining()) continue;
                    containsTrainingStep = true;
                    break;
                }
            }
            if (ok && containsTrainingStep && (solvedSudoku.getLevel().getOrdinal() == level.getOrdinal() || mode == GameMode.LEARNING)) {
                sudoku.setLevel(solvedSudoku.getLevel());
                sudoku.setScore(solvedSudoku.getScore());
                break;
            }
            this.setAnz(this.getAnz() + 1);
            if (dlg != null) {
                if (System.currentTimeMillis() - actMillis <= 500L) continue;
                actMillis = System.currentTimeMillis();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BackgroundGenerator.this.progressDialog.updateProgressLabel();
                    }
                });
                continue;
            }
            if (this.getAnz() <= 20000) continue;
            sudoku = null;
            break;
        }
        if (dlg == null) {
            SudokuGeneratorFactory.giveBack(creator);
            SudokuSolverFactory.giveBack(solver);
        }
        return sudoku;
    }

    public synchronized int getAnz() {
        return this.anz;
    }

    public synchronized void setAnz(int anz) {
        this.anz = anz;
    }
}

