/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import solver.Als;
import sudoku.AlsInSolutionStep;
import sudoku.Sudoku2;
import sudoku.SudokuSetBase;

public class Chain
implements Cloneable {
    private static final int EQUALS_MASK = 0x3FFFFFEF;
    private static final int CAND_MASK = 15;
    private static final int STRONG_MASK = 16;
    private static final int INDEX_MASK = 127;
    private static final int INDEX1_MASK = 4064;
    private static final int INDEX1_OFFSET = 5;
    private static final int INDEX2_MASK = 520192;
    private static final int INDEX2_OFFSET = 12;
    private static final int INDEX3_MASK = 66584576;
    private static final int INDEX3_OFFSET = 19;
    private static final int ALS_INDEX_MASK = 0x3FFF000;
    private static final int ALS_INDEX_OFFSET = 12;
    private static final int NO_INDEX = 127;
    private static final int MODE_MASK = 0x3C000000;
    private static final int MODE_DEL_MASK = -1006632961;
    private static final int MODE_OFFSET = 26;
    private static final int NORMAL_NODE_MASK = 0;
    private static final int GROUP_NODE_MASK = 0x4000000;
    private static final int ALS_NODE_MASK = 0x8000000;
    public static final int NORMAL_NODE = 0;
    public static final int GROUP_NODE = 1;
    public static final int ALS_NODE = 2;
    public static final String[] TYPE_NAMES = new String[]{"NORMAL_NODE", "GROUP_NODE", "ALS_NODE"};
    private int start;
    private int end;
    private int length;
    private int[] chain;

    public Chain() {
    }

    public Chain(int start, int end, int[] chain) {
        this.start = start;
        this.end = end;
        this.chain = chain;
        this.length = -1;
    }

    public Object clone() {
        try {
            Chain newChain = (Chain)super.clone();
            newChain.start = this.start;
            newChain.end = this.end;
            newChain.chain = Arrays.copyOf(this.chain, this.end + 1);
            return newChain;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public void reset() {
        this.start = 0;
        this.end = 0;
        this.length = -1;
    }

    public void resetLength() {
        this.length = -1;
    }

    public int getLength() {
        return this.getLength(null);
    }

    public int getLength(List<AlsInSolutionStep> alses) {
        if (this.length == -1) {
            this.length = this.calculateLength(alses);
        }
        return this.length;
    }

    private int calculateLength(List<AlsInSolutionStep> alses) {
        double tmpLength = 0.0;
        for (int i = this.start; i <= this.end; ++i) {
            tmpLength += 1.0;
            if (Chain.getSNodeType(this.chain[i]) != 2) continue;
            if (alses != null) {
                int alsIndex = Chain.getSAlsIndex(this.chain[i]);
                if (alses.size() > alsIndex) {
                    tmpLength += (double)alses.get(alsIndex).getChainPenalty();
                    continue;
                }
                tmpLength += 5.0;
                continue;
            }
            tmpLength += 2.5;
        }
        return (int)tmpLength;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int[] getChain() {
        return this.chain;
    }

    public void setChain(int[] chain) {
        this.chain = chain;
    }

    public static int makeSEntry(int cellIndex, int candidate, boolean isStrong) {
        return Chain.makeSEntry(cellIndex, 0, 0, candidate, isStrong, 0);
    }

    public static int makeSEntry(int cellIndex, int candidate, boolean isStrong, int nodeType) {
        return Chain.makeSEntry(cellIndex, 0, 0, candidate, isStrong, nodeType);
    }

    public static int makeSEntry(int cellIndex, int alsIndex, int candidate, boolean isStrong, int nodeType) {
        int tmpIndex = Chain.getSHigherAlsIndex(alsIndex);
        alsIndex = Chain.getSLowerAlsIndex(alsIndex);
        return Chain.makeSEntry(cellIndex, alsIndex, tmpIndex, candidate, isStrong, nodeType);
    }

    public static int makeSEntry(int cellIndex1, int cellIndex2, int cellIndex3, int candidate, boolean isStrong, int nodeType) {
        int entry = cellIndex1 << 5 | candidate;
        if (isStrong) {
            entry |= 0x10;
        }
        if (nodeType != 0) {
            switch (nodeType) {
                case 1: {
                    entry |= 0x4000000;
                    break;
                }
                case 2: {
                    entry |= 0x8000000;
                }
            }
        }
        if (cellIndex2 == -1) {
            cellIndex2 = nodeType == 0 ? 0 : 127;
        }
        if (cellIndex3 == -1) {
            cellIndex3 = nodeType == 0 ? 0 : 127;
        }
        entry |= cellIndex2 << 12;
        return entry |= cellIndex3 << 19;
    }

    public void setEntry(int index, int entry) {
        this.chain[index] = entry;
    }

    public void setEntry(int index, int cellIndex, int candidate, boolean isStrong) {
        this.setEntry(index, Chain.makeSEntry(cellIndex, candidate, isStrong));
    }

    public static int getSHigherAlsIndex(int alsIndex) {
        return alsIndex >> 7 & 0x7F;
    }

    public static int getSLowerAlsIndex(int alsIndex) {
        return alsIndex &= 0x7F;
    }

    public static int getSCellIndex(int entry) {
        if (entry > 0) {
            return entry >> 5 & 0x7F;
        }
        return -entry >> 5 & 0x7F;
    }

    public static int getSCellIndex2(int entry) {
        int result = -1;
        result = entry > 0 ? entry >> 12 & 0x7F : -entry >> 12 & 0x7F;
        if (result == 127) {
            result = -1;
        }
        return result;
    }

    public static int getSCellIndex3(int entry) {
        int result = -1;
        result = entry > 0 ? entry >> 19 & 0x7F : -entry >> 19 & 0x7F;
        if (result == 127) {
            result = -1;
        }
        return result;
    }

    public static int getSAlsIndex(int entry) {
        int result = -1;
        if (entry < 0) {
            entry = -entry;
        }
        result = (entry & 0x3FFF000) >> 12;
        return result;
    }

    public static int replaceSAlsIndex(int entry, int newAlsIndex) {
        entry &= 0xFC000FFF;
        newAlsIndex <<= 12;
        return entry |= (newAlsIndex &= 0x3FFF000);
    }

    public void replaceAlsIndex(int entryIndex, int newAlsIndex) {
        this.chain[entryIndex] = Chain.replaceSAlsIndex(this.chain[entryIndex], newAlsIndex);
    }

    public int getCellIndex(int index) {
        return Chain.getSCellIndex(this.chain[index]);
    }

    public static int getSCandidate(int entry) {
        if (entry > 0) {
            return entry & 0xF;
        }
        return -entry & 0xF;
    }

    public int getCandidate(int index) {
        return Chain.getSCandidate(this.chain[index]);
    }

    public static boolean isSStrong(int entry) {
        if (entry > 0) {
            return (entry & 0x10) != 0;
        }
        return (-entry & 0x10) != 0;
    }

    public boolean isStrong(int index) {
        return Chain.isSStrong(this.chain[index]);
    }

    public static int getSNodeType(int entry) {
        if (entry > 0) {
            return (entry & 0x3C000000) >> 26;
        }
        return (-entry & 0x3C000000) >> 26;
    }

    public int getNodeType(int index) {
        return Chain.getSNodeType(this.chain[index]);
    }

    public static int setSStrong(int entry, boolean strong) {
        entry = strong ? (entry |= 0x10) : (entry &= 0xFFFFFFEF);
        return entry;
    }

    public void getNodeBuddies(int index, SudokuSetBase set, List<Als> alses) {
        Chain.getSNodeBuddies(this.chain[index], this.getCandidate(index), alses, set);
    }

    public static void getSNodeBuddies(int entry, int candidate, List<Als> alses, SudokuSetBase set) {
        if (Chain.getSNodeType(entry) == 0) {
            set.set(Sudoku2.buddies[Chain.getSCellIndex(entry)]);
        } else if (Chain.getSNodeType(entry) == 1) {
            set.set(Sudoku2.buddies[Chain.getSCellIndex(entry)]);
            set.and(Sudoku2.buddies[Chain.getSCellIndex2(entry)]);
            if (Chain.getSCellIndex3(entry) != -1) {
                set.and(Sudoku2.buddies[Chain.getSCellIndex3(entry)]);
            }
        } else if (Chain.getSNodeType(entry) == 2) {
            Als als = alses.get(Chain.getSAlsIndex(entry));
            set.set(als.buddiesPerCandidat[candidate]);
        } else {
            set.clear();
            Logger.getLogger(Chain.class.getName()).log(Level.SEVERE, "getSNodeBuddies() gesamt: invalid node type ({0})", Chain.getSNodeType(entry));
        }
    }

    public static String toString(int entry) {
        if (entry == Integer.MIN_VALUE) {
            return "MIN";
        }
        String sign = "";
        if (entry < 0) {
            sign = "-";
        }
        if (Chain.getSNodeType(entry) == 2) {
            return sign + TYPE_NAMES[Chain.getSNodeType(entry)] + "/" + Chain.getSAlsIndex(entry) + "/" + Chain.getSCellIndex(entry) + "/" + Chain.isSStrong(entry) + "/" + Chain.getSCandidate(entry);
        }
        return sign + TYPE_NAMES[Chain.getSNodeType(entry)] + "/" + Chain.getSCellIndex3(entry) + "/" + Chain.getSCellIndex2(entry) + "/" + Chain.getSCellIndex(entry) + "/" + Chain.isSStrong(entry) + "/" + Chain.getSCandidate(entry);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        for (int i = this.start; i <= this.end; ++i) {
            tmp.append(Chain.toString(this.chain[i]));
            tmp.append(" ");
        }
        return tmp.toString();
    }

    public static void main(String[] args) {
        int entry = Chain.makeSEntry(0, 1, true);
        System.out.println("Entry: " + Chain.getSCellIndex(entry) + "/" + Chain.getSCandidate(entry) + "/" + Chain.isSStrong(entry));
    }
}

