/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;

public class ActionSupportForJDK5 {
    public static final String SELECTED_KEY = "SwingSelectedKey";
    public static final String DISPLAYED_MNEMONIC_INDEX_KEY = "SwingDisplayedMnemonicIndexKey";
    public static final String LARGE_ICON_KEY = "SwingLargeIconKey";
    protected static final String CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER = "ActionSupportForJDK5.propertyChangeListener";
    protected static final String CLIENT_PROPERTY_ITEM_LISTENER = "ActionSupportForJDK5.itemListener";

    public static void setActionSelected(Action action, boolean selected) {
        action.putValue(SELECTED_KEY, selected);
    }

    public static boolean isActionSelected(Action action) {
        return Boolean.TRUE.equals(action.getValue(SELECTED_KEY));
    }

    public static void setDisplayedMnemonicIndex(Action action, int newIndex) {
        action.putValue(DISPLAYED_MNEMONIC_INDEX_KEY, newIndex);
    }

    public static boolean hasDisplayedMnemonicIndex(Action action) {
        return action.getValue(DISPLAYED_MNEMONIC_INDEX_KEY) != null;
    }

    public static int getDisplayedMnemonicIndex(Action action) {
        if (ActionSupportForJDK5.hasDisplayedMnemonicIndex(action)) {
            return (Integer)action.getValue(DISPLAYED_MNEMONIC_INDEX_KEY);
        }
        return -1;
    }

    public static void setLargeIcon(Action action, Icon icon) {
        action.putValue(LARGE_ICON_KEY, icon);
    }

    public static Icon getLargeIcon(Action action) {
        Object o = action.getValue(LARGE_ICON_KEY);
        return o instanceof Icon ? (Icon)o : null;
    }

    public static void install(final AbstractButton button, final Action action) {
        if (ActionSupportForJDK5.isActionSelected(action)) {
            ActionSupportForJDK5.setSelectedFromAction(button, action);
        }
        if (ActionSupportForJDK5.getDisplayedMnemonicIndex(action) != -1) {
            ActionSupportForJDK5.setDisplayedMnemonicIndexFromAction(button, action, true);
        }
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionSupportForJDK5.actionPropertyChanged(button, action, e.getPropertyName());
            }
        };
        action.addPropertyChangeListener(listener);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ActionSupportForJDK5.setActionSelected(action, e.getStateChange() == 1);
            }
        };
        button.addItemListener(itemListener);
        button.putClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER, listener);
        button.putClientProperty(CLIENT_PROPERTY_ITEM_LISTENER, itemListener);
    }

    public static void install(AbstractButton button) {
        Action action = button.getAction();
        ActionSupportForJDK5.install(button, action);
    }

    public static void uninstall(AbstractButton button, Action action) {
        Object o = button.getClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER);
        if (o instanceof PropertyChangeListener) {
            action.removePropertyChangeListener((PropertyChangeListener)o);
        }
        if ((o = button.getClientProperty(CLIENT_PROPERTY_ITEM_LISTENER)) instanceof ItemListener) {
            button.removeItemListener((ItemListener)o);
        }
    }

    public static void uninstall(AbstractButton button) {
        Action action = button.getAction();
        ActionSupportForJDK5.uninstall(button, action);
    }

    public static void actionPropertyChanged(AbstractButton button, Action action, String propertyName) {
        if (SELECTED_KEY.equals(propertyName) && ActionSupportForJDK5.hasSelectedKey(action)) {
            ActionSupportForJDK5.setSelectedFromAction(button, action);
        } else if (DISPLAYED_MNEMONIC_INDEX_KEY.equals(propertyName)) {
            ActionSupportForJDK5.setDisplayedMnemonicIndexFromAction(button, action, true);
        } else if (LARGE_ICON_KEY.equals(propertyName)) {
            ActionSupportForJDK5.largeIconChanged(button, action);
        }
    }

    static boolean hasSelectedKey(Action action) {
        return action != null && action.getValue(SELECTED_KEY) != null;
    }

    private static void setSelectedFromAction(AbstractButton button, Action action) {
        boolean flag = false;
        if (action != null) {
            flag = ActionSupportForJDK5.isActionSelected(action);
        }
        if (flag != button.isSelected()) {
            ButtonGroup buttongroup;
            button.setSelected(flag);
            if (!flag && button.isSelected() && button.getModel() instanceof DefaultButtonModel && (buttongroup = ((DefaultButtonModel)button.getModel()).getGroup()) != null) {
                buttongroup.remove(button);
                button.setSelected(false);
                buttongroup.add(button);
            }
        }
    }

    private static void setDisplayedMnemonicIndexFromAction(AbstractButton button, Action action, boolean flag) {
        Integer integer;
        Integer n = integer = action != null ? (Integer)action.getValue(DISPLAYED_MNEMONIC_INDEX_KEY) : null;
        if (flag || integer != null) {
            int i;
            if (integer == null) {
                i = -1;
            } else {
                i = integer;
                String s = button.getText();
                if (s == null || i >= s.length()) {
                    i = -1;
                }
            }
            button.setDisplayedMnemonicIndex(i);
        }
    }

    static void largeIconChanged(AbstractButton button, Action action) {
        ActionSupportForJDK5.setIconFromAction(button, action);
    }

    static void setIconFromAction(AbstractButton button, Action action) {
        Icon icon = null;
        if (action != null && (icon = (Icon)action.getValue(LARGE_ICON_KEY)) == null) {
            icon = (Icon)action.getValue("SmallIcon");
        }
        button.setIcon(icon);
    }
}

