/*
 * Decompiled with CFR 0.152.
 */
package puzzle;

import java.awt.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import puzzle.storeage.StorageUtil;
import puzzle.storeage.Storeable;

public class Offset
implements Storeable {
    private int off_x;
    private int off_y;
    private boolean changed;

    public Offset(int n, int n2) {
        this.off_x = n;
        this.off_y = n2;
        this.changed = false;
    }

    public Offset() {
    }

    public int getX() {
        return this.off_x;
    }

    public int getY() {
        return this.off_y;
    }

    public void addToX(int n) {
        if (n != 0) {
            this.off_x += n;
            this.changed = true;
        }
    }

    public void addToY(int n) {
        if (n != 0) {
            this.off_y += n;
            this.changed = true;
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public String toString() {
        return "Offset: x->" + this.off_x + " y->" + this.off_y + " virgine: " + !this.changed;
    }

    public Point toPoint() {
        return new Point(this.off_x, this.off_y);
    }

    @Override
    public void restore(Node node) throws LoadGameException {
        Node node2 = StorageUtil.findDirectChildNode(node, "Offset");
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItem("X");
        this.off_x = Integer.parseInt(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("Y");
        this.off_y = Integer.parseInt(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("Changed");
        this.changed = Boolean.parseBoolean(node3.getNodeValue());
    }

    @Override
    public void store(Node node) throws SaveGameException {
        Document document = node.getOwnerDocument();
        Element element = document.createElement("Offset");
        element.setAttribute("X", "" + this.off_x);
        element.setAttribute("Y", "" + this.off_y);
        element.setAttribute("Changed", "" + this.changed);
        node.appendChild(element);
    }
}

