/*
 * Decompiled with CFR 0.152.
 */
package puzzle;

import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import puzzle.GameCommander;
import puzzle.edge.Edge;
import puzzle.pieces.PuzzlePiece;
import puzzle.pieces.SinglePiece;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.ui.GameMainWindow;

public class PuzzleBuilder {
    private PuzzlePiece[][] pieceArray;
    private int edgeNumberIndex = 0;
    private List<Point> startPointList;
    private boolean isStartPointListInit = false;
    private Random rand = new Random();

    public void makePieces(int n, int n2) throws JigsawPuzzleException {
        int n3;
        int n4;
        if (n2 < 1 || n < 1) {
            throw new IllegalArgumentException("positive number for columns and rows expected");
        }
        Edge[][][] edgeArray = new Edge[n][n2][4];
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                GeneralPath generalPath;
                int n5;
                if (n4 == 0) {
                    edgeArray[n4][n3][3] = null;
                } else {
                    n5 = edgeArray[n4 - 1][n3][2].getEdgePairNumber();
                    generalPath = GameCommander.getInstance().getEdgeDisposer().findContraryEdgeShape(n5, Edge.Type.LEFT);
                    edgeArray[n4][n3][3] = new Edge(Edge.Type.LEFT, n5, generalPath);
                }
                if (n3 == 0) {
                    edgeArray[n4][n3][0] = null;
                } else {
                    n5 = edgeArray[n4][n3 - 1][1].getEdgePairNumber();
                    generalPath = GameCommander.getInstance().getEdgeDisposer().findContraryEdgeShape(n5, Edge.Type.TOP);
                    edgeArray[n4][n3][0] = new Edge(Edge.Type.TOP, n5, generalPath);
                }
                if (n4 == n - 1) {
                    edgeArray[n4][n3][2] = null;
                } else {
                    n5 = this.edgeNumberIndex++;
                    generalPath = GameCommander.getInstance().getEdgeDisposer().generateNewEdgeShape(n5, Edge.Type.RIGHT);
                    edgeArray[n4][n3][2] = new Edge(Edge.Type.RIGHT, n5, generalPath);
                }
                if (n3 == n2 - 1) {
                    edgeArray[n4][n3][1] = null;
                    continue;
                }
                n5 = this.edgeNumberIndex++;
                generalPath = GameCommander.getInstance().getEdgeDisposer().generateNewEdgeShape(n5, Edge.Type.BOTTOM);
                edgeArray[n4][n3][1] = new Edge(Edge.Type.BOTTOM, n5, generalPath);
            }
        }
        this.pieceArray = new PuzzlePiece[n][n2];
        this.initStartpoints(n, n2);
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.pieceArray[n4][n3] = new SinglePiece(edgeArray[n4][n3], GameCommander.getInstance().getPreferences().getImage().getImage(n4, n3), this.getRandomPointFromList());
                GameCommander.getInstance().getPieceDisposer().addPuzzleStueck(this.pieceArray[n4][n3]);
            }
        }
        if (GameCommander.getInstance().getPreferences().isAllowTurn()) {
            this.turnRandom();
        }
    }

    private void initStartpoints(int n, int n2) {
        int n3;
        this.startPointList = new Vector<Point>();
        int n4 = 0;
        int n5 = 0;
        int n6 = GameCommander.getInstance().getPreferences().getSideLength();
        for (int i = 0; i < n; ++i) {
            n4 += 2 * n6;
            for (n3 = 0; n3 < n2; ++n3) {
                this.startPointList.add(new Point(n4, n5 += 2 * n6));
            }
            n5 = 0;
        }
        Point point = this.startPointList.get(this.startPointList.size() - 1);
        n3 = point.x + 400;
        int n7 = point.y + 200;
        GameMainWindow.getInstance().setBoundaries(n3, n7);
        this.isStartPointListInit = true;
    }

    private void turnRandom() throws JigsawPuzzleException {
        PuzzlePiece[][] puzzlePieceArray = this.pieceArray;
        int n = puzzlePieceArray.length;
        for (int i = 0; i < n; ++i) {
            PuzzlePiece[] puzzlePieceArray2;
            for (PuzzlePiece puzzlePiece : puzzlePieceArray2 = puzzlePieceArray[i]) {
                for (int j = this.rand.nextInt(4); j > 0; --j) {
                    puzzlePiece.turnDegrees(((SinglePiece)puzzlePiece).getPoint(), 90);
                }
            }
        }
    }

    private Point getRandomPointFromList() {
        if (!this.isStartPointListInit) {
            throw new RuntimeException("pointlist not been initiated");
        }
        int n = this.rand.nextInt(this.startPointList.size());
        Point point = this.startPointList.get(n);
        this.startPointList.remove(n);
        return point;
    }
}

