/*
 * Decompiled with CFR 0.152.
 */
package puzzle.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import puzzle.PuzzleProperties;

public class PreviewDialog
extends JDialog {
    private BufferedImage img;
    private JLabel label;

    public PreviewDialog(Frame frame) {
        this.setTitle(PuzzleProperties.getLocalized("viewMenuPreview"));
        this.setResizable(false);
        this.label = new JLabel();
        this.getContentPane().add(this.label);
        this.pack();
    }

    public void loadImage(BufferedImage bufferedImage) {
        this.img = bufferedImage;
        Dimension dimension = new Dimension(this.img.getWidth(null) + 1, this.img.getHeight(null) + 24);
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        this.label.setIcon(imageIcon);
        this.setAlwaysOnTop(true);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    public void unloadImage() {
        this.img = null;
        this.label.setIcon(null);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.img != null) {
            super.setVisible(bl);
        }
    }
}

