/*
 * Decompiled with CFR 0.152.
 */
package puzzle.ui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import puzzle.GameCommander;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import puzzle.storeage.StorageUtil;
import puzzle.storeage.Storeable;

public class PuzzleImage
implements Storeable {
    private static final double QUALTITY_RESIZE_OFFSET = 0.22;
    private BufferedImage originalImage;
    private BufferedImage resizedImage;
    private Dimension resampleSize;

    public static BufferedImage getImageFromFile(File file) throws JigsawPuzzleException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            throw new JigsawPuzzleException("file is not a valid image format.", iOException);
        }
        return bufferedImage;
    }

    public static BufferedImage getImageFromURL(URL uRL) throws JigsawPuzzleException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            throw new JigsawPuzzleException("URL is not a valid one.", iOException);
        }
        return bufferedImage;
    }

    public static BufferedImage getImageFromStream(InputStream inputStream) throws JigsawPuzzleException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (IOException iOException) {
            throw new JigsawPuzzleException("file is not a valid image format.", iOException);
        }
        return bufferedImage;
    }

    public PuzzleImage() {
    }

    public PuzzleImage(BufferedImage bufferedImage) {
        this.originalImage = bufferedImage;
    }

    public PuzzleImage(File file) throws JigsawPuzzleException {
        this.originalImage = PuzzleImage.getImageFromFile(file);
    }

    public PuzzleImage(URL uRL) throws JigsawPuzzleException {
        this.originalImage = PuzzleImage.getImageFromURL(uRL);
    }

    public PuzzleImage(InputStream inputStream) throws JigsawPuzzleException {
        this.originalImage = PuzzleImage.getImageFromStream(inputStream);
    }

    public int getHeight() {
        return this.resizedImage.getHeight();
    }

    public int getWidth() {
        return this.resizedImage.getWidth();
    }

    public BufferedImage getOriginalImage() {
        return this.originalImage;
    }

    public BufferedImage getImage() {
        return this.resizedImage;
    }

    public BufferedImage getImage(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = GameCommander.getInstance().getPreferences().getSideLength();
        int n8 = n * n7;
        int n9 = n2 * n7;
        int n10 = n7 / 2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n == 0) {
            n6 = 0;
            n5 = n7 * 2;
            bl = true;
        } else if (n == GameCommander.getInstance().getPreferences().getColumns() - 1) {
            n6 = n8 - n10;
            n5 = n7 * 2 - n10;
            bl2 = true;
        } else {
            n6 = n8 - n10;
            n5 = n7 * 2;
        }
        if (n2 == 0) {
            n4 = 0;
            n3 = n7 * 2;
            bl3 = true;
        } else if (n2 == GameCommander.getInstance().getPreferences().getRows() - 1) {
            n4 = n9 - n10;
            n3 = n7 * 2 - n10;
            bl4 = true;
        } else {
            n4 = n9 - n10;
            n3 = n7 * 2;
        }
        BufferedImage bufferedImage = new BufferedImage(n7 * 2, n7 * 2, this.resizedImage.getType());
        BufferedImage bufferedImage2 = null;
        try {
            bufferedImage2 = this.resizedImage.getSubimage(n6, n4, n5, n3);
        }
        catch (RasterFormatException rasterFormatException) {
            System.out.println(rasterFormatException.getMessage());
            throw new RuntimeException("no subimage could be created - error");
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n11 = bl ? n7 / 2 : 0;
        int n12 = bl3 ? n7 / 2 : 0;
        graphics2D.drawImage(bufferedImage2, n11, n12, n5, n3, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public boolean isResizableToGoodQuality(int n) {
        double d;
        int n2;
        double d2;
        int n3;
        int n4 = this.originalImage.getWidth();
        int n5 = this.originalImage.getHeight();
        int n6 = n4 % n;
        int n7 = n5 % n;
        int n8 = n - n6;
        int n9 = n - n7;
        if (n8 < n6) {
            n3 = n4 + n8;
            d2 = (double)n3 / (double)n4 - 1.0;
        } else {
            n3 = n4 - n6;
            d2 = (double)n4 / (double)n3 - 1.0;
        }
        if (n9 < n7) {
            n2 = n5 + n9;
            d = (double)n2 / (double)n5 - 1.0;
        } else {
            n2 = n5 - n7;
            d = (double)n5 / (double)n2 - 1.0;
        }
        this.resampleSize = new Dimension(n3, n2);
        return d2 < 0.22 && d < 0.22;
    }

    public void resize() {
        if (this.resampleSize != null) {
            Image image = this.originalImage.getScaledInstance(this.resampleSize.width, this.resampleSize.height, 4);
            if (image instanceof BufferedImage) {
                this.resizedImage = (BufferedImage)image;
            } else {
                BufferedImage bufferedImage = new BufferedImage(this.resampleSize.width, this.resampleSize.height, 5);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                graphics2D.dispose();
                this.resizedImage = bufferedImage;
            }
        } else {
            throw new RuntimeException("call the isResizable method first - this will init");
        }
    }

    public Image resizeToFit(Dimension dimension) {
        double d;
        double d2;
        double d3;
        int n = this.originalImage.getHeight();
        int n2 = this.originalImage.getWidth();
        double d4 = (double)dimension.width / (double)n2;
        double d5 = (double)dimension.height / (double)n;
        double d6 = Math.abs(d4);
        if (d6 < (d3 = Math.abs(d5))) {
            d2 = (double)n2 * d4;
            d = (double)n * d4;
        } else {
            d2 = (double)n2 * d5;
            d = (double)n * d5;
        }
        return this.originalImage.getScaledInstance((int)d2, (int)d, 4);
    }

    public Dimension getResampleSize() {
        return this.resampleSize;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        System.out.println("write image");
        ImageIO.write((RenderedImage)this.originalImage, "png", objectOutputStream);
        objectOutputStream.flush();
        System.out.println("wrote image");
        System.out.println("write dimension");
        objectOutputStream.writeObject(this.resampleSize);
        System.out.println("wrote dimension");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.println("read image");
        this.originalImage = ImageIO.read(objectInputStream);
        System.out.println("read image");
        System.out.println("read dim");
        Dimension dimension = (Dimension)objectInputStream.readObject();
        System.out.println("read dim");
        this.resampleSize = dimension;
        this.resize();
    }

    @Override
    public void restore(Node node) throws LoadGameException {
        Node node2 = StorageUtil.findDirectChildNode(node, "PuzzleImage");
        byte[] byArray = StorageUtil.restoreBinaryData(node2, "ImageData");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.originalImage = ImageIO.read(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LoadGameException(iOException);
        }
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItem("resampleSizeWidth");
        int n = Integer.parseInt(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("resampleSizeHeigth");
        int n2 = Integer.parseInt(node3.getNodeValue());
        this.resampleSize = new Dimension(n, n2);
        this.resize();
    }

    @Override
    public void store(Node node) throws SaveGameException {
        Document document = node.getOwnerDocument();
        Element element = document.createElement("PuzzleImage");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.originalImage, "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SaveGameException(iOException);
        }
        StorageUtil.storeBinaryData(element, "ImageData", byteArrayOutputStream.toByteArray());
        element.setAttribute("resampleSizeWidth", "" + this.resampleSize.width);
        element.setAttribute("resampleSizeHeigth", "" + this.resampleSize.height);
        node.appendChild(element);
    }
}

