/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.swing.GrayFilter;

public class ImageHandler {
    Image original;
    Component comp;
    int scalingType = 4;

    public ImageHandler(Image image, Component component) {
        this.original = image;
        this.comp = component;
    }

    public ImageHandler(String string, String string2, Component component) {
        this(String.valueOf(string) + File.separator + string2, component);
    }

    public ImageHandler(String string, Component component) {
        try {
            URL uRL = new URL(string);
            this.original = Toolkit.getDefaultToolkit().getImage(uRL);
            this.comp = component;
            return;
        }
        catch (Exception exception) {
            Serializable serializable;
            try {
                serializable = new File(string);
                if (((File)serializable).exists()) {
                    this.original = Toolkit.getDefaultToolkit().getImage(((File)serializable).getAbsolutePath());
                    this.comp = component;
                    return;
                }
                serializable = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + string);
                if (((File)serializable).exists()) {
                    this.original = Toolkit.getDefaultToolkit().getImage(((File)serializable).getAbsolutePath());
                    this.comp = component;
                    return;
                }
            }
            catch (Exception exception2) {}
            serializable = component.getClass().getResource(string);
            this.original = serializable != null ? Toolkit.getDefaultToolkit().getImage((URL)serializable) : component.createImage(40, 40);
            this.comp = component;
            return;
        }
    }

    public ImageHandler(File file, Component component) {
        this.original = !file.exists() ? component.createImage(40, 40) : Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        this.comp = component;
    }

    public ImageHandler(URL uRL, Component component) {
        this.original = Toolkit.getDefaultToolkit().getImage(uRL);
        this.comp = component;
    }

    public ImageHandler setScalingType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                this.scalingType = n;
            }
        }
        return this;
    }

    public int getScalingType() {
        return this.scalingType;
    }

    public Image getImage() {
        return this.original;
    }

    public int getWidth() {
        return this.original.getWidth(this.comp);
    }

    public int getHeight() {
        return this.original.getHeight(this.comp);
    }

    public Dimension getSize() {
        return new Dimension(this.original.getWidth(this.comp), this.original.getHeight(this.comp));
    }

    public ImageHandler scale(Dimension dimension) {
        return this.scale(dimension.width, dimension.height);
    }

    public ImageHandler scale(int n, int n2) {
        return new ImageHandler(this.original.getScaledInstance(n, n2, this.scalingType), this.comp);
    }

    public ImageHandler crop(Rectangle rectangle) {
        return this.crop(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public ImageHandler crop(int n, int n2, int n3, int n4) {
        try {
            Image image = this.comp.createImage(n3, n4);
            if (image == null) {
                return this;
            }
            Graphics graphics = image.getGraphics();
            graphics.setColor(this.comp.getBackground());
            graphics.fillRect(0, 0, n3, n4);
            graphics.drawImage(this.original, -n, -n2, this.comp);
            graphics.dispose();
            return new ImageHandler(image, this.comp);
        }
        catch (Exception exception) {
            return this;
        }
    }

    public ImageHandler gray() {
        return this.gray(true, 50);
    }

    public ImageHandler gray(boolean bl, int n) {
        try {
            GrayFilter grayFilter = new GrayFilter(bl, n);
            FilteredImageSource filteredImageSource = new FilteredImageSource(this.original.getSource(), grayFilter);
            Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            return new ImageHandler(image, this.comp);
        }
        catch (Exception exception) {
            return this;
        }
    }
}

