/*
 * Decompiled with CFR 0.152.
 */
package datarep.common;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;

public class TabbedCardPanel
extends Container
implements MouseListener,
AdjustmentListener,
ItemSelectable {
    Vector names = new Vector(6, 3);
    int[] pos;
    int height;
    int tab;
    int num;
    int currentPage;
    int hgap;
    int vgap;
    Vector itemListeners = new Vector(2, 1);

    public TabbedCardPanel() {
        this(0, 0);
    }

    public TabbedCardPanel(int n, int n2) {
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        super.setLayout(null);
        this.addMouseListener(this);
        this.hgap = n;
        this.vgap = n2;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public synchronized Component add(Component component, String string, int n) {
        this.names.insertElementAt(string, n);
        super.add(component, n);
        component.invalidate();
        this.validate();
        this.repaint();
        return component;
    }

    public synchronized Component add(String string, Component component, int n) {
        return this.add(component, string, n);
    }

    public synchronized Component add(Component component, String string) {
        return this.add(component, string, this.names.size());
    }

    public synchronized Component add(String string, Component component) {
        return this.add(component, string, this.names.size());
    }

    public void remove(Component component) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) {
                this.remove(n);
                return;
            }
            ++n;
        }
    }

    public void remove(String string) {
        int n = 0;
        while (n < this.names.size()) {
            if (((String)this.names.elementAt(n)).equals(string)) {
                this.remove(n);
                return;
            }
            ++n;
        }
    }

    public synchronized void remove(int n) {
        if (n < 0 || n >= this.names.size()) {
            return;
        }
        super.remove(n);
        this.names.removeElementAt(n);
        if (n < this.currentPage) {
            --this.currentPage;
        } else if (n == this.currentPage) {
            this.currentPage = 0;
        }
        this.repaint();
    }

    public synchronized void removeAll() {
        this.names.removeAllElements();
        super.removeAll();
        this.currentPage = 0;
        this.repaint();
    }

    public Object[] getSelectedObjects() {
        return new Component[]{this.getSelectedCard()};
    }

    public Component getSelectedCard() {
        return this.getComponent(this.currentPage);
    }

    public String getSelectedTab() {
        return (String)this.names.elementAt(this.currentPage);
    }

    public int getSelectedIndex() {
        return this.currentPage;
    }

    public void show(String string) {
        int n = 0;
        while (n < this.names.size()) {
            if (((String)this.names.elementAt(n)).equals(string)) {
                this.show(n);
                return;
            }
            ++n;
        }
    }

    public void show(Component component) {
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            if (component == this.getComponent(n2)) {
                this.show(n2);
                return;
            }
            ++n2;
        }
    }

    public void show(int n) {
        if (n < 0 || n >= this.names.size()) {
            return;
        }
        this.currentPage = n;
        this.invalidate();
        this.validate();
        this.repaint();
        this.requestFocus();
        if (this.itemListeners.size() > 0) {
            this.postItemStateChanged();
        }
    }

    public void doLayout() {
        int n = this.getComponentCount();
        Insets insets = this.getInsets();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            component.setBounds(insets.left, insets.top, this.getSize().width - insets.left - insets.right, this.getSize().height - insets.top - insets.bottom);
            component.setVisible(n2 == this.currentPage);
            ++n2;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getY() < this.height + this.tab) {
            int n = 0;
            while (n < this.pos.length - 1) {
                if (mouseEvent.getX() > this.pos[n] && mouseEvent.getX() < this.pos[n + 1]) {
                    this.show(n);
                    return;
                }
                ++n;
            }
        }
    }

    public void paint(Graphics graphics) {
        this.num = this.names.size();
        if (this.num == 0) {
            return;
        }
        this.drawThePages(graphics);
        super.paint(graphics);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Cloneable cloneable;
        int n = 0;
        int n2 = 0;
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            cloneable = componentArray[n3].getPreferredSize();
            n = n > ((Dimension)cloneable).width ? n : ((Dimension)cloneable).width;
            n2 = n2 > ((Dimension)cloneable).height ? n2 : ((Dimension)cloneable).height;
            ++n3;
        }
        cloneable = this.getInsets();
        return new Dimension(n + cloneable.left + cloneable.right, n2 + cloneable.top + cloneable.bottom);
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getHgap() {
        return this.hgap;
    }

    public Insets getInsets() {
        try {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = 2 * fontMetrics.stringWidth("n");
            return new Insets(fontMetrics.getHeight() * 3 / 2 + n + this.vgap, n + this.hgap, n + this.vgap, n + this.hgap);
        }
        catch (NullPointerException nullPointerException) {
            return new Insets(20 + this.vgap, 8 + this.hgap, 8 + this.vgap, 8 + this.hgap);
        }
    }

    private String getCutName(int n, int n2, boolean bl) {
        String string = (String)this.names.elementAt(n);
        if (n2 >= string.length()) {
            return string;
        }
        if (bl) {
            return String.valueOf(string.substring(0, n2)) + "...";
        }
        return string.substring(0, n2);
    }

    private void drawThePages(Graphics graphics) {
        int n;
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.tab = fontMetrics.stringWidth("n");
        this.height = fontMetrics.getHeight() * 3 / 2;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.num) {
            n2 = Math.max(((String)this.names.elementAt(n3)).length(), n2);
            ++n3;
        }
        while (true) {
            this.pos = new int[this.num + 1];
            this.pos[0] = this.tab + 6;
            n = 1;
            while (n < this.num + 1) {
                this.pos[n] = fontMetrics.stringWidth(this.getCutName(n - 1, n2, false)) + 4 * this.tab + this.pos[n - 1];
                ++n;
            }
            if (this.pos[this.num] < dimension.width - this.tab || n2 == 0) break;
            --n2;
        }
        n = this.num - 1;
        while (n > -1) {
            graphics.setColor(this.getForeground());
            graphics.drawString(this.getCutName(n, n2, true), this.pos[n] + 2 * this.tab, this.height * 2 / 3 + this.tab + 1);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(this.pos[n], this.height + this.tab, this.pos[n] + this.tab, 2 + this.tab);
            graphics.drawLine(this.pos[n] + this.tab, 2 + this.tab, this.pos[n + 1] - this.tab, 2 + this.tab);
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(this.pos[n + 1] - this.tab, 2 + this.tab, this.pos[n + 1], this.height - 1 + this.tab);
            graphics.setColor(Color.black);
            graphics.drawLine(this.pos[n + 1] - this.tab + 1, 3 + this.tab, this.pos[n + 1] + 1, this.height - 1 + this.tab);
            --n;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(this.pos[this.currentPage], this.height - 4 + this.tab, this.tab, 5);
        graphics.setColor(this.getBackground().brighter());
        graphics.drawLine(this.tab, this.height + this.tab, this.tab, dimension.height - this.tab);
        graphics.drawLine(this.pos[this.currentPage], this.height + this.tab, this.pos[this.currentPage] + this.tab, 2 + this.tab);
        graphics.drawLine(this.tab, this.height + this.tab, this.pos[this.currentPage], this.height + this.tab);
        graphics.drawLine(this.pos[this.currentPage + 1], this.height + this.tab, dimension.width - this.tab, this.height + this.tab);
        graphics.setColor(this.getBackground().darker());
        graphics.drawLine(dimension.width - this.tab, this.height + this.tab, dimension.width - this.tab, dimension.height - this.tab);
        graphics.drawLine(this.tab, dimension.height - this.tab, dimension.width - this.tab, dimension.height - this.tab);
        graphics.setColor(Color.black);
        graphics.drawLine(dimension.width - this.tab + 1, this.height + 1 + this.tab, dimension.width - this.tab + 1, dimension.height - this.tab + 1);
        graphics.drawLine(this.tab + 1, dimension.height - this.tab + 1, dimension.width - this.tab + 1, dimension.height - this.tab + 1);
    }

    public void addNotify() {
        super.addNotify();
        Container container = this;
        while (container != null) {
            if (!((container = container.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)container).getHAdjustable().addAdjustmentListener(this);
            ((ScrollPane)container).getVAdjustable().addAdjustmentListener(this);
        }
    }

    public void removeNotify() {
        Container container = this;
        while (container != null) {
            if (!((container = container.getParent()) instanceof ScrollPane)) continue;
            ((ScrollPane)container).getHAdjustable().removeAdjustmentListener(this);
            ((ScrollPane)container).getVAdjustable().removeAdjustmentListener(this);
        }
        super.removeNotify();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.repaint();
    }

    public String toString() {
        String string = super.toString();
        int n = 0;
        while (n < this.names.size()) {
            string = String.valueOf(string) + "\n" + (String)this.names.elementAt(n);
            ++n;
        }
        return string;
    }

    private void postItemStateChanged() {
        ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedCard(), 1);
        Enumeration enumeration = this.itemListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
        }
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners.addElement(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners.removeElement(itemListener);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Test of TabbedCardPanel");
        frame.setLayout(new BorderLayout());
        TabbedCardPanel tabbedCardPanel = new TabbedCardPanel();
        tabbedCardPanel.add((Component)new Button("One"), "One");
        tabbedCardPanel.add((Component)new Button("Two"), "Two");
        tabbedCardPanel.add((Component)new Button("Three"), "Three");
        frame.add("Center", tabbedCardPanel);
        frame.pack();
        frame.show();
    }
}

