/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MinesweeperGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private boolean firstKlick = true;
    private boolean spielVorbei = false;
    public static JHighscore aktuelleTabelle;
    public static StatistikGUI aktuelleStatistik;
    private int gridSpalten;
    private int gridZeilen;
    private int maxMinen;
    private int verbleibendeMinen;
    private int verstricheneZeit = 0;
    private static JButtonZustand[][] grid;
    public static int[][] gridMinen;
    private boolean klickInvertiert = false;
    private JLabel bildMine;
    private JLabel bildUhr;
    private JTextField minenAnzeige = new JTextField(3);
    private JTextField zeitAnzeige = new JTextField(3);
    private JButton startButton = new JButton("New Game");
    private JButton tastaturButton = new JButton("Keyboard Layout");
    private JButton anleitungButton = new JButton("Instructions");
    private JButton modusButton = new JButton("Mode: normal");
    private JPanel panelGesamt = new JPanel();
    private JPanel panelInfo = new JPanel();
    private JPanel panelUnten = new JPanel();
    private JPanel panelModus = new JPanel();
    private JTabbedPane tabGame = new JTabbedPane();
    ActionListener taskPerformer = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            MinesweeperGUI minesweeperGUI = MinesweeperGUI.this;
            minesweeperGUI.verstricheneZeit = minesweeperGUI.verstricheneZeit + 1;
            MinesweeperGUI.this.zeitAnzeige.setText(Integer.toString(MinesweeperGUI.this.verstricheneZeit));
        }
    };
    private int delay = 1000;
    Timer timer1 = new Timer(this.delay, this.taskPerformer);

    static {
        aktuelleStatistik = MainMinesweeper.statistikEinfach;
    }

    public int getSpalten() {
        return this.gridSpalten;
    }

    public void setNeueGroesse(int gridSpalten, int gridZeilen, int maxMinen) {
        this.gridSpalten = gridSpalten;
        this.gridZeilen = gridZeilen;
        this.maxMinen = maxMinen;
    }

    public static JButtonZustand[][] getGrid() {
        return grid;
    }

    public MinesweeperGUI(int gridSpalten, int gridZeilen, int maxMinen) {
        super("MineSweeper for Java");
        this.gridSpalten = gridSpalten;
        this.gridZeilen = gridZeilen;
        this.maxMinen = maxMinen;
        this.verbleibendeMinen = maxMinen;
        grid = new JButtonZustand[gridSpalten][gridZeilen];
        gridMinen = new int[gridSpalten][gridZeilen];
        this.panelGesamt.setLayout(new BorderLayout());
        JPanel panelAnzeige = new JPanel();
        this.minenAnzeige.setEditable(false);
        this.minenAnzeige.setText(Integer.toString(this.verbleibendeMinen));
        this.zeitAnzeige.setEditable(false);
        this.zeitAnzeige.setText(Integer.toString(this.verstricheneZeit));
        panelAnzeige.setLayout(new FlowLayout());
        MainMinesweeper.iconMine.setImage(MainMinesweeper.iconMine.getImage().getScaledInstance(25, 25, 4));
        this.bildMine = new JLabel(MainMinesweeper.iconMine);
        panelAnzeige.add(this.bildMine);
        panelAnzeige.add(this.minenAnzeige);
        panelAnzeige.add(this.startButton);
        this.startButton.addActionListener(new StartActionListener());
        panelAnzeige.add(this.zeitAnzeige);
        MainMinesweeper.iconUhr.setImage(MainMinesweeper.iconUhr.getImage().getScaledInstance(25, 25, 4));
        this.bildUhr = new JLabel(MainMinesweeper.iconUhr);
        panelAnzeige.add(this.bildUhr);
        panelAnzeige.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelGesamt.add((Component)panelAnzeige, "First");
        JPanel panelGrid = new JPanel();
        panelGrid.setLayout(new GridLayout(this.gridSpalten, this.gridZeilen));
        int y = 0;
        while (y < grid.length) {
            int x = 0;
            while (x < grid[y].length) {
                MinesweeperGUI.grid[x][y] = new JButtonZustand("", x, y);
                grid[x][y].addActionListener(new MyActionListener());
                grid[x][y].addMouseListener(new MyListener());
                panelGrid.add(grid[x][y]);
                ++x;
            }
            ++y;
        }
        panelGrid.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelGesamt.add((Component)panelGrid, "Center");
        this.anleitungButton.addActionListener(new StartActionListener());
        this.tastaturButton.addActionListener(new StartActionListener());
        this.modusButton.addActionListener(new StartActionListener());
        this.panelUnten.add(this.tastaturButton);
        this.panelUnten.add(this.anleitungButton);
        this.panelInfo.setLayout(new BorderLayout());
        this.panelInfo.add((Component)this.panelUnten, "First");
        this.panelModus.setLayout(new FlowLayout());
        this.panelModus.add(this.modusButton);
        this.panelInfo.add((Component)this.panelModus, "Last");
        this.panelInfo.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelGesamt.add((Component)this.panelInfo, "Last");
        this.tabGame.addTab("Game", this.panelGesamt);
        this.tabGame.addTab("Options", MainMinesweeper.start1);
        if (this.maxMinen == 10) {
            aktuelleTabelle = MainMinesweeper.highscoreEinfach;
            aktuelleStatistik = MainMinesweeper.statistikEinfach;
        } else if (this.maxMinen == 40) {
            aktuelleTabelle = MainMinesweeper.highscoreFortgeschritten;
            aktuelleStatistik = MainMinesweeper.statistikFortgeschritten;
        } else if (this.maxMinen == 80) {
            aktuelleTabelle = MainMinesweeper.highscoreProfi;
            aktuelleStatistik = MainMinesweeper.statistikProfi;
        }
        this.tabGame.addTab("Highscore", aktuelleTabelle);
        JPanel panelCredits = new JPanel();
        panelCredits.setLayout(new BoxLayout(panelCredits, 1));
        panelCredits.setBorder(BorderFactory.createEtchedBorder(0));
        panelCredits.add(new JLabel("Minesweeper4Java"));
        panelCredits.add(new JLabel("Version: v1.02"));
        panelCredits.add(new JLabel("Copyleft 2011-2012"));
        panelCredits.add(new JLabel("by Oliver Gerhardt"));
        this.tabGame.addTab("About", panelCredits);
        this.add(this.tabGame);
        this.setDefaultCloseOperation(3);
    }

    public void minenLegen() {
        int gelegteMinen = 0;
        while (gelegteMinen < this.maxMinen) {
            int zufallszahlY;
            int zufallszahlX = (int)(Math.random() * (double)this.gridSpalten);
            if (gridMinen[zufallszahlX][zufallszahlY = (int)(Math.random() * (double)this.gridZeilen)] == 1) continue;
            grid[zufallszahlX][zufallszahlY].mineSetzen();
            MinesweeperGUI.gridMinen[zufallszahlX][zufallszahlY] = 1;
            ++gelegteMinen;
        }
        this.zustaendeSetzen();
    }

    public void zustaendeSetzen() {
        int i = 0;
        while (i < grid.length) {
            int j = 0;
            while (j < grid[i].length) {
                if (!grid[i][j].istMine()) {
                    grid[i][j].setZustand();
                } else {
                    grid[i][j].setZustandMine();
                }
                ++j;
            }
            ++i;
        }
    }

    public void spielGewonnen() {
        if (JButtonZustand.getAufgedeckteFelder() == this.gridSpalten * this.gridZeilen) {
            this.timer1.stop();
            if (AuswahlBildschirm.getSoundOn()) {
                JButtonZustand.win.play();
            }
            JOptionPane.showMessageDialog(MainMinesweeper.game1, "Congratulation! You've won!\n\nYour time: " + this.verstricheneZeit);
            if (aktuelleTabelle.nochPlatz(this.verstricheneZeit)) {
                String name = JOptionPane.showInputDialog(MainMinesweeper.game1, (Object)"Congratulation! You have reached a new high score!\nPlease enter your name: ");
                aktuelleTabelle.highscoreEintragen(name, this.verstricheneZeit);
            }
            this.spielVorbei = true;
            aktuelleStatistik.gewonnen();
        }
    }

    public void spielVerloren() {
        this.timer1.stop();
        this.minenAnzeigen();
        JOptionPane.showMessageDialog(MainMinesweeper.game1, "Game over! You've hit the bomb!");
        this.spielVorbei = true;
        aktuelleStatistik.verloren();
    }

    private void minenAnzeigen() {
        int i = 0;
        while (i < gridMinen.length) {
            int j = 0;
            while (j < gridMinen[i].length) {
                if (gridMinen[i][j] == 1 && !grid[i][j].getFlagge()) {
                    grid[i][j].mineMalen(true);
                } else if (grid[i][j].getFlagge() && gridMinen[i][j] == 0) {
                    grid[i][j].mineMalen(false);
                } else {
                    grid[i][j].setEnabled(false);
                }
                ++j;
            }
            ++i;
        }
    }

    private void linksKlick(int x, int y) {
        if (this.firstKlick) {
            this.timer1.start();
        }
        this.firstKlick = false;
        if (!this.spielVorbei) {
            if (grid[x][y].getUnbekannt()) {
                grid[x][y].aufdecken();
            } else if (grid[x][y].getZustand() < 9 && grid[x][y].getZustand() == grid[x][y].flaggenSuche(grid)) {
                grid[x][y].rundOeffnen(grid);
            }
        }
    }

    private void rechtsKlick(int x, int y) {
        if (!this.spielVorbei) {
            if (grid[x][y].getUnbekannt() && !grid[x][y].getFlagge() && this.verbleibendeMinen > 0) {
                grid[x][y].setFlagge();
                --this.verbleibendeMinen;
                this.minenAnzeige.setText(Integer.toString(this.verbleibendeMinen));
            } else if (grid[x][y].getFlagge() && this.verbleibendeMinen >= 0) {
                grid[x][y].removeFlagge();
                ++this.verbleibendeMinen;
                this.minenAnzeige.setText(Integer.toString(this.verbleibendeMinen));
            }
        }
    }

    public void anleitungAnzeigen() {
        String text = "Minesweeper is a deceptively simple game of memory and reasoning.\nThe object of Minesweeper is to overturn blank squares and avoid those that conceal mines.\nIf you click a mine, the game is over.\nUncover all the blank squares as fast as possible for the highest score.";
        JOptionPane.showMessageDialog(MainMinesweeper.game1, text);
    }

    public void tastaturAnzeigen() {
        String text = "Left Mouse:     Open field / 'Quick-Open' on digits\nRechte Maustaste:   Place flag / Remove flag";
        JOptionPane.showMessageDialog(MainMinesweeper.game1, text);
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int y = 0;
            while (y < grid.length) {
                int x = 0;
                while (x < grid[y].length) {
                    if (e.getSource() == grid[x][y]) {
                        if (!MinesweeperGUI.this.klickInvertiert) {
                            MinesweeperGUI.this.linksKlick(x, y);
                        } else if (grid[x][y].getZustand() < 9 && grid[x][y].getZustand() != -1 && !grid[x][y].getUnbekannt() && !grid[x][y].getFlagge()) {
                            MinesweeperGUI.this.klickInvertiert = false;
                            if (grid[x][y].getZustand() == grid[x][y].flaggenSuche(grid)) {
                                grid[x][y].rundOeffnen(grid);
                            }
                            MinesweeperGUI.this.klickInvertiert = true;
                        } else {
                            MinesweeperGUI.this.rechtsKlick(x, y);
                        }
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    class MyListener
    extends MouseAdapter {
        MyListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int y = 0;
            while (y < grid.length) {
                int x = 0;
                while (x < grid[y].length) {
                    if (e.getSource() == grid[x][y] && SwingUtilities.isRightMouseButton(e)) {
                        if (!MinesweeperGUI.this.klickInvertiert) {
                            MinesweeperGUI.this.rechtsKlick(x, y);
                        } else {
                            MinesweeperGUI.this.linksKlick(x, y);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            if (!MinesweeperGUI.this.spielVorbei) {
                MinesweeperGUI.this.spielGewonnen();
            }
        }
    }

    class StartActionListener
    implements ActionListener {
        StartActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MinesweeperGUI.this.startButton) {
                MainMinesweeper.starteSpielNeu(aktuelleStatistik);
            } else if (e.getSource() == MinesweeperGUI.this.anleitungButton) {
                MinesweeperGUI.this.anleitungAnzeigen();
            } else if (e.getSource() == MinesweeperGUI.this.tastaturButton) {
                MinesweeperGUI.this.tastaturAnzeigen();
            } else if (e.getActionCommand() == "Mode: normal") {
                MinesweeperGUI.this.klickInvertiert = true;
                MinesweeperGUI.this.modusButton.setText("Mode: mine");
            } else if (e.getActionCommand() == "Mode: mine") {
                MinesweeperGUI.this.klickInvertiert = false;
                MinesweeperGUI.this.modusButton.setText("Mode: normal");
            }
        }
    }
}

