/*
 * Decompiled with CFR 0.152.
 */
package org.demarchi.jpeces.comuns;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.demarchi.jpeces.comuns.Constants;
import org.demarchi.jpeces.comuns.FiguraResolta;
import org.demarchi.jpeces.comuns.RecordsPersonals;

public class ConfiguracioJoc
implements Serializable,
Constants,
Cloneable {
    public int tipusTangram = 1;
    public int nivellJoc = 4;
    public double angleRotacio = 1.0;
    public boolean mostraSilueta = true;
    public boolean jocIniciat = false;
    public boolean figuraPerResoldre = false;
    public String nomJocArbreFigures = "Fig_T7";
    public String nomNivellArbreFigures = "nivell.expert";
    public ArrayList figuresResoltes = new ArrayList();
    public ArrayList recordsPersonals = new ArrayList();
    public boolean colocaPeca = false;
    public int origenDades = 2;
    public String arxiuDadesFigures = "t7.fig";

    public void ConfiguracioJoc(int tipus, int nivell) {
        this.tipusTangram = tipus;
        this.canviaTipusTangram(tipus);
        this.canviaNivellJoc(nivell);
        this.figuresResoltes = new ArrayList();
        this.recordsPersonals = new ArrayList();
        this.origenDades = 2;
    }

    public void canviaTipusTangram(int tipus) {
        this.tipusTangram = tipus;
        switch (tipus) {
            case 14: {
                this.arxiuDadesFigures = "tb.fig";
                this.nomJocArbreFigures = "Fig_TB";
                break;
            }
            case 19: {
                this.arxiuDadesFigures = "t4.fig";
                this.nomJocArbreFigures = "Fig_T4";
                break;
            }
            case 30: {
                this.arxiuDadesFigures = "t4II.fig";
                this.nomJocArbreFigures = "Fig_T4II";
                break;
            }
            case 27: {
                this.arxiuDadesFigures = "tsl.fig";
                this.nomJocArbreFigures = "Fig_TSL";
                break;
            }
            case 25: {
                this.arxiuDadesFigures = "treg.fig";
                this.nomJocArbreFigures = "Fig_REG";
                break;
            }
            case 2: {
                this.arxiuDadesFigures = "t5.fig";
                this.nomJocArbreFigures = "Fig_T5";
                break;
            }
            case 23: {
                this.arxiuDadesFigures = "t6II.fig";
                this.nomJocArbreFigures = "Fig_T6II";
                break;
            }
            case 3: {
                this.arxiuDadesFigures = "t6.fig";
                this.nomJocArbreFigures = "Fig_T6";
                break;
            }
            case 1: {
                this.arxiuDadesFigures = "t7.fig";
                this.nomJocArbreFigures = "Fig_T7";
                break;
            }
            case 21: {
                this.arxiuDadesFigures = "t7I.fig";
                this.nomJocArbreFigures = "Fig_T7I";
                break;
            }
            case 24: {
                this.arxiuDadesFigures = "t7II.fig";
                this.nomJocArbreFigures = "Fig_T7II";
                break;
            }
            case 26: {
                this.arxiuDadesFigures = "thep.fig";
                this.nomJocArbreFigures = "Fig_THEP";
                break;
            }
            case 4: {
                this.arxiuDadesFigures = "tf.fig";
                this.nomJocArbreFigures = "Fig_TF";
                break;
            }
            case 5: {
                this.arxiuDadesFigures = "tx.fig";
                this.nomJocArbreFigures = "Fig_TX";
                break;
            }
            case 6: {
                this.arxiuDadesFigures = "ts.fig";
                this.nomJocArbreFigures = "Fig_TS";
                break;
            }
            case 7: {
                this.arxiuDadesFigures = "t8.fig";
                this.nomJocArbreFigures = "Fig_T8";
                break;
            }
            case 22: {
                this.arxiuDadesFigures = "tCII.fig";
                this.nomJocArbreFigures = "Fig_TCII";
                break;
            }
            case 8: {
                this.arxiuDadesFigures = "t9.fig";
                this.nomJocArbreFigures = "Fig_T9";
                break;
            }
            case 28: {
                this.arxiuDadesFigures = "t9t.fig";
                this.nomJocArbreFigures = "Fig_T9T";
                break;
            }
            case 9: {
                this.arxiuDadesFigures = "t10.fig";
                this.nomJocArbreFigures = "Fig_T10";
                break;
            }
            case 29: {
                this.arxiuDadesFigures = "te.fig";
                this.nomJocArbreFigures = "Fig_TE";
                break;
            }
            case 33: {
                this.arxiuDadesFigures = "el.fig";
                this.nomJocArbreFigures = "Fig_EL";
                break;
            }
            case 20: {
                this.arxiuDadesFigures = "tcI.fig";
                this.nomJocArbreFigures = "Fig_TCIRI";
                break;
            }
            case 10: {
                this.arxiuDadesFigures = "t11.fig";
                this.nomJocArbreFigures = "Fig_T11";
                break;
            }
            case 11: {
                this.arxiuDadesFigures = "tr.fig";
                this.nomJocArbreFigures = "Fig_TR";
                break;
            }
            case 12: {
                this.arxiuDadesFigures = "t13.fig";
                this.nomJocArbreFigures = "Fig_T13";
                break;
            }
            case 13: {
                this.arxiuDadesFigures = "t14.fig";
                this.nomJocArbreFigures = "Fig_T14";
                break;
            }
            case 15: {
                this.arxiuDadesFigures = "th.fig";
                this.nomJocArbreFigures = "Fig_TH";
                break;
            }
            case 16: {
                this.arxiuDadesFigures = "tou.fig";
                this.nomJocArbreFigures = "Fig_TOU";
                break;
            }
            case 17: {
                this.arxiuDadesFigures = "tc.fig";
                this.nomJocArbreFigures = "Fig_COR";
                break;
            }
            case 32: {
                this.arxiuDadesFigures = "tstIII.fig";
                this.nomJocArbreFigures = "Fig_STIII";
                break;
            }
            case 18: {
                this.arxiuDadesFigures = "tst.fig";
                this.nomJocArbreFigures = "Fig_ST";
                break;
            }
            case 31: {
                this.arxiuDadesFigures = "tstII.fig";
                this.nomJocArbreFigures = "Fig_STII";
                break;
            }
            case 34: {
                this.arxiuDadesFigures = "t8e.fig";
                this.nomJocArbreFigures = "Fig_T8E";
                break;
            }
            case 35: {
                this.arxiuDadesFigures = "t12.fig";
                this.nomJocArbreFigures = "Fig_T12";
                break;
            }
            case 36: {
                this.arxiuDadesFigures = "t5II.fig";
                this.nomJocArbreFigures = "Fig_T5II";
                break;
            }
            case 37: {
                this.arxiuDadesFigures = "ta.fig";
                this.nomJocArbreFigures = "Fig_TA";
                break;
            }
            case 38: {
                this.arxiuDadesFigures = "trec.fig";
                this.nomJocArbreFigures = "Fig_TREC";
                break;
            }
            case 39: {
                this.arxiuDadesFigures = "t16.fig";
                this.nomJocArbreFigures = "Fig_T16";
                break;
            }
            default: {
                this.arxiuDadesFigures = "t7.fig";
                this.nomJocArbreFigures = "Fig_T7";
            }
        }
        this.actualitzaAngleGir();
    }

    public void canviaNivellJoc(int nivell) {
        switch (nivell) {
            case 1: {
                this.nivellJoc = 1;
                this.angleRotacio = 45.0;
                this.mostraSilueta = true;
                this.nomNivellArbreFigures = "nivell.infantil";
                break;
            }
            case 2: {
                this.nivellJoc = 2;
                this.angleRotacio = 45.0;
                this.mostraSilueta = true;
                this.nomNivellArbreFigures = "nivell.principiant";
                break;
            }
            case 3: {
                this.nivellJoc = 3;
                this.angleRotacio = 1.0;
                this.mostraSilueta = true;
                this.nomNivellArbreFigures = "nivell.iniciat";
                break;
            }
            case 4: {
                this.nivellJoc = 4;
                this.angleRotacio = 1.0;
                this.mostraSilueta = false;
                this.nomNivellArbreFigures = "nivell.expert";
                break;
            }
            default: {
                this.nivellJoc = 2;
                this.angleRotacio = 45.0;
                this.mostraSilueta = true;
                this.nomNivellArbreFigures = "nivell.principiant";
            }
        }
        this.actualitzaAngleGir();
    }

    public void actualitzaAngleGir() {
        switch (this.nivellJoc) {
            case 1: {
                this.angleRotacio = 45.0;
                if (this.tipusTangram == 9 || this.tipusTangram == 10 || this.tipusTangram == 8 || this.tipusTangram == 15 || this.tipusTangram == 34 || this.tipusTangram == 21 || this.tipusTangram == 22) {
                    this.angleRotacio = 15.0;
                }
                if (this.tipusTangram == 18 || this.tipusTangram == 31 || this.tipusTangram == 32 || this.tipusTangram == 28) {
                    this.angleRotacio = 5.0;
                }
                if (this.tipusTangram != 27 && this.tipusTangram != 29 && this.tipusTangram != 14 && this.tipusTangram != 20) break;
                this.angleRotacio = 3.0;
                break;
            }
            case 2: {
                this.angleRotacio = 45.0;
                if (this.tipusTangram == 9 || this.tipusTangram == 10 || this.tipusTangram == 8 || this.tipusTangram == 28 || this.tipusTangram == 15 || this.tipusTangram == 34 || this.tipusTangram == 21 || this.tipusTangram == 22) {
                    this.angleRotacio = 15.0;
                }
                if (this.tipusTangram == 18 || this.tipusTangram == 31 || this.tipusTangram == 32 || this.tipusTangram == 28 || this.tipusTangram == 20) {
                    this.angleRotacio = 5.0;
                }
                if (this.tipusTangram != 27 && this.tipusTangram != 29 && this.tipusTangram != 14) break;
                this.angleRotacio = 3.0;
                break;
            }
            case 3: {
                this.angleRotacio = 1.0;
                break;
            }
            case 4: {
                this.angleRotacio = 1.0;
                break;
            }
            default: {
                this.angleRotacio = 45.0;
            }
        }
    }

    public int comprovaFiguraResolta(String nomFigura) {
        int resultat = -1;
        for (int i = 0; i <= this.figuresResoltes.size() - 1; ++i) {
            FiguraResolta fig = (FiguraResolta)this.figuresResoltes.get(i);
            if (!(fig.nomFigura.equals(nomFigura) & fig.tipusTangram == this.tipusTangram & fig.nivellJoc == this.nivellJoc)) continue;
            resultat = i;
        }
        return resultat;
    }

    public int comprovaFiguraResolta() {
        int resultat = -1;
        for (int i = 0; i <= this.figuresResoltes.size() - 1; ++i) {
            FiguraResolta fig = (FiguraResolta)this.figuresResoltes.get(i);
            if (!(fig.tipusTangram == this.tipusTangram & fig.nivellJoc == this.nivellJoc)) continue;
            resultat = i;
        }
        return resultat;
    }

    public void eliminaFiguresResoltes() {
        int index = 1;
        while (index >= 0) {
            index = this.comprovaFiguraResolta();
            if (index < 0) continue;
            this.figuresResoltes.remove(index);
        }
    }

    public void eliminaRecordActual() {
        this.eliminaRecord();
        this.eliminaFiguresResoltes();
    }

    public void eliminaTotsElsRecords() {
        this.figuresResoltes.clear();
        this.recordsPersonals.clear();
    }

    public void afegeixFiguraResolta(String nomFigura) {
        if (this.comprovaFiguraResolta(nomFigura) == -1 & nomFigura != null) {
            this.figuresResoltes.add(new FiguraResolta(this.tipusTangram, this.nivellJoc, nomFigura));
            this.figuraPerResoldre = false;
        }
    }

    public int comprovaRecordPersonal() {
        int resultat = -1;
        for (int i = 0; i <= this.recordsPersonals.size() - 1; ++i) {
            RecordsPersonals rec = (RecordsPersonals)this.recordsPersonals.get(i);
            if (!(rec.tipusTangram == this.tipusTangram & rec.nivellJoc == this.nivellJoc)) continue;
            resultat = i;
        }
        return resultat;
    }

    public void afegeixNouRecord(int figuresRes, int punts, String temps) {
        RecordsPersonals rec;
        int indexLlista = this.comprovaRecordPersonal();
        if (indexLlista == -1) {
            rec = new RecordsPersonals(this.tipusTangram, this.nivellJoc);
        } else {
            rec = (RecordsPersonals)this.recordsPersonals.get(indexLlista);
            this.recordsPersonals.remove(indexLlista);
        }
        rec.estableixNumFiguresResoltes(figuresRes);
        rec.estableixPuntuacio(punts);
        rec.estableixTemps(temps);
        this.recordsPersonals.add(rec);
    }

    public void eliminaRecord() {
        int index = this.comprovaRecordPersonal();
        if (index > 0) {
            this.recordsPersonals.remove(index);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    private void readObject(ObjectInputStream obInSt) throws IOException, ClassNotFoundException {
        obInSt.defaultReadObject();
    }

    public static interface ConfiguracioJocInterface
    extends Cloneable {
        public Object clone() throws CloneNotSupportedException;
    }
}

