/*
 * Decompiled with CFR 0.152.
 */
package org.demarchi.jpeces.principal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import org.demarchi.jpeces.comuns.Configuracio;
import org.demarchi.jpeces.comuns.Constants;
import org.demarchi.jpeces.peces.ConjuntDePeces;

public final class panellDeMostra
extends JPanel
implements Observer,
Constants {
    static final BasicStroke limits = new BasicStroke(2.0f);
    public ConjuntDePeces jocMostra;
    private Configuracio configPanellDeMostra;
    public boolean boolJocEnMarxa;
    public double escala = 55.0;

    public panellDeMostra(double pescala, Configuracio config) {
        this.configPanellDeMostra = config;
        this.escala = pescala;
        this.setSize(new Dimension(120, 120));
        this.setPreferredSize(new Dimension(120, 120));
        this.setMinimumSize(this.getPreferredSize());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.creaConjuntPeces();
        this.setVisible(true);
    }

    public void construeix(RootPaneContainer contenidorArrel) {
        Container contenidor = contenidorArrel.getContentPane();
        contenidor.add(this);
    }

    public void creaConjuntPeces() {
        this.jocMostra = this.configPanellDeMostra.configuracioJoc.tipusTangram == 15 ? new ConjuntDePeces(this.configPanellDeMostra, this, this, 15.0, Color.BLACK) : new ConjuntDePeces(this.configPanellDeMostra, this, this, this.escala, Color.BLACK);
        this.jocMostra.estableixVisible(false);
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHints(rh);
        g2.setStroke(limits);
        if (this.jocMostra.emetVisible()) {
            Area areaFigura = new Area();
            this.calculaSilueta(areaFigura);
            g2.setPaint(new Color(155, 155, 155));
            g2.fill(areaFigura);
            g2.draw(areaFigura);
            for (int i = 0; i <= this.jocMostra.arrayPeces.length - 1; ++i) {
                g2.setPaint(this.jocMostra.arrayPeces[i].emetColorPeca());
                g2.fill(this.jocMostra.arrayPeces[i].emetPoligon(1.01));
                g2.draw(this.jocMostra.arrayPeces[i].emetPoligon(1.01));
                if (!this.jocMostra.arrayPeces[i].ambArc) continue;
                Arc2D.Double arc = this.jocMostra.arrayPeces[i].emetArcPeca(1.01);
                g2.draw(arc);
                g2.fill(arc);
            }
        }
    }

    private void calculaSilueta(Area areaInicial) {
        for (int i = 0; i <= this.jocMostra.arrayPeces.length - 1; ++i) {
            Polygon poli = this.jocMostra.arrayPeces[i].emetPoligon(1.02);
            Area areaFigura1 = new Area(poli);
            areaInicial.add(areaFigura1);
            if (!this.jocMostra.arrayPeces[i].ambArc) continue;
            Arc2D.Double arc = this.jocMostra.arrayPeces[i].emetArcPeca(1.01);
            Area areaArc = new Area(arc);
            areaInicial.add(areaArc);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.repaint();
    }
}

