/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */
package saper;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;

import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

import settings.Settings;
/**
 * Okno gry.
 */
public class SaperFrame extends JFrame implements SaperGameListener, MouseListener, WindowListener {

    public static final String SETTINGS_NAME = "saper";
    
    // panel z informacjami
    private JPanel infoPanel;
    // panel ze statusem
    private JPanel statusPanel;
    // pole na ktorym wyswietlana bedzie pozostala liczba min do odkrycia
    private JLabel mineLeftLabel;
    // panel wyswietlajacy pole gry
    private JPanel mineFieldPanel;
    SaperGame game;
    SaperAutoPlayer player;
    // tablica "przyciskow"
    private SaperButton[][] buttons;
    SaperAutoPlayerSettingsDialog robotSettings = null;
    
	private JMenuBar jJMenuBar = null;
	private JMenu jMenu = null;
	private JMenuItem jMenuItem = null;
	private JMenuItem jMenuItem1 = null;
	private JMenuItem jMenuItem2 = null;
    private JMenuItem jMenuItem3 = null;
    private JMenuItem jMenuItem4 = null;
    
    private JMenu jMenu2 = null;
    private JMenuItem jMenuItem5 = null;
    private JMenuItem jMenuItem6 = null;

    private JMenuItem jMenuItem7;

    public SaperFrame(){
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        addWindowListener(this);
        setJMenuBar(getJJMenuBar());
        Settings settings = Settings.getSettings(SETTINGS_NAME);
        this.player = new SaperAutoPlayer(this);
        this.player.random = settings.getPropertyAsBoolean(SaperAutoPlayer.SETTINGS_AUTO,false);
        this.player.sleepTime = settings.getPropertyAsInt(SaperAutoPlayer.SETTINGS_SLEEP,100);
        this.robotSettings = new SaperAutoPlayerSettingsDialog(this,this.player);
        startGame(
                settings.getPropertyAsInt(SaperGame.SETTINGS_WIDTH, 9),
                settings.getPropertyAsInt(SaperGame.SETTINGS_HEIGHT, 9),
                settings.getPropertyAsInt(SaperGame.SETTINGS_MINES, 10)
        );
    }

    private void clearGame(){
        if(this.game != null){
            this.game.removeSaperGameListener(this);
            for(int i = 0; i < this.game.getWidth(); i++){
                for(int j = 0; j < this.game.getHeight(); j++){        
                    // ustawienie nasluchiwacza na "przycisk"
                    this.buttons[i][j].removeMouseListener(this);
                }
            }
            getContentPane().removeAll();
            this.statusPanel.removeAll();
            this.mineFieldPanel.removeAll();
        }
    }
    
    public void setGame(SaperGame game) throws NullPointerException{
        clearGame();
        
        final int w = game.getWidth();
        final int h = game.getHeight();
        
        boolean sizeChanged = true;
        if(this.game != null && this.game.getWidth() == w && this.game.getHeight() == h) sizeChanged = false;
        this.game = game;

        this.mineLeftLabel = new JLabel(this.game.getMinesLeftString());
        this.mineLeftLabel.setHorizontalAlignment(SwingConstants.RIGHT);
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new BorderLayout());
        JLabel label =  new JLabel("Left: ");
        this.statusPanel.add(label,BorderLayout.WEST);
        this.mineLeftLabel.setPreferredSize(label.getPreferredSize());
        JPanel panel = new JPanel();
        panel.add(new JButton(new AbstractAction("O"){
            public void actionPerformed(ActionEvent e) {
                if(SaperFrame.this.game != null){
                    startGame(
                            SaperFrame.this.game.getWidth(),
                            SaperFrame.this.game.getHeight(),
                            SaperFrame.this.game.getMines()
                    );
                }
            }}));
        panel.add(new JButton(new AbstractAction("R"){
            public void actionPerformed(ActionEvent e) {
                SaperFrame.this.player.startPlaing();
            }
        }));
        
        ((JButton)panel.getComponent(0)).setMargin(new Insets(0,3,0,3));
        ((JButton)panel.getComponent(1)).setMargin(new Insets(0,3,0,3));
        
        this.statusPanel.add(panel,BorderLayout.CENTER);
        this.statusPanel.add(this.mineLeftLabel,BorderLayout.EAST);

        this.mineFieldPanel = new JPanel();
        
        this.mineFieldPanel.setLayout(new GridLayout(w,h));
        this.mineFieldPanel.setPreferredSize(new Dimension(20*h,20*w));

        this.buttons = new SaperButton[w][h];
        for(int i = 0; i < w; i++){
            for(int j = 0; j < h; j++){        
                this.buttons[i][j] = new SaperButton.SaperLabelButton(i,j);
                // ustawienie nasluchiwacza na "przycisk"
                this.buttons[i][j].addMouseListener(this);
                // dodanie "przycisku"
                this.mineFieldPanel.add(this.buttons[i][j].getComponent());
            }
        }
        
        // dodanie nasluchiwacza stanu gry
        game.addSaperGameListener(this);
        
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        screenSize.width -= 10;
        screenSize.height -= 80;

        getContentPane().add(this.statusPanel,BorderLayout.NORTH);
        if(this.mineFieldPanel.getPreferredSize().width > screenSize.width || this.mineFieldPanel.getPreferredSize().height > screenSize.height){
            JScrollPane scrollPane = new JScrollPane(this.mineFieldPanel,ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
            scrollPane.setPreferredSize(screenSize);
            getContentPane().add(scrollPane,BorderLayout.CENTER);
            if(sizeChanged) {
                setSize(screenSize);
                setLocationRelativeTo(null);
                sizeChanged = false;
            }
        } else {
            getContentPane().add(this.mineFieldPanel,BorderLayout.CENTER);
        }
        
        this.infoPanel = new SaperInfoPanel();
        getContentPane().add(this.infoPanel, BorderLayout.SOUTH);
        
        // ustawienie rozmiarow okna
        if(sizeChanged) {
            pack();
            setLocationRelativeTo(null);
        } else {
            validate();
        }
        
        
    }
    
    /**
     * Gdy gra sie rozpoczyna...
     * @see saper.SaperGameListener#gameStarted(saper.SaperGameEvent)
     */
    public void gameStarted(SaperGameEvent event) {
        SaperGame sg = event.getGame();
        setTitle("Saper - field "+sg.getWidth() +" : " + sg.getHeight()+" with "+sg.getMines()+" mines");
    }

    /**
     * Gdy pola zostana odloniete...
     * @see saper.SaperGameListener#gameFieldsUncovered(saper.SaperGameEvent)
     */
    public void gameFieldsUncovered(SaperGameEvent event) {
        // lista pol odslonietych
        List list = event.getFields();
        if(!event.getGame().isError()){
            for (int i = 0, n = list.size(); i < n; i++) {
                Point element = (Point) list.get(i); // odsloniety punkt
                // jesli punkt jest mina
                if(event.isPointMine(element)){
                    this.buttons[element.x][element.y].paintMine();
                // jesli nie jest mina
                } else {
                    int count = event.getMinesCount(element);
                    this.buttons[element.x][element.y].paintNumber(count);
                }
            }
        } else {
            for (int i = 0, n = list.size(); i < n; i++) {
                Point element = (Point) list.get(i); // odsloniety punkt
                // jesli punkt jest mina
                if(event.isPointMine(element)){
                    this.buttons[element.x][element.y].paintMine();
                }
            }
        }
        this.mineLeftLabel.setText(this.game.getMinesLeftString());
    }

    /**
     * Gdy koniec gry z sukcesem...
     * @see saper.SaperGameListener#gameVictory(saper.SaperGameEvent)
     */
    public void gameVictory(SaperGameEvent event) {
        JOptionPane.showMessageDialog(this,"Gratulations, you WON!!!","Saper",JOptionPane.INFORMATION_MESSAGE);
        getContentPane().setEnabled(false);
    }

    /**
     * Gdy koniec gry z porazka
     * @see saper.SaperGameListener#gameLost(saper.SaperGameEvent)
     */
    public void gameLost(SaperGameEvent event) {
        List list = event.getFields();
        for(int i = 0, n = list.size(); i < n; i++){
            Point point = (Point) list.get(i);
            this.buttons[point.x][point.y].paintError();
        }
        // JOptionPane.showMessageDialog(this,"Niestety, tym razem Ci si nie powiodo!","Saper",JOptionPane.INFORMATION_MESSAGE);
        getContentPane().setEnabled(false);
    }

    /**
     * Zmiana statusu pola (z miny na nie mine)
     * @see saper.SaperGameListener#gameFieldMineStatusChanged(saper.SaperGameEvent)
     */
    public void gameFieldMineStatusChanged(SaperGameEvent event) {
        Point point = (Point) event.getFields().get(0);
        if(event.isPointCleared(point)){
            this.buttons[point.x][point.y].paintHidden();
        } else if(event.isPointMine(point)) {
            this.buttons[point.x][point.y].paintMine();
        }
        this.mineLeftLabel.setText(this.game.getMinesLeftString());
    }


    /**
     * Zdarzenie gdy przycisk myszy zostal zwolniony
     * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
     */
    public void mouseReleased(MouseEvent e) {
        // przycisk nad ktory tupnelismy myszka
        SaperButton button = (SaperButton) e.getSource();
        if(e.getButton() == MouseEvent.BUTTON1) {
            // przycisk lewy - w razie porazki bomba buuumm
            this.game.uncoverField(button.getSaperX(),button.getSaperY(),true);
        } else if(e.getButton() == MouseEvent.BUTTON3 && e.getClickCount() == 1){
            // przycisk prawy raz - zaznaczenie ze mina lub odznaczenie
            this.game.uncoverField(button.getSaperX(),button.getSaperY(),false);
        } else if(e.getButton() == MouseEvent.BUTTON3 && e.getClickCount() == 2){
            // slowe odkrycie pol sasiadujacych z tym, na ktory tupnelismy mysza
            this.game.uncoverNeighbours(button.getSaperX(),button.getSaperY());
        }
    }

    /**
     * Zakonczenie gry poprzez zamkniecie okna
     * @see java.awt.event.WindowListener#windowClosing(java.awt.event.WindowEvent)
     */
    public void windowClosing(WindowEvent e) {
        // tylko jesli wczesniej nie skonczylismy gry zglaszamy ze koniec gry
        exit();
    }


    void exit(){
        if(!this.game.isEnded()){
            this.game.end();
        }
        if(this.player != null){
            this.player.interrupt();
            this.player = null;
        }
        saveSettings(true);
        this.dispose();
        System.exit(0);
    }
    
    void saveSettings(boolean ask){
        Settings settings = Settings.getSettings(SETTINGS_NAME);
        if(settings.isChanged()){
        	int res = JOptionPane.OK_OPTION;
        	if(ask){
        		res = JOptionPane.showConfirmDialog(this, "Settings were changed - do you want to save them?", "Settings...", JOptionPane.YES_NO_OPTION);
        	}
        	if(JOptionPane.OK_OPTION == res || JOptionPane.YES_OPTION == res) {
                try {
                    settings.storeToXML();
                    JOptionPane.showMessageDialog(this,"Settings were saved.");
                } catch (IOException e1) {
                    JOptionPane.showMessageDialog(this,"Error - settings were not saved.");
                }
        	}
        }
    }
    
    ////////////////////////////////////////////////////////////
    ///   metody nas nieinteresujace
    ////////////////////////////////////////////////////////////
    
    public void mouseEntered(MouseEvent e) {
        //
    }
    public void mouseExited(MouseEvent e) {
        //
    }
    public void mouseClicked(MouseEvent e) {
        //
    }
    public void mousePressed(MouseEvent e) {
        //
    }
    public void windowOpened(WindowEvent e) {
        //
    }
    public void windowIconified(WindowEvent e) {
        //
    }
    public void windowDeiconified(WindowEvent e) {
        //
    }
    public void windowActivated(WindowEvent e) {
        //
    }
    public void windowDeactivated(WindowEvent e) {
        //
    }
    public void windowClosed(WindowEvent e) {
        //
    }

	/**
	 * This method initializes jJMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */    
	private JMenuBar getJJMenuBar() {
		if (this.jJMenuBar == null) {
			this.jJMenuBar = new JMenuBar();
			this.jJMenuBar.add(getJMenu());
            this.jJMenuBar.add(getJMenu2());
		}
		return this.jJMenuBar;
	}
	/**
	 * This method initializes jMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */    
	private JMenu getJMenu() {
		if (this.jMenu == null) {
			this.jMenu = new JMenu();
			this.jMenu.setText("Saper");
			this.jMenu.add(getJMenuItem());
			this.jMenu.add(getJMenuItem1());
            this.jMenu.add(getJMenuItem2());
            this.jMenu.add(getJMenuItem4());
            this.jMenu.add(new JSeparator());
            this.jMenu.add(getJMenuItem3());
		}
		return this.jMenu;
	}
	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */    
	private JMenuItem getJMenuItem() {
		if (this.jMenuItem == null) {
			this.jMenuItem = new JMenuItem();
			this.jMenuItem.setText("Beginer");
			this.jMenuItem.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					startGame(9,9,10);
				}
			});
		}
		return this.jMenuItem;
	}
	/**
	 * This method initializes jMenuItem1	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */    
	private JMenuItem getJMenuItem1() {
		if (this.jMenuItem1 == null) {
			this.jMenuItem1 = new JMenuItem();
			this.jMenuItem1.setText("Advanced");
			this.jMenuItem1.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					startGame(16,16,40);
				}
			});
		}
		return this.jMenuItem1;
	}
    /**
     * This method initializes jMenuItem2   
     *  
     * @return javax.swing.JMenuItem    
     */    
    private JMenuItem getJMenuItem2() {
        if (this.jMenuItem2 == null) {
            this.jMenuItem2 = new JMenuItem();
            this.jMenuItem2.setText("Expert");
            this.jMenuItem2.addActionListener(new java.awt.event.ActionListener() { 
                public void actionPerformed(java.awt.event.ActionEvent e) {    
                    startGame(16,30,99);
                }
            });
        }
        return this.jMenuItem2;
    }
    /**
     * This method initializes jMenuItem3   
     *  
     * @return javax.swing.JMenuItem    
     */    
    private JMenuItem getJMenuItem3() {
        if (this.jMenuItem3 == null) {
            this.jMenuItem3 = new JMenuItem();
            this.jMenuItem3.setText("Exit");
            this.jMenuItem3.addActionListener(new java.awt.event.ActionListener() { 
                public void actionPerformed(java.awt.event.ActionEvent e) {  
                    SaperFrame.this.exit();
                }
            });
        }
        return this.jMenuItem3;
    }
    /**
     * This method initializes jMenuItem3   
     *  
     * @return javax.swing.JMenuItem    
     */    
    private JMenuItem getJMenuItem4() {
        if (this.jMenuItem4 == null) {
            this.jMenuItem4 = new JMenuItem();
            this.jMenuItem4.setText("Define...");
            this.jMenuItem4.addActionListener(new java.awt.event.ActionListener() { 
                private SaperOwnSettings settings = null;
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    if(this.settings == null){
                        this.settings = new SaperOwnSettings(SaperFrame.this);
                    }
                    this.settings.setLocationRelativeTo(SaperFrame.this);
                    this.settings.setVisible(true);
                }
            });
        }
        return this.jMenuItem4;
    }
    /**
     * This method initializes jMenu    
     *  
     * @return javax.swing.JMenu    
     */    
    private JMenu getJMenu2() {
        if (this.jMenu2 == null) {
            this.jMenu2 = new JMenu();
            this.jMenu2.setText("Robot");
            this.jMenu2.add(getJMenuItem5());
            this.jMenu2.add(getJMenuItem7());
            this.jMenu2.add(getJMenuItem6());
        }
        return this.jMenu2;
    }
    /**
     * This method initializes jMenuItem3   
     *  
     * @return javax.swing.JMenuItem    
     */    
    private JMenuItem getJMenuItem5() {
        if (this.jMenuItem5 == null) {
            this.jMenuItem5 = new JMenuItem();
            this.jMenuItem5.setText("Start");
            this.jMenuItem5.addActionListener(new java.awt.event.ActionListener() { 
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    SaperFrame.this.player.startPlaing();
                }
            });
        }
        return this.jMenuItem5;
    }
    /**
     * This method initializes jMenuItem3   
     *  
     * @return javax.swing.JMenuItem    
     */    
    private JMenuItem getJMenuItem7() {
        if (this.jMenuItem7 == null) {
            this.jMenuItem7 = new JMenuItem();
            this.jMenuItem7.setText("Stop");
            this.jMenuItem7.addActionListener(new java.awt.event.ActionListener() { 
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    SaperFrame.this.player.stopPlaing();
                }
            });
        }
        return this.jMenuItem7;
    }
    /**
     * This method initializes jMenuItem3   
     *  
     * @return javax.swing.JMenuItem    
     */    
    private JMenuItem getJMenuItem6() {
        if (this.jMenuItem6  == null) {
            this.jMenuItem6 = new JMenuItem();
            this.jMenuItem6.setText("Settings");
            this.jMenuItem6.addActionListener(new java.awt.event.ActionListener() { 
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    SaperFrame.this.robotSettings.setLocationRelativeTo(SaperFrame.this);
                    SaperFrame.this.robotSettings.setVisible(true);
                }
            });
        }
        return this.jMenuItem6;
    }
    // metoda startujaca gre
    void startGame(int w, int h, int m){
        if(this.game != null) this.game.removeSaperGameListener(this.player);
        SaperGame sg = new SaperGame(w,h,m); // utworzenie gry
        setGame(sg); // utworzenie okna
        this.game.addSaperGameListener(this.player);
        this.game.addSaperGameListener((SaperGameListener) this.infoPanel);
        Settings settings = Settings.getSettings(SETTINGS_NAME);
        settings.setProperty(SaperGame.SETTINGS_WIDTH,new Integer(w).toString());
        settings.setProperty(SaperGame.SETTINGS_HEIGHT,new Integer(h).toString());
        settings.setProperty(SaperGame.SETTINGS_MINES,new Integer(m).toString());
        this.game.start(); // rozpoczecie gry
        // uruchomienie pomocy znalezienia pierwszego pola z 0
        Point tip = this.game.getGameTip();
        if(tip != null) this.game.uncoverField(tip.x, tip.y, true);
    }

    public static void main(String[] args) {
        Settings settings = Settings.getSettings(SETTINGS_NAME);
        try {
            settings.loadFromXML();
            // settings.list(System.out);
        } catch (IOException e) {
            e.printStackTrace();
        }
        SaperFrame frame = new SaperFrame();
        frame.player.start();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
    
     }
