/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */

package saper;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;

/**
 * Zdarzenie gry w sapera
 */
public class SaperGameEvent extends EventObject {

    // lista punktow pusta,m do wykozystania gdy nie zostala podana przy tworzeniu
    // zdarzenia (zdarzenie nie potrzebuje lub nie ma punktow)
    private static final List EMPTY_LIST = new ArrayList(0);
    // lista punktow
    private List pointsList = null;

    public SaperGameEvent(SaperGame source, List list) {
        super(source);
//        if(list != null){
//            System.out.println("cc");
//            Collections.sort(list,SaperPoint.PointsComparator);
//        }
        this.pointsList = list;
    }
    
    public SaperGame getGame(){
        return (SaperGame) getSource();
    }
    /**
     * @return tablica odkrytych punktw List<<java.awt.Point>>
     */
    public List getFields(){
        return Collections.unmodifiableList(this.pointsList == null ? EMPTY_LIST : this.pointsList);
    }
    /**
     * Czy punkt z listy jest mina
     * @param point
     * @return
     */
    public boolean isPointMine(Point point) {
        return ((SaperPoint)point).status == SaperGame.MINE;
    }
    /**
     * Czy punkt z listy jest wyczyszczony (odznaczony od bycia mina)
     * @param point
     * @return
     */
    public boolean isPointCleared(Point point){
        return ((SaperPoint)point).status == Integer.MIN_VALUE;
    }
    /**
     * Ilosc min, ktora otacza punkt z listy
     * @param point
     * @return
     */
    public int getMinesCount(Point point){
        return ((SaperPoint)point).status;
    }
    
}
