/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */
package saper;

import java.util.EventListener;

/**
 * Obekt odbierajacy zdarzenia o postepach w grze
 */
public interface SaperGameListener extends EventListener {
    /**
     * Zglaszany przy rozpoczeciu gry
     * @param event
     */
    public void gameStarted(SaperGameEvent event);
    /**
     * Zglaszany gdy uzytkownik wybierze odkrycie punktu wywolujacego wybuch
     * gdy mina sie natrafi - o odkryciu jakiejs ilosci min
     * @param event
     */
    public void gameFieldsUncovered(SaperGameEvent event);
    /**
     * Zglaszane gdy wszystkie koniec gdy i zwyciestwo
     * @param event
     */
    public void gameVictory(SaperGameEvent event);
    /**
     * Zglaszany gdy koniec gry i przegrana
     * @param event
     */
    public void gameLost(SaperGameEvent event);
    /**
     * Zglaszany gdy uzytkownik zaznaczy lub odznaczy mine na polu
     * @param event
     */
    public void gameFieldMineStatusChanged(SaperGameEvent event);
}
