/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */
package settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Properties;

/**
 * @author wrobel.cwirek@wp.pl
 */
public class Settings {

    private static HashMap MAP = new HashMap();
    
    public static Settings getSettings(String name){
        if(!MAP.containsKey(name)){
            MAP.put(name, new Settings(name));
        }
        return (Settings) MAP.get(name);
    }
    
    public static String COMMENT = "Comment";
    
    private String fileName = "settings.properties";
    
    private final Properties properties = new Properties();
    private boolean chaneged = true;
    
    public Settings(String fileName){
        this.fileName = fileName;
    }
    
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }
    
    public String getProperty(String key, String defaultValue) {
        String out = getProperty(key);
        if(out == null){
            setProperty(key,defaultValue);
            out = defaultValue;
        }
        return out;
    }
    
    public void loadFromXML() throws IOException {
        InputStream in = new FileInputStream(new File(this.fileName));
        this.properties.load(in);
        this.chaneged = false;
    }
    
    public Object setProperty(String key, String value) {
        if(value == null) throw new IllegalArgumentException("value is null");
        String out = getProperty(key);
        if(!value.equals(out)){
            this.properties.setProperty(key, value);
            this.chaneged = true;
        }
        return out;
    }
    
    public void storeToXML() throws IOException {
        OutputStream os = new FileOutputStream(new File(this.fileName),false);
        this.properties.store(os, COMMENT);
        this.chaneged = false;
    }
    
    public boolean isChanged(){
        return this.chaneged;
    }
    public void list(PrintStream out) {
        this.properties.list(out);
    }
    
    public int getPropertyAsInt(String key, int def){
        String string = getProperty(key, new Integer(def).toString());
        int out = def;
        try{
            out = Integer.parseInt(string);
        } catch (NumberFormatException e) {
            e.printStackTrace();
            setProperty(key,new Integer(def).toString());
        }
        return out;
    }
    
    public boolean getPropertyAsBoolean(String key, boolean def){
        String string = getProperty(key, Boolean.valueOf(def).toString());
        boolean out = def;
        try{
            out = Boolean.valueOf(string).booleanValue();
        } catch (NumberFormatException e) {
            e.printStackTrace();
            setProperty(key,Boolean.valueOf(def).toString());
        }
        return out;
    }
    
}
