/*
 * Decompiled with CFR 0.152.
 */
package puzzle.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.rtf.RTFEditorKit;
import puzzle.helper.PhotoRescaled;
import puzzle.model.Photo;
import puzzle.model.PuzzleModel;
import puzzle.model.Record;
import puzzle.view.PlayPuzzleGui;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartPageGui {
    private String photosDirectoryPath;
    private PuzzleModel pm;
    private static JFrame f;
    private static JPanel centralPanel;
    private JPanel buttonsPanel;
    private JPanel gamePanel;
    private JPanel settingsPanel;
    private JTextPane tp;
    private JPanel photoPanel;
    private JPanel elementsPanel;
    private ButtonGroup group;
    private static JPanel recordsPanel;
    private static JPanel recordsImagePanel;
    private static JTextPane recordsMovesTp;
    private static JTextPane recordsTimeTp;
    private RTFEditorKit kit;
    private static StyledDocument dsd;

    public static void main(String[] args) {
        String difficultiesFilePath = "resources/difficulties.txt";
        String photosDirectoryPath = "resources/jpg/";
        String moveRecordsDirectoryPath = "resources/moveRecords/";
        String timeRecordsDirectoryPath = "resources/timeRecords/";
        new StartPageGui(difficultiesFilePath, photosDirectoryPath, moveRecordsDirectoryPath, timeRecordsDirectoryPath);
    }

    StartPageGui(String difficultiesFilePath, String photosDirectoryPath, String moveRecordsDirectoryPath, String timeRecordsDirectoryPath) {
        this.photosDirectoryPath = photosDirectoryPath;
        this.pm = new PuzzleModel(difficultiesFilePath, moveRecordsDirectoryPath, timeRecordsDirectoryPath);
        this.launchFrame();
    }

    private void launchFrame() {
        this.loadCentralPanel();
        this.loadButtonsPanel();
        this.loadGamePanel();
        this.loadSettingsPanel();
        this.loadRecordsPanel();
        f = new JFrame("Puzzle - home");
        f.setLayout(new BorderLayout());
        f.add((Component)centralPanel, "Center");
        f.add((Component)this.buttonsPanel, "South");
        f.pack();
        f.setResizable(false);
        f.setLocation(0, 0);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    private void loadCentralPanel() {
        this.tp = new JTextPane();
        this.tp.setEditable(false);
        this.tp.setBackground(new Color(245, 245, 210));
        this.tp.setBorder(BorderFactory.createMatteBorder(5, 10, 0, 10, new Color(245, 245, 210)));
        this.kit = new RTFEditorKit();
        this.tp.setEditorKit(this.kit);
        StyleContext sc = new StyleContext();
        dsd = new DefaultStyledDocument(sc);
        Style iconStyle = sc.getStyle("default");
        StyleConstants.setAlignment(iconStyle, 1);
        ImageIcon icon = new ImageIcon("resources/StartPage.jpg");
        StyleConstants.setIcon(iconStyle, icon);
        try {
            dsd.insertString(0, "Ignored", iconStyle);
        }
        catch (BadLocationException ble) {
            System.err.println(ble.getMessage());
        }
        this.tp.setDocument(dsd);
        centralPanel = new JPanel();
        centralPanel.setPreferredSize(new Dimension(750, 360));
        centralPanel.setBackground(new Color(225, 225, 200));
        centralPanel.setLayout(new BorderLayout());
        centralPanel.add(this.tp);
    }

    private void loadButtonsPanel() {
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setBackground(new Color(245, 245, 210));
        this.buttonsPanel.setBorder(BorderFactory.createMatteBorder(0, 4, 5, 4, new Color(245, 245, 210)));
        this.buttonsPanel.setLayout(new FlowLayout());
        JButton[] mainButtons = new JButton[]{new JButton("How to play"), new JButton("Puzzle"), new JButton("Settings")};
        mainButtons[0].addActionListener(new HowToPlayHandler());
        mainButtons[1].addActionListener(new PuzzleHandler());
        mainButtons[2].addActionListener(new SettingsHandler());
        for (JButton mainButton : mainButtons) {
            mainButton.setBackground(new Color(190, 190, 165));
            mainButton.setForeground(Color.RED);
            mainButton.setPreferredSize(new Dimension(250, 40));
            mainButton.setFont(new Font("TimesNewRoman", 1, 16));
            this.buttonsPanel.add(mainButton);
        }
    }

    private void loadGamePanel() {
        JButton[] photoButtons;
        List<Photo> photos = this.pm.getAllPhotos();
        String imageName = photos.get(0).getName();
        String imagePath = this.photosDirectoryPath + imageName + ".jpg";
        PhotoRescaled photo = new PhotoRescaled(imagePath, 250, 200);
        photo.setName(imageName);
        photo.addMouseListener(new PlayHandler());
        this.photoPanel = new JPanel();
        this.photoPanel.setBackground(new Color(245, 245, 210));
        this.photoPanel.setPreferredSize(new Dimension(360, 220));
        this.photoPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        this.photoPanel.add((Component)photo, c);
        for (JButton photoButton : photoButtons = new JButton[]{new JButton("<  Previous"), new JButton("Next  >")}) {
            photoButton.setBackground(new Color(200, 200, 175));
            photoButton.setForeground(new Color(0, 0, 150));
            photoButton.setPreferredSize(new Dimension(100, 30));
            photoButton.setFont(new Font("TimesNewRoman", 1, 12));
            photoButton.addActionListener(new PhotoButtonsHandler());
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(new Color(245, 245, 210));
        mainPanel.setLayout(new FlowLayout(1, 0, 50));
        mainPanel.add(photoButtons[0]);
        mainPanel.add(this.photoPanel);
        mainPanel.add(photoButtons[1]);
        this.elementsPanel = new JPanel();
        this.elementsPanel.setBackground(new Color(245, 245, 210));
        this.elementsPanel.setPreferredSize(new Dimension(0, 90));
        this.elementsPanel.setLayout(new FlowLayout(1, 30, 20));
        this.group = new ButtonGroup();
        List<String> labels = photos.get(0).getDifficulties();
        for (String label : labels) {
            JRadioButton button = new JRadioButton(label);
            button.setBackground(new Color(245, 245, 210));
            this.elementsPanel.add(button);
            this.group.add(button);
        }
        JRadioButton selected = (JRadioButton)this.elementsPanel.getComponent(0);
        selected.setSelected(true);
        this.gamePanel = new JPanel();
        this.gamePanel.setBackground(new Color(245, 245, 210));
        this.gamePanel.setLayout(new BorderLayout());
        this.gamePanel.add((Component)mainPanel, "Center");
        this.gamePanel.add((Component)this.elementsPanel, "South");
    }

    private void loadSettingsPanel() {
        int i;
        this.settingsPanel = new JPanel();
        this.settingsPanel.setBackground(new Color(245, 245, 210));
        this.settingsPanel.setPreferredSize(new Dimension(260, 360));
        this.settingsPanel.setBorder(BorderFactory.createMatteBorder(30, 10, 0, 0, new Color(245, 245, 210)));
        this.settingsPanel.setLayout(new FlowLayout(1));
        JButton[] settingsButtons = new JButton[]{new JButton("Replace photo"), new JButton("Replace level"), new JButton("Add new level"), new JButton("Remove selected level"), new JButton("Show records"), new JButton("Clear selected records"), new JButton("Clear all records")};
        settingsButtons[0].addActionListener(new ReplacePhotoHandler());
        settingsButtons[1].addActionListener(new ReplaceLevelHandler());
        settingsButtons[2].addActionListener(new AddLevelHandler());
        settingsButtons[3].addActionListener(new RemoveLevelHandler());
        settingsButtons[4].addActionListener(new RecordsHandler());
        settingsButtons[5].addActionListener(new RecordsHandler());
        settingsButtons[6].addActionListener(new ClearAllRecordsHandler());
        for (JButton button : settingsButtons) {
            button.setBackground(new Color(200, 200, 175));
            button.setForeground(new Color(0, 0, 150));
            button.setFont(new Font("TimesNewRoman", 1, 12));
            if (button.equals(settingsButtons[1]) || button.equals(settingsButtons[2])) continue;
            button.setPreferredSize(new Dimension(190, 38));
            this.settingsPanel.add(button);
        }
        ArrayList<String> levels = new ArrayList<String>();
        for (i = 3; i <= 9; ++i) {
            for (int j = 3; j <= 9; ++j) {
                levels.add(i + "x" + j);
            }
        }
        for (i = 1; i <= 2; ++i) {
            JComboBox<Object> levelsComboBox = new JComboBox<Object>(levels.toArray());
            levelsComboBox.setBackground(new Color(200, 200, 175));
            levelsComboBox.setForeground(new Color(0, 0, 150));
            levelsComboBox.setPreferredSize(new Dimension(50, 38));
            levelsComboBox.setFont(new Font("TimesNewRoman", 1, 12));
            JPanel levelsPanel = new JPanel();
            levelsPanel.setPreferredSize(new Dimension(190, 38));
            levelsPanel.setLayout(new BorderLayout());
            levelsPanel.add((Component)settingsButtons[i], "Center");
            levelsPanel.add(levelsComboBox, "East");
            this.settingsPanel.add((Component)levelsPanel, i);
        }
    }

    private void loadRecordsPanel() {
        recordsPanel = new JPanel();
        recordsPanel.setBackground(new Color(245, 245, 210));
        recordsPanel.setLayout(new FlowLayout());
        recordsMovesTp = new JTextPane();
        recordsMovesTp.setEditable(false);
        recordsMovesTp.setBackground(new Color(245, 245, 210));
        recordsImagePanel = new JPanel();
        recordsImagePanel.setBackground(new Color(245, 245, 210));
        recordsImagePanel.setLayout(new FlowLayout(1, 40, 70));
        recordsTimeTp = new JTextPane();
        recordsTimeTp.setEditable(false);
        recordsTimeTp.setBackground(new Color(245, 245, 210));
        recordsPanel.add(recordsMovesTp);
        recordsPanel.add(recordsImagePanel);
        recordsPanel.add(recordsTimeTp);
    }

    public static void displayRecords(String imagePath, List<Record> moveRecords, List<Record> timeRecords, String noOfElements, Record newMoveRecord, Record newTimeRecord) {
        centralPanel.removeAll();
        centralPanel.repaint();
        centralPanel.add(recordsPanel);
        StyleContext recordsContext = new StyleContext();
        Style recordsStyle = recordsContext.getStyle("default");
        StyleConstants.setAlignment(recordsStyle, 1);
        StyleConstants.setBold(recordsStyle, true);
        StyleConstants.setFontFamily(recordsStyle, "TimesNewRoman");
        StyleConstants.setFontSize(recordsStyle, 16);
        Style recordsStyleRed = recordsContext.addStyle("RecordsStyleRed", recordsStyle);
        StyleConstants.setAlignment(recordsStyleRed, 1);
        StyleConstants.setBold(recordsStyleRed, true);
        StyleConstants.setFontFamily(recordsStyleRed, "TimesNewRoman");
        StyleConstants.setFontSize(recordsStyleRed, 16);
        StyleConstants.setForeground(recordsStyleRed, Color.RED);
        DefaultStyledDocument movesDsd = new DefaultStyledDocument(recordsContext);
        DefaultStyledDocument timeDsd = new DefaultStyledDocument(recordsContext);
        try {
            movesDsd.insertString(movesDsd.getLength(), "Fewest moves results:\n\n", recordsStyle);
            for (Record nextRecord : moveRecords) {
                String line = nextRecord.getName() + ": " + (int)nextRecord.getResult();
                if (newMoveRecord != null && nextRecord.getName().equals(newMoveRecord.getName()) && nextRecord.getResult() == newMoveRecord.getResult()) {
                    movesDsd.insertString(movesDsd.getLength(), line + "\n", recordsStyleRed);
                    newMoveRecord = null;
                    continue;
                }
                movesDsd.insertString(movesDsd.getLength(), line + "\n", recordsStyle);
            }
            timeDsd.insertString(timeDsd.getLength(), "Shortest time results:\n\n", recordsStyle);
            for (Record nextRecord : timeRecords) {
                DecimalFormat df = new DecimalFormat();
                df.setMinimumFractionDigits(2);
                String line = nextRecord.getName() + ": " + df.format(nextRecord.getResult());
                if (newTimeRecord != null && nextRecord.getName().equals(newTimeRecord.getName()) && nextRecord.getResult() == newTimeRecord.getResult()) {
                    timeDsd.insertString(timeDsd.getLength(), line + "\n", recordsStyleRed);
                    newTimeRecord = null;
                    continue;
                }
                timeDsd.insertString(timeDsd.getLength(), line + "\n", recordsStyle);
            }
        }
        catch (BadLocationException ble) {
            System.err.println(ble.getMessage());
        }
        recordsMovesTp.setDocument(movesDsd);
        recordsTimeTp.setDocument(timeDsd);
        recordsImagePanel.removeAll();
        recordsImagePanel.repaint();
        JPanel photoPanel = new JPanel();
        photoPanel.setLayout(new BorderLayout());
        photoPanel.setBackground(new Color(245, 245, 210));
        PhotoRescaled photo = new PhotoRescaled(imagePath, 250, 200);
        JLabel label = new JLabel(noOfElements, 0);
        label.setFont(new Font("TimesNewRoman", 1, 14));
        photoPanel.add((Component)photo, "Center");
        photoPanel.add((Component)label, "South");
        recordsImagePanel.add(photoPanel);
        f.toFront();
    }

    private void displayLevels(List<String> labels) {
        this.elementsPanel.removeAll();
        this.elementsPanel.repaint();
        this.group = new ButtonGroup();
        for (String label : labels) {
            JRadioButton radioButton = new JRadioButton(label);
            radioButton.setBackground(new Color(245, 245, 210));
            this.elementsPanel.add(radioButton);
            this.group.add(radioButton);
        }
        JRadioButton selected = (JRadioButton)this.elementsPanel.getComponent(0);
        selected.setSelected(true);
        this.elementsPanel.validate();
    }

    class ClearAllRecordsHandler
    implements ActionListener {
        ClearAllRecordsHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            String imageName = StartPageGui.this.photoPanel.getComponent(0).getName();
            String message = "Do you want to clear all records for a displayed image?";
            int clearRecords = JOptionPane.showConfirmDialog(f, message, "Clear all records", 2);
            if (clearRecords == 0) {
                Enumeration<AbstractButton> elements = StartPageGui.this.group.getElements();
                while (elements.hasMoreElements()) {
                    AbstractButton button = elements.nextElement();
                    String noOfElements = button.getText();
                    String recordsFileName = imageName + "_" + noOfElements + ".txt";
                    StartPageGui.this.pm.clearRecords(recordsFileName);
                }
            }
        }
    }

    class RecordsHandler
    implements ActionListener {
        RecordsHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            String imageName = StartPageGui.this.photoPanel.getComponent(0).getName();
            String noOfElements = null;
            Enumeration<AbstractButton> elements = StartPageGui.this.group.getElements();
            while (elements.hasMoreElements()) {
                AbstractButton button = elements.nextElement();
                if (!button.isSelected()) continue;
                noOfElements = button.getText();
                break;
            }
            String recordsFileName = imageName + "_" + noOfElements + ".txt";
            JButton button = (JButton)e.getSource();
            if (button.getText().equals("Show records")) {
                List<Record> moveRecords = StartPageGui.this.pm.getAllMoveRecords(recordsFileName);
                List<Record> timeRecords = StartPageGui.this.pm.getAllTimeRecords(recordsFileName);
                String imagePath = StartPageGui.this.photosDirectoryPath + imageName + ".jpg";
                StartPageGui.displayRecords(imagePath, moveRecords, timeRecords, noOfElements, null, null);
            } else {
                String message = "Do you want to clear records for a displayed image cut into " + noOfElements + " number of pieces?";
                int clearRecords = JOptionPane.showConfirmDialog(f, message, "Clear records", 2);
                if (clearRecords == 0) {
                    StartPageGui.this.pm.clearRecords(recordsFileName);
                }
            }
        }
    }

    class RemoveLevelHandler
    implements ActionListener {
        RemoveLevelHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (StartPageGui.this.elementsPanel.getComponentCount() <= 1) {
                JOptionPane.showMessageDialog(f, "There must be at least one level set.");
            } else {
                String imageName = StartPageGui.this.photoPanel.getComponent(0).getName();
                String message = "Do you want to remove selected level for a displayed image?";
                int clearRecords = JOptionPane.showConfirmDialog(f, message, "Remove selected level", 2);
                if (clearRecords == 0) {
                    String level = null;
                    Enumeration<AbstractButton> elements = StartPageGui.this.group.getElements();
                    while (elements.hasMoreElements()) {
                        AbstractButton button = elements.nextElement();
                        if (!button.isSelected()) continue;
                        level = button.getText();
                        break;
                    }
                    List<String> labels = StartPageGui.this.pm.changeDifficulty(imageName, null, level);
                    StartPageGui.this.displayLevels(labels);
                }
            }
        }
    }

    class AddLevelHandler
    implements ActionListener {
        AddLevelHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (StartPageGui.this.elementsPanel.getComponentCount() >= 6) {
                JOptionPane.showMessageDialog(f, "You cannot add more then six levels.");
            } else {
                String imageName = StartPageGui.this.photoPanel.getComponent(0).getName();
                String message = "Do you want to add a new level for a displayed image?";
                int clearRecords = JOptionPane.showConfirmDialog(f, message, "Add new level", 2);
                if (clearRecords == 0) {
                    JButton button = (JButton)e.getSource();
                    JComboBox box = (JComboBox)button.getParent().getComponent(1);
                    String level = (String)box.getSelectedItem();
                    List<String> labels = StartPageGui.this.pm.changeDifficulty(imageName, level, null);
                    if (labels.isEmpty()) {
                        JOptionPane.showMessageDialog(f, "Selected level has been already added.");
                    } else {
                        StartPageGui.this.displayLevels(labels);
                    }
                }
            }
        }
    }

    class ReplaceLevelHandler
    implements ActionListener {
        ReplaceLevelHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            String imageName = StartPageGui.this.photoPanel.getComponent(0).getName();
            String message = "Do you want to replace selected level for a displayed image?";
            int clearRecords = JOptionPane.showConfirmDialog(f, message, "Replace level", 2);
            if (clearRecords == 0) {
                List<String> labels;
                JButton button = (JButton)e.getSource();
                JComboBox box = (JComboBox)button.getParent().getComponent(1);
                String levelToAdd = (String)box.getSelectedItem();
                String levelToDelete = null;
                Enumeration<AbstractButton> elements = StartPageGui.this.group.getElements();
                while (elements.hasMoreElements()) {
                    AbstractButton nextButton = elements.nextElement();
                    if (!nextButton.isSelected()) continue;
                    levelToDelete = nextButton.getText();
                    break;
                }
                if ((labels = StartPageGui.this.pm.changeDifficulty(imageName, levelToAdd, levelToDelete)).isEmpty()) {
                    JOptionPane.showMessageDialog(f, "Selected level has been already added.");
                } else {
                    StartPageGui.this.displayLevels(labels);
                }
            }
        }
    }

    class ReplacePhotoHandler
    implements ActionListener {
        ReplacePhotoHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            fc.showOpenDialog(f);
            File newFile = fc.getSelectedFile();
            try {
                double heightRatio;
                double widthRatio;
                BufferedImage newImage = ImageIO.read(newFile);
                double ratio = 1.0;
                if (newImage.getWidth() < 250 || newImage.getHeight() < 250) {
                    widthRatio = 1.0;
                    heightRatio = 1.0;
                    if (newImage.getWidth() < 250) {
                        widthRatio = 250.0 / (double)newImage.getWidth();
                    }
                    if (newImage.getHeight() < 250) {
                        heightRatio = 250.0 / (double)newImage.getHeight();
                    }
                    ratio = Math.max(widthRatio, heightRatio);
                } else if (newImage.getWidth() > 800 || newImage.getHeight() > 570) {
                    widthRatio = 1.0;
                    heightRatio = 1.0;
                    if (newImage.getWidth() > 800) {
                        widthRatio = 800.0 / (double)newImage.getWidth();
                    }
                    if (newImage.getHeight() > 570) {
                        heightRatio = 570.0 / (double)newImage.getHeight();
                    }
                    ratio = Math.min(widthRatio, heightRatio);
                }
                int img_width = (int)((double)newImage.getWidth() * ratio);
                int img_height = (int)((double)newImage.getHeight() * ratio);
                if (img_width < 250 || img_width > 800 || img_height < 250 || img_height > 570) {
                    JOptionPane.showMessageDialog(f, "Selected photo cannot be rescaled. After it's rescaled it must be 250 to 800 wide and 250 to 570 high.");
                } else {
                    int type = newImage.getType() == 0 ? 2 : newImage.getType();
                    BufferedImage resizedImage = new BufferedImage(img_width, img_height, type);
                    Graphics2D g = resizedImage.createGraphics();
                    g.drawImage(newImage, 0, 0, img_width, img_height, null);
                    g.dispose();
                    String imageName = StartPageGui.this.photoPanel.getComponent(0).getName();
                    String imagePath = StartPageGui.this.photosDirectoryPath + imageName + ".jpg";
                    ImageIO.write((RenderedImage)resizedImage, "jpg", new File(imagePath));
                    PhotoRescaled newRescaled = new PhotoRescaled(imagePath, 210, 170);
                    newRescaled.setName(imageName);
                    StartPageGui.this.photoPanel.removeAll();
                    StartPageGui.this.photoPanel.repaint();
                    StartPageGui.this.photoPanel.add(newRescaled);
                    StartPageGui.this.photoPanel.validate();
                    Enumeration<AbstractButton> elements = StartPageGui.this.group.getElements();
                    while (elements.hasMoreElements()) {
                        AbstractButton button = elements.nextElement();
                        String noOfElements = button.getText();
                        String recordsFileName = imageName + "_" + noOfElements + ".txt";
                        StartPageGui.this.pm.clearRecords(recordsFileName);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    class PhotoButtonsHandler
    implements ActionListener {
        PhotoButtonsHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            JButton clickedButton = (JButton)e.getSource();
            String clickedButtonText = clickedButton.getText();
            PhotoRescaled thisImage = (PhotoRescaled)StartPageGui.this.photoPanel.getComponent(0);
            String thisImageName = thisImage.getName();
            List<Photo> photos = StartPageGui.this.pm.getAllPhotos();
            String firstImageName = photos.get(0).getName();
            String lastImageName = photos.get(photos.size() - 1).getName();
            if (!(thisImageName.equals(firstImageName) && clickedButtonText.equals("<  Previous") || thisImageName.equals(lastImageName) && clickedButtonText.equals("Next  >"))) {
                PhotoRescaled nextImage;
                int buttonIndex = clickedButtonText.equals("Next  >") ? 1 : -1;
                int thisImageIndex = 0;
                for (Photo photo : photos) {
                    if (!photo.getName().equals(thisImageName)) continue;
                    thisImageIndex = photos.indexOf(photo);
                    break;
                }
                int nextImageIndex = thisImageIndex + buttonIndex;
                Photo nextPhoto = photos.get(nextImageIndex);
                String nextPath = StartPageGui.this.photosDirectoryPath + nextPhoto.getName() + ".jpg";
                if (thisImage.getMouseListeners().length != 0) {
                    nextImage = new PhotoRescaled(nextPath, 250, 200);
                    nextImage.addMouseListener(new PlayHandler());
                } else {
                    nextImage = new PhotoRescaled(nextPath, 210, 170);
                }
                thisImage = null;
                nextImage.setName(nextPhoto.getName());
                StartPageGui.this.photoPanel.removeAll();
                StartPageGui.this.photoPanel.repaint();
                StartPageGui.this.photoPanel.add(nextImage);
                StartPageGui.this.photoPanel.validate();
                List<String> labels = nextPhoto.getDifficulties();
                StartPageGui.this.displayLevels(labels);
            }
        }
    }

    class PlayHandler
    extends MouseAdapter {
        PlayHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            String noOfElements = null;
            Enumeration<AbstractButton> elements = StartPageGui.this.group.getElements();
            while (elements.hasMoreElements()) {
                AbstractButton button = elements.nextElement();
                if (!button.isSelected()) continue;
                noOfElements = button.getText();
                break;
            }
            if (noOfElements != null) {
                System.gc();
                for (Window window : Window.getWindows()) {
                    if (window.equals(f)) continue;
                    window.dispose();
                }
                String playerName = JOptionPane.showInputDialog(f, (Object)"Enter your name");
                if (playerName != null && playerName.length() == 0) {
                    playerName = "Unknown";
                }
                if (playerName != null) {
                    PhotoRescaled image = (PhotoRescaled)e.getSource();
                    String imageName = image.getName();
                    String imagePath = StartPageGui.this.photosDirectoryPath + imageName + ".jpg";
                    int xCoordinate = Integer.parseInt(noOfElements.split("x")[0]);
                    int yCoordinate = Integer.parseInt(noOfElements.split("x")[1]);
                    String recordFileName = imageName + "_" + noOfElements + ".txt";
                    new PlayPuzzleGui(StartPageGui.this.pm, recordFileName, imagePath, xCoordinate, yCoordinate, playerName);
                }
            }
        }
    }

    class SettingsHandler
    implements ActionListener {
        SettingsHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            StartPageGui.this.elementsPanel.setLayout(new FlowLayout(1, 25, 0));
            StartPageGui.this.photoPanel.setPreferredSize(new Dimension(250, 220));
            PhotoRescaled thisImage = (PhotoRescaled)StartPageGui.this.photoPanel.getComponent(0);
            String imageName = thisImage.getName();
            String imagePath = StartPageGui.this.photosDirectoryPath + imageName + ".jpg";
            PhotoRescaled newImage = new PhotoRescaled(imagePath, 210, 170);
            newImage.setName(imageName);
            StartPageGui.this.photoPanel.removeAll();
            StartPageGui.this.photoPanel.repaint();
            StartPageGui.this.photoPanel.add(newImage);
            StartPageGui.this.photoPanel.validate();
            centralPanel.removeAll();
            centralPanel.repaint();
            centralPanel.add((Component)StartPageGui.this.settingsPanel, "West");
            centralPanel.add((Component)StartPageGui.this.gamePanel, "Center");
            centralPanel.validate();
        }
    }

    class PuzzleHandler
    implements ActionListener {
        PuzzleHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            StartPageGui.this.elementsPanel.setLayout(new FlowLayout(1, 40, 20));
            StartPageGui.this.photoPanel.setPreferredSize(new Dimension(360, 220));
            PhotoRescaled thisImage = (PhotoRescaled)StartPageGui.this.photoPanel.getComponent(0);
            String imageName = thisImage.getName();
            String imagePath = StartPageGui.this.photosDirectoryPath + imageName + ".jpg";
            PhotoRescaled newImage = new PhotoRescaled(imagePath, 250, 200);
            newImage.setName(imageName);
            newImage.addMouseListener(new PlayHandler());
            StartPageGui.this.photoPanel.removeAll();
            StartPageGui.this.photoPanel.repaint();
            StartPageGui.this.photoPanel.add(newImage);
            StartPageGui.this.photoPanel.validate();
            centralPanel.removeAll();
            centralPanel.repaint();
            centralPanel.add(StartPageGui.this.gamePanel);
            centralPanel.validate();
        }
    }

    class HowToPlayHandler
    implements ActionListener {
        HowToPlayHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            centralPanel.removeAll();
            centralPanel.repaint();
            centralPanel.add(StartPageGui.this.tp);
            InputStream in = null;
            try {
                File file = new File("resources/howToPlay.rtf");
                in = new FileInputStream(file);
                dsd.remove(0, dsd.getLength());
                StartPageGui.this.kit.read(in, (Document)dsd, 0);
                StartPageGui.this.tp.setDocument(dsd);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                }
            }
        }
    }
}

