/*
 * Decompiled with CFR 0.152.
 */
package fachkonzept;

import fachkonzept.Console;
import fachkonzept.CubePosition;
import fachkonzept.Mode;
import fachkonzept.Plane;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cube {
    private Plane[] plane = new Plane[6];
    public static Mode[] programFlower = new Mode[]{new Mode(Mode.Modes.rotateCubeXRight, 1), new Mode(Mode.Modes.rotateCubeXRight, 1), new Mode(Mode.Modes.rotateCubeYLeft, 1), new Mode(Mode.Modes.rotateCubeYLeft, 1), new Mode(Mode.Modes.rotateCubeZLeft, 1), new Mode(Mode.Modes.rotateCubeZLeft, 1)};
    public static Mode[] programPoints = new Mode[]{new Mode(Mode.Modes.rotateCubeXRight, 1), new Mode(Mode.Modes.rotateCubeYLeft, 1), new Mode(Mode.Modes.rotateCubeXLeft, 1), new Mode(Mode.Modes.rotateCubeYRight, 1)};
    public static Mode[] programStripes = new Mode[]{new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeZLeft, 1), new Mode(Mode.Modes.rotateCubeZLeft, 1), new Mode(Mode.Modes.rotateCubeXRight, 1), new Mode(Mode.Modes.rotateCubeXRight, 1)};
    public static Mode[] programPlane1GetEdge = new Mode[]{new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeYLeft, 1), new Mode(Mode.Modes.rotateCubeXLeft, 2)};
    public static Mode[] programPlane1GetLeftCorner = new Mode[]{new Mode(Mode.Modes.rotateCubeZRight, 2), new Mode(Mode.Modes.rotateCubeYLeft, 2), new Mode(Mode.Modes.rotateCubeZLeft, 2)};
    public static Mode[] programPlane1GetRightCorner = new Mode[]{new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeYRight, 2), new Mode(Mode.Modes.rotateCubeXRight, 2)};
    public static Mode[] programPlane1GetBottomCorner = new Mode[]{new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeYLeft, 2), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeZRight, 2), new Mode(Mode.Modes.rotateCubeYRight, 2), new Mode(Mode.Modes.rotateCubeYRight, 2), new Mode(Mode.Modes.rotateCubeZLeft, 2)};
    public static Mode[] programPlane1LeftRotateCorner = new Mode[]{new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeYRight, 2), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeYLeft, 2), new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeYRight, 2), new Mode(Mode.Modes.rotateCubeXRight, 2)};
    public static Mode[] programPlane1RightRotateCorner = new Mode[]{new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeYLeft, 2), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeYRight, 2), new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeYLeft, 2), new Mode(Mode.Modes.rotateCubeXRight, 2)};
    public static Mode[] programPlane2EdgesLeft = new Mode[]{new Mode(Mode.Modes.rotateCubeYLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 2), new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeZRight, 2), new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeYLeft, 0), new Mode(Mode.Modes.rotateCubeXLeft, 2)};
    public static Mode[] programPlane2EdgesRight = new Mode[]{new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft, 0), new Mode(Mode.Modes.rotateCubeZRight, 0), new Mode(Mode.Modes.rotateCubeYLeft, 0), new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeXRight, 2)};
    public static Mode[] programPlane3SwapEdges = new Mode[]{new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeZRight, 0), new Mode(Mode.Modes.rotateCubeYLeft, 0), new Mode(Mode.Modes.rotateCubeXLeft, 2)};
    public static Mode[] programPlane3FlipEdges = new Mode[]{new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeYLeft, 1), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeYLeft, 1), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeYLeft, 1), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeYLeft, 1)};
    public static Mode[] programPlane3SwapLeftCorner = new Mode[]{new Mode(Mode.Modes.rotateCubeZLeft, 2), new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft, 0), new Mode(Mode.Modes.rotateCubeZRight, 2), new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeZRight, 0), new Mode(Mode.Modes.rotateCubeYLeft, 0)};
    public static Mode[] programPlane3SwapRightCorner = new Mode[]{new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeYLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 2), new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeZRight, 0), new Mode(Mode.Modes.rotateCubeYLeft, 0), new Mode(Mode.Modes.rotateCubeZRight, 2), new Mode(Mode.Modes.rotateCubeYRight, 0)};
    public static Mode[] programPlane3FlipCorner = new Mode[]{new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeZLeft, 2), new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeZRight, 2), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeZLeft, 2), new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeZRight, 2)};
    private static CubePosition[] edgePositions = new CubePosition[]{new CubePosition(0, 1, 0, 0), new CubePosition(5, 0, 1, 0), new CubePosition(0, 1, 2, 1), new CubePosition(4, 0, 1, 1), new CubePosition(0, 0, 1, 2), new CubePosition(3, 2, 1, 2), new CubePosition(0, 2, 1, 3), new CubePosition(1, 0, 1, 3), new CubePosition(1, 1, 0, 4), new CubePosition(5, 1, 2, 4), new CubePosition(1, 1, 2, 5), new CubePosition(4, 1, 0, 5), new CubePosition(1, 2, 1, 6), new CubePosition(2, 0, 1, 6), new CubePosition(2, 1, 0, 7), new CubePosition(5, 2, 1, 7), new CubePosition(2, 1, 2, 8), new CubePosition(4, 2, 1, 8), new CubePosition(2, 2, 1, 9), new CubePosition(3, 0, 1, 9), new CubePosition(3, 1, 0, 10), new CubePosition(5, 1, 0, 10), new CubePosition(3, 1, 2, 11), new CubePosition(4, 1, 2, 11)};
    private static CubePosition[] cornerPositions = new CubePosition[]{new CubePosition(0, 0, 0, 0), new CubePosition(5, 0, 0, 0), new CubePosition(3, 2, 0, 0), new CubePosition(1, 0, 0, 1), new CubePosition(5, 0, 2, 1), new CubePosition(0, 2, 0, 1), new CubePosition(2, 0, 0, 2), new CubePosition(5, 2, 2, 2), new CubePosition(1, 2, 0, 2), new CubePosition(3, 0, 0, 3), new CubePosition(5, 2, 0, 3), new CubePosition(2, 2, 0, 3), new CubePosition(0, 0, 2, 4), new CubePosition(3, 2, 2, 4), new CubePosition(4, 0, 2, 4), new CubePosition(1, 0, 2, 5), new CubePosition(0, 2, 2, 5), new CubePosition(4, 0, 0, 5), new CubePosition(2, 0, 2, 6), new CubePosition(1, 2, 2, 6), new CubePosition(4, 2, 0, 6), new CubePosition(3, 0, 2, 7), new CubePosition(2, 2, 2, 7), new CubePosition(4, 2, 2, 7)};
    private List<Mode> program;

    public Cube() {
        this.program = Collections.synchronizedList(new LinkedList());
        this.init();
    }

    public Cube(Cube cube) {
        this.program = Collections.synchronizedList(new LinkedList<Mode>(cube.program));
        this.program.clear();
        this.program.addAll(cube.program);
        for (int i = 0; i < 6; ++i) {
            this.plane[i] = cube.plane[i].clone();
        }
    }

    public Cube clone() {
        return new Cube(this);
    }

    public final void init() {
        this.plane[0] = new Plane(0);
        this.plane[1] = new Plane(1);
        this.plane[4] = new Plane(2);
        this.plane[2] = new Plane(3);
        this.plane[3] = new Plane(4);
        this.plane[5] = new Plane(5);
        this.program.clear();
    }

    public Cube shuffle(int n) {
        Cube cube = this;
        for (int i = 0; i < n; ++i) {
            cube = cube.push((int)(Math.random() * 3.0), (int)(Math.random() * 3.0), (int)(Math.random() * 2.0));
        }
        return cube;
    }

    public int getCell(CubePosition p) {
        return this.plane[p.getPlane()].getCell(p.getX(), p.getY());
    }

    public Plane getPlane(int plane) {
        if (plane < 0 || plane > 5) {
            throw new IndexOutOfBoundsException("Wrong Plane Number: " + plane);
        }
        return this.plane[plane];
    }

    public Cube step(Mode mode) {
        switch (mode.mode) {
            case rotateCubeXRight: {
                if (mode.modeRow < 0) {
                    return this.rotateXRight();
                }
                return this.pushXRight(mode.modeRow);
            }
            case rotateCubeXLeft: {
                if (mode.modeRow < 0) {
                    return this.rotateXLeft();
                }
                return this.pushXLeft(mode.modeRow);
            }
            case rotateCubeYRight: {
                if (mode.modeRow < 0) {
                    return this.rotateYRight();
                }
                return this.pushYRight(mode.modeRow);
            }
            case rotateCubeYLeft: {
                if (mode.modeRow < 0) {
                    return this.rotateYLeft();
                }
                return this.pushYLeft(mode.modeRow);
            }
            case rotateCubeZRight: {
                if (mode.modeRow < 0) {
                    return this.rotateZRight();
                }
                return this.pushZRight(mode.modeRow);
            }
            case rotateCubeZLeft: {
                if (mode.modeRow < 0) {
                    return this.rotateZLeft();
                }
                return this.pushZLeft(mode.modeRow);
            }
        }
        return this;
    }

    public void addProgram(Mode mode) {
        this.program.add(mode);
    }

    public void addProgram(Mode[] program) {
        Cube.addProgram(this.program, program);
    }

    public static void addProgram(List<Mode> program, Mode[] p) {
        for (int i = 0; i < p.length; ++i) {
            program.add(p[i]);
        }
    }

    public void clearProgram() {
        this.program.clear();
    }

    public boolean hasNextProgramStep() {
        return !this.program.isEmpty();
    }

    public Mode getNextProgramStep() {
        if (this.program.isEmpty()) {
            return new Mode();
        }
        return this.program.remove(0);
    }

    public CubePosition correspondingEdgePosition(CubePosition p) {
        for (int i = 0; i < edgePositions.length / 2; ++i) {
            if (p.equals(edgePositions[2 * i])) {
                return edgePositions[i * 2 + 1];
            }
            if (!p.equals(edgePositions[2 * i + 1])) continue;
            return edgePositions[i * 2];
        }
        return null;
    }

    public CubePosition findEdge(int color1, int color2) {
        int i = 0;
        while (true) {
            if (i >= edgePositions.length / 2) break;
            CubePosition p0 = edgePositions[i * 2];
            CubePosition p1 = edgePositions[i * 2 + 1];
            if (this.getCell(p0) == color1 && this.getCell(p1) == color2) {
                return p0;
            }
            if (this.getCell(p1) == color1 && this.getCell(p0) == color2) {
                return p1;
            }
            ++i;
        }
        return null;
    }

    public CubePosition findCorner(int color1, int color2, int color3) {
        int i = 0;
        while (true) {
            if (i >= cornerPositions.length / 3) break;
            CubePosition p1 = cornerPositions[i * 3];
            CubePosition p2 = cornerPositions[i * 3 + 1];
            CubePosition p3 = cornerPositions[i * 3 + 2];
            if (this.getCell(p1) == color1 && (this.getCell(p2) == color2 && this.getCell(p3) == color3 || this.getCell(p2) == color3 && this.getCell(p3) == color2)) {
                return p1;
            }
            if (this.getCell(p2) == color1 && (this.getCell(p3) == color2 && this.getCell(p1) == color3 || this.getCell(p3) == color3 && this.getCell(p1) == color2)) {
                return p2;
            }
            if (this.getCell(p3) == color1 && (this.getCell(p1) == color2 && this.getCell(p2) == color3 || this.getCell(p1) == color3 && this.getCell(p2) == color2)) {
                return p3;
            }
            ++i;
        }
        return null;
    }

    public Mode[] getSolution() {
        int i;
        int i2;
        int c;
        int i3;
        int i4;
        int n;
        CubePosition p;
        int k;
        int c2;
        ArrayList<Mode> e = new ArrayList<Mode>();
        int[] solutionColors = new int[]{this.plane[5].getCell(1, 1), this.plane[1].getCell(1, 1), this.plane[2].getCell(1, 1), this.plane[3].getCell(1, 1), this.plane[0].getCell(1, 1), this.plane[4].getCell(1, 1)};
        Cube cube = this.clone();
        for (c2 = 1; c2 < 5; ++c2) {
            k = e.size();
            p = cube.findEdge(solutionColors[0], solutionColors[c2]);
            if (p != null) {
                if (p.getPlane() == 4) {
                    n = p.getX() == 0 ? 3 : (p.getY() == 0 ? 0 : (p.getX() == 2 ? 1 : 2));
                    if (n == 3) {
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                    } else {
                        for (i4 = 0; i4 < n; ++i4) {
                            e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                        }
                    }
                    e.add(new Mode(Mode.Modes.rotateCubeZLeft, 2));
                    e.add(new Mode(Mode.Modes.rotateCubeZLeft, 2));
                } else if (p.getPlane() == 5) {
                    if (p.getX() == 2) {
                        e.add(new Mode(Mode.Modes.rotateCubeXLeft, 2));
                        e.add(new Mode(Mode.Modes.rotateCubeYRight, 1));
                        e.add(new Mode(Mode.Modes.rotateCubeZRight, 2));
                    } else if (p.getY() == 0) {
                        e.add(new Mode(Mode.Modes.rotateCubeZLeft, 0));
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
                        e.add(new Mode(Mode.Modes.rotateCubeZLeft, 2));
                    } else if (p.getX() == 0) {
                        e.add(new Mode(Mode.Modes.rotateCubeXLeft, 0));
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
                        e.add(new Mode(Mode.Modes.rotateCubeZLeft, 2));
                    }
                } else if (p.getY() == 2) {
                    if (p.getPlane() == 0) {
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                    } else if (p.getPlane() == 1) {
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                    } else if (p.getPlane() == 3) {
                        e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    }
                    e.add(new Mode(Mode.Modes.rotateCubeXLeft, 1));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    e.add(new Mode(Mode.Modes.rotateCubeXRight, 1));
                } else if (p.getY() == 1) {
                    n = p.getX() == 0 ? (2 - p.getPlane() + 4) % 4 : (4 - p.getPlane()) % 4;
                    if (n == 3) {
                        e.add(new Mode(Mode.Modes.rotateCubeYRight, 1));
                    } else {
                        for (i4 = 0; i4 < n; ++i4) {
                            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
                        }
                    }
                    if (p.getX() == 0) {
                        e.add(new Mode(Mode.Modes.rotateCubeZLeft, 2));
                    } else {
                        e.add(new Mode(Mode.Modes.rotateCubeZRight, 2));
                    }
                } else {
                    switch (p.getPlane()) {
                        case 0: {
                            e.add(new Mode(Mode.Modes.rotateCubeXRight, 0));
                            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
                            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
                            break;
                        }
                        case 1: {
                            e.add(new Mode(Mode.Modes.rotateCubeZLeft, 2));
                            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
                            break;
                        }
                        case 2: {
                            e.add(new Mode(Mode.Modes.rotateCubeXLeft, 2));
                            break;
                        }
                        default: {
                            e.add(new Mode(Mode.Modes.rotateCubeZRight, 0));
                            e.add(new Mode(Mode.Modes.rotateCubeYRight, 1));
                        }
                    }
                    e.add(new Mode(Mode.Modes.rotateCubeZLeft, 2));
                }
            }
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
            for (i3 = k; i3 < e.size(); ++i3) {
                cube = cube.step((Mode)e.get(i3));
            }
        }
        for (c2 = 1; c2 < 5; ++c2) {
            k = e.size();
            p = cube.findCorner(solutionColors[0], solutionColors[c2], solutionColors[c2 % 4 + 1]);
            if (p.getPlane() == 4) {
                if (p.getX() == 0) {
                    if (p.getY() == 0) {
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                    } else {
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                    }
                } else if (p.getX() == 2 && p.getY() == 2) {
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                }
                Cube.addProgram(e, programPlane1GetBottomCorner);
            } else if (p.getPlane() == 5) {
                if (p.getX() == 0) {
                    if (p.getY() == 0) {
                        e.add(new Mode(Mode.Modes.rotateCubeZLeft, 0));
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                        e.add(new Mode(Mode.Modes.rotateCubeZRight, 0));
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                    } else if (p.getY() == 2) {
                        e.add(new Mode(Mode.Modes.rotateCubeXLeft, 0));
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                        e.add(new Mode(Mode.Modes.rotateCubeXRight, 0));
                    }
                    Cube.addProgram(e, programPlane1GetRightCorner);
                } else if (p.getX() == 2 && p.getY() == 0) {
                    e.add(new Mode(Mode.Modes.rotateCubeZRight, 0));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    e.add(new Mode(Mode.Modes.rotateCubeZLeft, 0));
                    Cube.addProgram(e, programPlane1GetLeftCorner);
                }
            } else if (p.getY() == 2) {
                if (p.getX() == 0) {
                    n = (2 - p.getPlane() + 4) % 4;
                    if (n == 3) {
                        e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    } else {
                        for (i4 = 0; i4 < n; ++i4) {
                            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                        }
                    }
                    Cube.addProgram(e, programPlane1GetRightCorner);
                } else {
                    n = (1 - p.getPlane() + 4) % 4;
                    if (n == 3) {
                        e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    } else {
                        for (i4 = 0; i4 < n; ++i4) {
                            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                        }
                    }
                    Cube.addProgram(e, programPlane1GetLeftCorner);
                }
            } else if (p.getX() == 2) {
                if (p.getPlane() == 0) {
                    e.add(new Mode(Mode.Modes.rotateCubeZLeft, 2));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    e.add(new Mode(Mode.Modes.rotateCubeZRight, 2));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    Cube.addProgram(e, programPlane1GetBottomCorner);
                } else if (p.getPlane() == 2) {
                    e.add(new Mode(Mode.Modes.rotateCubeZRight, 0));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    e.add(new Mode(Mode.Modes.rotateCubeZLeft, 0));
                    Cube.addProgram(e, programPlane1GetBottomCorner);
                } else if (p.getPlane() == 3) {
                    e.add(new Mode(Mode.Modes.rotateCubeXRight, 0));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    e.add(new Mode(Mode.Modes.rotateCubeXLeft, 0));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 2));
                    Cube.addProgram(e, programPlane1GetBottomCorner);
                } else {
                    Cube.addProgram(e, programPlane1RightRotateCorner);
                }
            } else if (p.getPlane() == 0) {
                e.add(new Mode(Mode.Modes.rotateCubeZLeft, 0));
                e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                e.add(new Mode(Mode.Modes.rotateCubeZRight, 0));
                e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                Cube.addProgram(e, programPlane1GetBottomCorner);
            } else if (p.getPlane() == 1) {
                e.add(new Mode(Mode.Modes.rotateCubeXLeft, 0));
                e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                e.add(new Mode(Mode.Modes.rotateCubeXRight, 0));
                Cube.addProgram(e, programPlane1GetBottomCorner);
            } else if (p.getPlane() == 3) {
                e.add(new Mode(Mode.Modes.rotateCubeXRight, 2));
                e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                e.add(new Mode(Mode.Modes.rotateCubeXLeft, 2));
                e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                e.add(new Mode(Mode.Modes.rotateCubeYLeft, 2));
                Cube.addProgram(e, programPlane1GetBottomCorner);
            } else {
                Cube.addProgram(e, programPlane1LeftRotateCorner);
            }
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
            for (i3 = k; i3 < e.size(); ++i3) {
                cube = cube.step(e.get(i3));
            }
        }
        e.add(new Mode(Mode.Modes.rotateCubeZRight));
        e.add(new Mode(Mode.Modes.rotateCubeZRight));
        cube = cube.step((Mode)e.get(e.size() - 2));
        cube = cube.step((Mode)e.get(e.size() - 1));
        int t = solutionColors[0];
        solutionColors[0] = solutionColors[5];
        solutionColors[5] = t;
        t = solutionColors[4];
        solutionColors[4] = solutionColors[1];
        solutionColors[1] = t;
        t = solutionColors[3];
        solutionColors[3] = solutionColors[2];
        solutionColors[2] = t;
        t = cube.getCell(new CubePosition(2, 1, 1));
        if (t == solutionColors[4]) {
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 1));
            cube = cube.step(e.get(e.size() - 1));
        } else if (t == solutionColors[2]) {
            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
            cube = cube.step(e.get(e.size() - 1));
        } else if (t == solutionColors[3]) {
            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 1));
            cube = cube.step(e.get(e.size() - 2));
            cube = cube.step(e.get(e.size() - 1));
        }
        for (c = 1; c < 5; ++c) {
            int k2 = e.size();
            CubePosition p2 = cube.findEdge(solutionColors[c], solutionColors[(c - 1 + 3) % 4 + 1]);
            if (p2.getPlane() == 5) {
                if (p2.getY() == 0) {
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
                } else if (p2.getX() == 0) {
                    e.add(new Mode(Mode.Modes.rotateCubeYLeft, 0));
                } else if (p2.getX() == 2) {
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
                }
                e.add(new Mode(Mode.Modes.rotateCubeYLeft));
                Cube.addProgram(e, programPlane2EdgesRight);
                e.add(new Mode(Mode.Modes.rotateCubeYRight));
            } else if (p2.getY() == 0) {
                if (p2.getPlane() == 1) {
                    e.add(new Mode(Mode.Modes.rotateCubeYLeft, 0));
                } else if (p2.getPlane() == 3) {
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
                } else if (p2.getPlane() == 0) {
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
                    e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
                }
                Cube.addProgram(e, programPlane2EdgesLeft);
            } else if (p2.getPlane() != 2 || p2.getX() != 0 || p2.getY() != 1) {
                int n2 = (2 - p2.getPlane() + 4) % 4;
                if (n2 == 3) {
                    e.add(new Mode(Mode.Modes.rotateCubeYRight));
                } else {
                    for (i2 = 0; i2 < n2; ++i2) {
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft));
                    }
                }
                if (p2.getX() == 0) {
                    Cube.addProgram(e, programPlane2EdgesLeft);
                } else {
                    Cube.addProgram(e, programPlane2EdgesRight);
                }
                if (n2 == 3) {
                    e.add(new Mode(Mode.Modes.rotateCubeYLeft));
                } else {
                    for (i2 = 0; i2 < n2; ++i2) {
                        e.add(new Mode(Mode.Modes.rotateCubeYRight));
                    }
                }
                int n1 = (2 - n2 + 4) % 4;
                if (n1 == 3) {
                    e.add(new Mode(Mode.Modes.rotateCubeYLeft, 0));
                } else {
                    for (i = 0; i < n1; ++i) {
                        e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
                    }
                }
                e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
                e.add(new Mode(Mode.Modes.rotateCubeYLeft));
                Cube.addProgram(e, programPlane2EdgesRight);
                e.add(new Mode(Mode.Modes.rotateCubeYRight));
            }
            e.add(new Mode(Mode.Modes.rotateCubeYRight));
            for (i4 = k2; i4 < e.size(); ++i4) {
                cube = cube.step(e.get(i4));
            }
        }
        for (c = 1; c < 5; ++c) {
            int k3 = e.size();
            CubePosition p3 = cube.findEdge(solutionColors[0], solutionColors[(c - 1 + 3) % 4 + 1]);
            int plane = p3.getPlane();
            if (plane == 5) {
                plane = p3.getX() == 0 ? 4 : (p3.getX() == 2 ? 2 : (p3.getY() == 0 ? 3 : 1));
            }
            if (plane != 1) {
                if (c == 1) {
                    int n3 = (1 - plane + 4) % 4;
                    if (n3 == 3) {
                        e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
                    } else {
                        for (i = 0; i < n3; ++i) {
                            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 0));
                        }
                    }
                } else if (c == 2) {
                    if (plane == 3) {
                        e.add(new Mode(Mode.Modes.rotateCubeYRight));
                        Cube.addProgram(e, programPlane3SwapEdges);
                        e.add(new Mode(Mode.Modes.rotateCubeYLeft));
                    }
                    Cube.addProgram(e, programPlane3SwapEdges);
                } else {
                    Cube.addProgram(e, programPlane3SwapEdges);
                }
            }
            e.add(new Mode(Mode.Modes.rotateCubeYRight));
            for (i2 = k3; i2 < e.size(); ++i2) {
                cube = cube.step(e.get(i2));
            }
        }
        for (c = 1; c < 5; ++c) {
            int cShould;
            int k4 = e.size();
            int cIs = cube.getCell(new CubePosition(2, 1, 0));
            if (cIs != (cShould = solutionColors[c])) {
                Cube.addProgram(e, programPlane3FlipEdges);
            }
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
            for (i2 = k4; i2 < e.size(); ++i2) {
                cube = cube.step(e.get(i2));
            }
        }
        int c0 = solutionColors[4];
        int c1 = solutionColors[1];
        CubePosition p4 = cube.findCorner(solutionColors[0], c0, c1);
        int k5 = e.size();
        if (p4.getNo() == 0) {
            Cube.addProgram(e, programPlane3SwapLeftCorner);
        } else if (p4.getNo() == 1) {
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
            Cube.addProgram(e, programPlane3SwapRightCorner);
            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 0));
            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 0));
        } else if (p4.getNo() == 3) {
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
            Cube.addProgram(e, programPlane3SwapLeftCorner);
            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 0));
            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 0));
        }
        for (i2 = k5; i2 < e.size(); ++i2) {
            cube = cube.step(e.get(i2));
        }
        k5 = e.size();
        c0 = solutionColors[1];
        c1 = solutionColors[2];
        p4 = cube.findCorner(solutionColors[0], c0, c1);
        if (p4.getNo() == 0) {
            e.add(new Mode(Mode.Modes.rotateCubeYLeft, 0));
            Cube.addProgram(e, programPlane3SwapLeftCorner);
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
        } else if (p4.getNo() == 1) {
            Cube.addProgram(e, programPlane3SwapRightCorner);
        }
        for (i2 = k5; i2 < e.size(); ++i2) {
            cube = cube.step(e.get(i2));
        }
        for (int c3 = 1; c3 < 5; ++c3) {
            k5 = e.size();
            if (cube.getCell(new CubePosition(1, 2, 0)) == solutionColors[0]) {
                Cube.addProgram(e, programPlane3FlipCorner);
            } else if (cube.getCell(new CubePosition(2, 0, 0)) == solutionColors[0]) {
                Cube.addProgram(e, programPlane3FlipCorner);
                Cube.addProgram(e, programPlane3FlipCorner);
            }
            e.add(new Mode(Mode.Modes.rotateCubeYRight, 0));
            for (i = k5; i < e.size(); ++i) {
                cube = cube.step(e.get(i));
            }
        }
        Mode[] m = new Mode[e.size()];
        return e.toArray(m);
    }

    public Cube rotate(int axis, int direction) {
        if (axis < 0 || axis > 2) {
            throw new IllegalArgumentException("Wrong axis: " + axis);
        }
        if (direction < 0 || direction > 1) {
            throw new IllegalArgumentException("Wrong direction: " + direction);
        }
        switch (axis) {
            case 0: {
                if (direction == 0) {
                    return this.rotateXLeft();
                }
                return this.rotateXRight();
            }
            case 1: {
                if (direction == 0) {
                    return this.rotateYLeft();
                }
                return this.rotateYRight();
            }
        }
        if (direction == 0) {
            return this.rotateZLeft();
        }
        return this.rotateZRight();
    }

    public Cube rotateZLeft() {
        Cube cube = this.clone();
        Plane tmp = cube.plane[0];
        cube.plane[0] = cube.plane[5].rotateLeft();
        cube.plane[5] = cube.plane[2].rotateLeft();
        cube.plane[2] = cube.plane[4].rotateLeft();
        cube.plane[4] = tmp.rotateLeft();
        cube.plane[1] = cube.plane[1].rotateLeft();
        cube.plane[3] = cube.plane[3].rotateRight();
        return cube;
    }

    public Cube rotateZRight() {
        Cube cube = this.clone();
        Plane tmp = cube.plane[0];
        cube.plane[0] = cube.plane[4].rotateRight();
        cube.plane[4] = cube.plane[2].rotateRight();
        cube.plane[2] = cube.plane[5].rotateRight();
        cube.plane[5] = tmp.rotateRight();
        cube.plane[1] = cube.plane[1].rotateRight();
        cube.plane[3] = cube.plane[3].rotateLeft();
        return cube;
    }

    public Cube rotateYLeft() {
        Cube cube = this.clone();
        Plane tmp = cube.plane[0];
        cube.plane[0] = cube.plane[3];
        cube.plane[3] = cube.plane[2];
        cube.plane[2] = cube.plane[1];
        cube.plane[1] = tmp;
        cube.plane[4] = cube.plane[4].rotateRight();
        cube.plane[5] = cube.plane[5].rotateLeft();
        return cube;
    }

    public Cube rotateYRight() {
        Cube cube = this.clone();
        Plane tmp = cube.plane[0];
        cube.plane[0] = cube.plane[1];
        cube.plane[1] = cube.plane[2];
        cube.plane[2] = cube.plane[3];
        cube.plane[3] = tmp;
        cube.plane[4] = cube.plane[4].rotateLeft();
        cube.plane[5] = cube.plane[5].rotateRight();
        return cube;
    }

    public Cube rotateXLeft() {
        Cube cube = this.clone();
        Plane tmp = cube.plane[4];
        cube.plane[4] = cube.plane[1];
        cube.plane[1] = cube.plane[5];
        cube.plane[5] = cube.plane[3].upsideDown();
        cube.plane[3] = tmp.upsideDown();
        cube.plane[0] = cube.plane[0].rotateRight();
        cube.plane[2] = cube.plane[2].rotateLeft();
        return cube;
    }

    public Cube rotateXRight() {
        Cube cube = this.clone();
        Plane tmp = cube.plane[4];
        cube.plane[4] = cube.plane[3].upsideDown();
        cube.plane[3] = cube.plane[5].upsideDown();
        cube.plane[5] = cube.plane[1];
        cube.plane[1] = tmp;
        cube.plane[2] = cube.plane[2].rotateRight();
        cube.plane[0] = cube.plane[0].rotateLeft();
        return cube;
    }

    public Cube push(int columnNo, int axis, int direction) {
        if (columnNo < 0 || columnNo >= 3) {
            throw new IllegalArgumentException("Not a valid row number: " + columnNo);
        }
        if (axis < 0 || axis > 2) {
            throw new IllegalArgumentException("Wrong axis: " + axis);
        }
        if (direction < 0 || direction > 1) {
            throw new IllegalArgumentException("Wrong direction: " + direction);
        }
        switch (axis) {
            case 0: {
                if (direction == 0) {
                    return this.pushXLeft(columnNo);
                }
                return this.pushXRight(columnNo);
            }
            case 1: {
                if (direction == 0) {
                    return this.pushYLeft(columnNo);
                }
                return this.pushYRight(columnNo);
            }
        }
        if (direction == 0) {
            return this.pushZLeft(columnNo);
        }
        return this.pushZRight(columnNo);
    }

    public Cube pushYLeft(int rowNo) {
        if (rowNo < 0 || rowNo >= 3) {
            throw new IllegalArgumentException("Not a valid row number: " + rowNo);
        }
        Cube cube = new Cube(this);
        int[] tmp = cube.plane[0].getRow(rowNo);
        cube.plane[0].setRow(rowNo, cube.plane[3].getRow(rowNo), false);
        cube.plane[3].setRow(rowNo, cube.plane[2].getRow(rowNo), false);
        cube.plane[2].setRow(rowNo, cube.plane[1].getRow(rowNo), false);
        cube.plane[1].setRow(rowNo, tmp, false);
        if (rowNo == 0) {
            cube.plane[5] = cube.plane[5].rotateLeft();
        } else if (rowNo == 2) {
            cube.plane[4] = cube.plane[4].rotateRight();
        }
        return cube;
    }

    public Cube pushYRight(int rowNo) {
        if (rowNo < 0 || rowNo >= 3) {
            throw new IllegalArgumentException("Not a valid row number: " + rowNo);
        }
        Cube cube = new Cube(this);
        int[] tmp = cube.plane[0].getRow(rowNo);
        cube.plane[0].setRow(rowNo, cube.plane[1].getRow(rowNo), false);
        cube.plane[1].setRow(rowNo, cube.plane[2].getRow(rowNo), false);
        cube.plane[2].setRow(rowNo, cube.plane[3].getRow(rowNo), false);
        cube.plane[3].setRow(rowNo, tmp, false);
        if (rowNo == 0) {
            cube.plane[5] = cube.plane[5].rotateRight();
        } else if (rowNo == 2) {
            cube.plane[4] = cube.plane[4].rotateLeft();
        }
        return cube;
    }

    public Cube pushXLeft(int columnNo) {
        if (columnNo < 0 || columnNo >= 3) {
            throw new IllegalArgumentException("Not a valid row number: " + columnNo);
        }
        Cube cube = new Cube(this);
        int[] tmp = cube.plane[4].getColumn(columnNo);
        cube.plane[4].setColumn(columnNo, cube.plane[1].getColumn(columnNo), false);
        cube.plane[1].setColumn(columnNo, cube.plane[5].getColumn(columnNo), false);
        cube.plane[5].setColumn(columnNo, cube.plane[3].getColumn(2 - columnNo), true);
        cube.plane[3].setColumn(2 - columnNo, tmp, true);
        if (columnNo == 0) {
            cube.plane[0] = cube.plane[0].rotateRight();
        } else if (columnNo == 2) {
            cube.plane[2] = cube.plane[2].rotateLeft();
        }
        return cube;
    }

    public Cube pushXRight(int columnNo) {
        if (columnNo < 0 || columnNo >= 3) {
            throw new IllegalArgumentException("Not a valid row number: " + columnNo);
        }
        Cube cube = new Cube(this);
        int[] tmp = cube.plane[4].getColumn(columnNo);
        cube.plane[4].setColumn(columnNo, cube.plane[3].getColumn(2 - columnNo), true);
        cube.plane[3].setColumn(2 - columnNo, cube.plane[5].getColumn(columnNo), true);
        cube.plane[5].setColumn(columnNo, cube.plane[1].getColumn(columnNo), false);
        cube.plane[1].setColumn(columnNo, tmp, false);
        if (columnNo == 0) {
            cube.plane[0] = cube.plane[0].rotateLeft();
        } else if (columnNo == 2) {
            cube.plane[2] = cube.plane[2].rotateRight();
        }
        return cube;
    }

    public Cube pushZLeft(int columnNo) {
        if (columnNo < 0 || columnNo >= 3) {
            throw new IllegalArgumentException("Not a valid row number: " + columnNo);
        }
        Cube cube = new Cube(this);
        int[] tmp = cube.plane[0].getColumn(columnNo);
        cube.plane[0].setColumn(columnNo, cube.plane[5].getRow(columnNo), true);
        cube.plane[5].setRow(columnNo, cube.plane[2].getColumn(2 - columnNo), false);
        cube.plane[2].setColumn(2 - columnNo, cube.plane[4].getRow(2 - columnNo), true);
        cube.plane[4].setRow(2 - columnNo, tmp, false);
        if (columnNo == 0) {
            cube.plane[3] = cube.plane[3].rotateRight();
        } else if (columnNo == 2) {
            cube.plane[1] = cube.plane[1].rotateLeft();
        }
        return cube;
    }

    public Cube pushZRight(int columnNo) {
        if (columnNo < 0 || columnNo >= 3) {
            throw new IllegalArgumentException("Not a valid row number: " + columnNo);
        }
        Cube cube = new Cube(this);
        int[] tmp = cube.plane[0].getColumn(columnNo);
        cube.plane[0].setColumn(columnNo, cube.plane[4].getRow(2 - columnNo), false);
        cube.plane[4].setRow(2 - columnNo, cube.plane[2].getColumn(2 - columnNo), true);
        cube.plane[2].setColumn(2 - columnNo, cube.plane[5].getRow(columnNo), false);
        cube.plane[5].setRow(columnNo, tmp, true);
        if (columnNo == 2) {
            cube.plane[1] = cube.plane[1].rotateRight();
        } else if (columnNo == 0) {
            cube.plane[3] = cube.plane[3].rotateLeft();
        }
        return cube;
    }

    public String toString() {
        Console console = new Console(15, 11);
        for (int i = 0; i < 4; ++i) {
            this.plane[i].print(console, i * 4, 4);
        }
        this.plane[4].print(console, 4, 8);
        this.plane[5].print(console, 4, 0);
        return console.toString();
    }

    public static void main(String[] args) {
        Cube c = new Cube();
        c = c.shuffle(20);
        System.out.println(c);
        Mode[] p = c.getSolution();
        for (int i = 0; i < p.length; ++i) {
            c = c.step(p[i]);
        }
        System.out.println(c);
    }
}

