/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.TooltipTimer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;

public class Tooltip {
    private int xPos;
    private int yPos;
    private String message;
    private boolean visible;
    private JFrame parent;
    private TooltipTimer tooltipTimer;
    private Timer timer;

    public Tooltip() {
        this(null);
    }

    public Tooltip(JFrame parent) {
        this(0, 0, "", parent);
        this.visible = false;
    }

    public Tooltip(int xPos, int yPos, String message, JFrame parent) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.message = message;
        this.visible = true;
        this.parent = parent;
        this.tooltipTimer = new TooltipTimer(this);
        this.timer = new Timer();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void resetMessage(String message) {
        this.setAll(this.xPos, this.yPos, message);
    }

    public int getxPos() {
        return this.xPos;
    }

    public void setxPos(int xPos) {
        this.xPos = xPos;
    }

    public int getyPos() {
        return this.yPos;
    }

    public void setyPos(int yPos) {
        this.yPos = yPos;
    }

    public void setAll(int xPos, int yPos, String message) {
        this.visible = false;
        this.xPos = xPos;
        this.yPos = yPos;
        this.message = message;
        this.tooltipTimer.cancel();
        this.tooltipTimer = new TooltipTimer(this);
        this.timer.schedule((TimerTask)this.tooltipTimer, 2000L);
        this.setVisible(true);
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (this.parent != null) {
                this.parent.repaint();
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void paint(Graphics g) {
        int width = g.getFontMetrics().stringWidth(this.message) + 4;
        int height = g.getFontMetrics().getHeight() + 4;
        Rectangle bounds = g.getClipBounds();
        if ((double)(this.xPos + width) > bounds.getX() + bounds.getWidth()) {
            this.xPos = (int)bounds.getX() + (int)bounds.getWidth() - width;
        }
        if ((double)(this.yPos + height) > bounds.getY() + bounds.getHeight()) {
            this.yPos = (int)bounds.getY() + (int)bounds.getHeight() - height;
        }
        g.setColor(Color.white);
        g.fillRect(this.xPos, this.yPos, width, height);
        g.setColor(Color.black);
        g.drawRect(this.xPos, this.yPos, width, height);
        g.drawString(this.message, this.xPos + 2, this.yPos + height - g.getFontMetrics().getDescent() - 2);
    }
}

