/*
 * Decompiled with CFR 0.152.
 */
package model;

import fachkonzept.Cube;
import fachkonzept.Mode;
import fachkonzept.Plane;
import java.util.Observable;

public class CubeModel
extends Observable {
    private Cube cube;

    public CubeModel() {
        this(new Cube());
    }

    public CubeModel(Cube cube) {
        this.cube = cube;
    }

    public final void init() {
        this.cube.init();
        this.setChanged();
        this.notifyObservers();
    }

    public void shuffle(int n) {
        this.cube = this.cube.shuffle(n);
        this.setChanged();
        this.notifyObservers();
    }

    public Plane getPlane(int plane) {
        return this.cube.getPlane(plane);
    }

    public void step(Mode mode) {
        this.cube = this.cube.step(mode);
    }

    public boolean hasNextProgramStep() {
        return this.cube.hasNextProgramStep();
    }

    public Mode getNextProgramStep() {
        return this.cube.getNextProgramStep();
    }

    public void addProgram(Mode[] program) {
        this.cube.addProgram(program);
    }

    public void clearProgram() {
        this.cube.clearProgram();
    }

    public Mode[] getSolution() {
        return this.cube.getSolution();
    }

    public void rotateZRight() {
        this.cube = this.cube.rotateZRight();
        this.setChanged();
        this.notifyObservers();
    }

    public void rotateZLeft() {
        this.cube = this.cube.rotateZLeft();
        this.setChanged();
        this.notifyObservers();
    }

    public void rotateYRight() {
        this.cube = this.cube.rotateYRight();
        this.setChanged();
        this.notifyObservers();
    }

    public void rotateYLeft() {
        this.cube = this.cube.rotateYLeft();
        this.setChanged();
        this.notifyObservers();
    }

    public void rotateXRight() {
        this.cube = this.cube.rotateXRight();
        this.setChanged();
        this.notifyObservers();
    }

    public void rotateXLeft() {
        this.cube = this.cube.rotateXLeft();
        this.setChanged();
        this.notifyObservers();
    }

    public void rotate(int axis, int direction) {
        this.cube = this.cube.rotate(axis, direction);
        this.setChanged();
        this.notifyObservers();
    }

    public void pushZRight(int columnNo) {
        this.cube = this.cube.pushZRight(columnNo);
        this.setChanged();
        this.notifyObservers();
    }

    public void pushZLeft(int columnNo) {
        this.cube = this.cube.pushZLeft(columnNo);
        this.setChanged();
        this.notifyObservers();
    }

    public void pushYRight(int rowNo) {
        this.cube = this.cube.pushYRight(rowNo);
        this.setChanged();
        this.notifyObservers();
    }

    public void pushYLeft(int rowNo) {
        this.cube = this.cube.pushYLeft(rowNo);
        this.setChanged();
        this.notifyObservers();
    }

    public void pushXRight(int columnNo) {
        this.cube = this.cube.pushXRight(columnNo);
        this.setChanged();
        this.notifyObservers();
    }

    public void pushXLeft(int columnNo) {
        this.cube = this.cube.pushXLeft(columnNo);
        this.setChanged();
        this.notifyObservers();
    }
}

