/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class CollectionUtils {
    public static synchronized Collection<Equipment> getEquipment(Collection<Unit> units) {
        ConcurrentLinkedQueue<Equipment> equipment = new ConcurrentLinkedQueue<Equipment>();
        for (Unit unit : units) {
            Equipment equipmentUnit;
            if (!(unit instanceof Equipment) || (equipmentUnit = (Equipment)unit).isSalvaged()) continue;
            equipment.add(equipmentUnit);
        }
        return equipment;
    }

    public static synchronized void mergeEquipments(Collection<Unit> units, Collection<Equipment> equipments) {
        for (Equipment equipmentUnit : equipments) {
            if (units.contains(equipmentUnit)) continue;
            units.add(equipmentUnit);
        }
    }

    public static synchronized Collection<Vehicle> getVehicle(Collection<Unit> units) {
        ConcurrentLinkedQueue<Vehicle> vehicles = new ConcurrentLinkedQueue<Vehicle>();
        for (Unit unit : units) {
            Vehicle vehicleUnit;
            if (!(unit instanceof Vehicle) || (vehicleUnit = (Vehicle)unit).isSalvaged()) continue;
            vehicles.add(vehicleUnit);
        }
        return vehicles;
    }

    public static synchronized void mergeVehicles(Collection<Unit> units, Collection<Vehicle> vehicles) {
        for (Vehicle vehicleUnit : vehicles) {
            if (units.contains(vehicleUnit)) continue;
            units.add(vehicleUnit);
        }
    }

    public static synchronized Collection<Person> getPerson(Collection<Unit> units) {
        ConcurrentLinkedQueue<Person> persons = new ConcurrentLinkedQueue<Person>();
        for (Unit unit : units) {
            if (!(unit instanceof Person)) continue;
            persons.add((Person)unit);
        }
        return persons;
    }

    public static synchronized void mergePersons(Collection<Unit> units, Collection<Person> persons) {
        for (Person personUnit : persons) {
            if (units.contains(personUnit)) continue;
            units.add(personUnit);
        }
    }

    public static synchronized Collection<Settlement> getSettlement(Collection<Unit> units) {
        ConcurrentLinkedQueue<Settlement> settlements = new ConcurrentLinkedQueue<Settlement>();
        for (Unit unit : units) {
            if (!(unit instanceof Settlement)) continue;
            settlements.add((Settlement)unit);
        }
        return settlements;
    }

    public static synchronized void mergeSettlements(Collection<Unit> units, Collection<Settlement> settlements) {
        for (Settlement settlementUnit : settlements) {
            if (units.contains(settlementUnit)) continue;
            units.add(settlementUnit);
        }
    }

    public static synchronized Settlement getRandomSettlement(Collection<Settlement> collection) {
        Object[] array = collection.toArray();
        int r = RandomUtil.getRandomInt(collection.size() - 1);
        return (Settlement)array[r];
    }

    public static synchronized Settlement getRandomRegressionSettlement(Collection<Settlement> collection) {
        Settlement result = null;
        int size = collection.size();
        if (size > 0) {
            Object[] array = collection.toArray();
            int chosenSettlementNum = RandomUtil.getRandomRegressionInteger(size);
            result = (Settlement)array[chosenSettlementNum - 1];
        }
        return result;
    }

    public static synchronized Settlement getSettlement(Collection<Settlement> collection, String name) {
        Iterator<Settlement> i = collection.iterator();
        Settlement result = null;
        while (i.hasNext()) {
            Settlement settlement = i.next();
            if (!name.equals(settlement.getName())) continue;
            result = settlement;
        }
        return result;
    }

    public static synchronized <T extends Unit> Collection<T> sortByName(Collection<T> collection) {
        ConcurrentLinkedQueue<Unit> sorted = new ConcurrentLinkedQueue<Unit>();
        Iterator<T> outer = collection.iterator();
        while (outer.hasNext()) {
            outer.next();
            String leastName = "ZZZZZZZZZZZZZZZZZZZ";
            Unit leastUnit = null;
            for (Unit tempUnit : collection) {
                String name = tempUnit.getName();
                if (name.compareToIgnoreCase(leastName) >= 0 || sorted.contains(tempUnit)) continue;
                leastName = name;
                leastUnit = tempUnit;
            }
            sorted.add(leastUnit);
        }
        return sorted;
    }

    public static synchronized <T extends Unit> Collection<T> sortByProximity(Collection<T> collection, Coordinates location) {
        ConcurrentLinkedQueue<Unit> sorted = new ConcurrentLinkedQueue<Unit>();
        Iterator<T> outer = collection.iterator();
        while (outer.hasNext()) {
            outer.next();
            double closestDistance = Double.MAX_VALUE;
            Unit closestUnit = null;
            for (Unit tempUnit : collection) {
                double distance = location.getDistance(tempUnit.getCoordinates());
                if (!(distance < closestDistance) || sorted.contains(tempUnit)) continue;
                closestDistance = distance;
                closestUnit = tempUnit;
            }
            sorted.add(closestUnit);
        }
        return sorted;
    }
}

