/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.RandomUtil;

public class Coordinates
implements Serializable {
    private static Logger logger = Logger.getLogger(Coordinates.class.getName());
    private double phi;
    private double theta;
    private double sinPhi;
    private double sinTheta;
    private double cosPhi;
    private double cosTheta;

    public Coordinates(double phi, double theta) {
        this.setPhi(phi);
        this.setTheta(theta);
        this.setTrigFunctions();
    }

    public Coordinates(Coordinates originalCoordinates) {
        this(originalCoordinates.phi, originalCoordinates.theta);
    }

    public Coordinates(String latitude, String longitude) {
        this(Coordinates.parseLatitude(latitude), Coordinates.parseLongitude(longitude));
    }

    private void setTrigFunctions() {
        this.sinPhi = Math.sin(this.phi);
        this.sinTheta = Math.sin(this.theta);
        this.cosPhi = Math.cos(this.phi);
        this.cosTheta = Math.cos(this.theta);
    }

    public String toString() {
        return this.getFormattedString();
    }

    public double getPhi() {
        return this.phi;
    }

    public void setPhi(double newPhi) {
        this.phi = newPhi <= 0.0 ? 0.0 : (newPhi > Math.PI ? Math.PI : newPhi);
        this.setTrigFunctions();
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double newTheta) {
        this.theta = newTheta;
        while (this.theta < 0.0) {
            this.theta += Math.PI * 2;
        }
        while (this.theta > Math.PI * 2) {
            this.theta -= Math.PI * 2;
        }
        this.setTrigFunctions();
    }

    public double getSinPhi() {
        return this.sinPhi;
    }

    public double getSinTheta() {
        return this.sinTheta;
    }

    public double getCosPhi() {
        return this.cosPhi;
    }

    public double getCosTheta() {
        return this.cosTheta;
    }

    public void setCoords(Coordinates newCoordinates) {
        this.setPhi(newCoordinates.phi);
        this.setTheta(newCoordinates.theta);
        this.setTrigFunctions();
    }

    public boolean equals(Object otherCoords) {
        if (otherCoords != null && otherCoords instanceof Coordinates) {
            Coordinates other = (Coordinates)otherCoords;
            if (this.phi == other.phi && this.theta == other.theta) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.phi * 1000.0 + this.theta * 1000.0);
    }

    public double getAngle(Coordinates otherCoords) {
        return this.getAngleVincenty(otherCoords);
    }

    public double getAngleSLC(Coordinates otherCoords) {
        double temp3;
        double phi1 = -1.0 * (this.phi - 1.5707963267948966);
        double phi2 = -1.0 * (otherCoords.phi - 1.5707963267948966);
        double diffTheta = Math.abs(this.theta - otherCoords.theta);
        double temp1 = Math.cos(phi1) * Math.cos(phi2);
        double temp2 = Math.sin(phi1) * Math.sin(phi2);
        double temp4 = temp2 + temp1 * (temp3 = Math.cos(diffTheta));
        if (temp4 > 1.0) {
            temp4 = 1.0;
        } else if (temp4 < -1.0) {
            temp4 = -1.0;
        }
        double result = Math.acos(temp4);
        return result;
    }

    public double getAngleHaversine(Coordinates otherCoords) {
        double phi1 = -1.0 * (this.phi - 1.5707963267948966);
        double phi2 = -1.0 * (otherCoords.phi - 1.5707963267948966);
        double diffPhi = Math.abs(phi1 - phi2);
        double diffTheta = Math.abs(this.theta - otherCoords.theta);
        double temp1 = Math.pow(Math.sin(diffPhi / 2.0), 2.0);
        double temp2 = Math.cos(phi1) * Math.cos(phi2) * Math.pow(Math.sin(diffTheta / 2.0), 2.0);
        double temp3 = Math.sqrt(temp1 + temp2);
        double result = 2.0 * Math.asin(temp3);
        return result;
    }

    public double getAngleVincenty(Coordinates otherCoords) {
        double phi1 = -1.0 * (this.phi - 1.5707963267948966);
        double phi2 = -1.0 * (otherCoords.phi - 1.5707963267948966);
        double diffTheta = Math.abs(this.theta - otherCoords.theta);
        double temp1 = Math.pow(Math.cos(phi2) * Math.sin(diffTheta), 2.0);
        double temp2 = Math.cos(phi1) * Math.sin(phi2);
        double temp3 = Math.sin(phi1) * Math.cos(phi2) * Math.cos(diffTheta);
        double temp4 = Math.pow(temp2 - temp3, 2.0);
        double temp5 = Math.sqrt(temp1 + temp4);
        double temp6 = Math.sin(phi1) * Math.sin(phi2);
        double temp7 = Math.cos(phi1) * Math.cos(phi2) * Math.cos(diffTheta);
        double temp8 = temp6 + temp7;
        double result = Math.atan2(temp5, temp8);
        return result;
    }

    public double getDistance(Coordinates otherCoords) {
        double rho = 3393.0;
        double angle = this.getAngle(otherCoords);
        double result = rho * angle;
        return result;
    }

    public String getFormattedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getFormattedLatitudeString());
        buffer.append(' ');
        buffer.append(this.getFormattedLongitudeString());
        return buffer.toString();
    }

    public String getFormattedLongitudeString() {
        return Coordinates.getFormattedLongitudeString(this.theta);
    }

    public static String getFormattedLongitudeString(double theta) {
        double degrees = 0.0;
        char direction = ' ';
        if (theta < Math.PI && theta >= 0.0) {
            degrees = Math.toDegrees(theta);
            direction = 'E';
        } else if (theta >= Math.PI) {
            degrees = Math.toDegrees(Math.PI * 2 - theta);
            direction = 'W';
        }
        DecimalFormat formatter = new DecimalFormat("0.0");
        return formatter.format(degrees) + "\u00ba " + direction;
    }

    public String getFormattedLatitudeString() {
        return Coordinates.getFormattedLatitudeString(this.phi);
    }

    public static String getFormattedLatitudeString(double phi) {
        double piHalf = 1.5707963267948966;
        double degrees = 0.0;
        char direction = ' ';
        if (phi <= piHalf) {
            degrees = (piHalf - phi) / piHalf * 90.0;
            direction = 'N';
        } else if (phi > piHalf) {
            degrees = (phi - piHalf) / piHalf * 90.0;
            direction = 'S';
        }
        DecimalFormat formatter = new DecimalFormat("0.0");
        return formatter.format(degrees) + "\u00ba " + direction;
    }

    public static IntPoint findRectPosition(Coordinates newCoords, Coordinates centerCoords, double rho, int half_map, int low_edge) {
        return centerCoords.findRectPosition(newCoords.phi, newCoords.theta, rho, half_map, low_edge);
    }

    public IntPoint findRectPosition(double newPhi, double newTheta, double rho, int half_map, int low_edge) {
        double temp_col = newTheta + (-1.5707963267948966 - this.theta);
        double temp_buff_x = rho * Math.sin(newPhi);
        int buff_x = (int)Math.round(temp_buff_x * Math.cos(temp_col)) + half_map - low_edge;
        int buff_y = (int)Math.round(temp_buff_x * (0.0 - this.cosPhi) * Math.sin(temp_col) + rho * Math.cos(newPhi) * (0.0 - this.sinPhi)) + half_map - low_edge;
        return new IntPoint(buff_x, buff_y);
    }

    public Coordinates convertRectToSpherical(double x, double y) {
        return this.convertRectToSpherical(x, y, 3393.0);
    }

    public Coordinates convertRectToSpherical(double x, double y, double rho) {
        Coordinates result = new Coordinates(0.0, 0.0);
        this.convertRectToSpherical(x, y, rho, result);
        return result;
    }

    public void convertRectToSpherical(double x, double y, double rho, Coordinates newCoordinates) {
        double z = Math.sqrt(rho * rho - x * x - y * y);
        double x2 = x;
        double y2 = y * this.cosPhi + z * this.sinPhi;
        double z2 = z * this.cosPhi - y * this.sinPhi;
        double x3 = x2 * this.cosTheta + y2 * this.sinTheta;
        double y3 = y2 * this.cosTheta - x2 * this.sinTheta;
        double z3 = z2;
        double phi_new = Math.acos(z3 / rho);
        double theta_new = Math.asin(x3 / (rho * Math.sin(phi_new)));
        if (x3 >= 0.0) {
            if (y3 < 0.0) {
                theta_new = Math.PI - theta_new;
            }
        } else {
            theta_new = y3 < 0.0 ? Math.PI - theta_new : Math.PI * 2 + theta_new;
        }
        newCoordinates.setPhi(phi_new);
        newCoordinates.setTheta(theta_new);
    }

    public Direction getDirectionToPoint(Coordinates otherCoords) {
        double phi1 = -1.0 * (this.phi - 1.5707963267948966);
        double phi2 = -1.0 * (otherCoords.phi - 1.5707963267948966);
        double thetaDiff = otherCoords.theta - this.theta;
        double temp1 = Math.sin(thetaDiff) * Math.cos(phi2);
        double temp2 = Math.cos(phi1) * Math.sin(phi2);
        double temp3 = Math.sin(phi1) * Math.cos(phi2) * Math.cos(thetaDiff);
        double temp4 = temp2 - temp3;
        double result = Math.atan2(temp1, temp4);
        return new Direction(result);
    }

    public Coordinates getNewLocation(Direction direction, double distance) {
        double iterationDistance = 10.0;
        int iterations = (int)(distance / iterationDistance);
        double remainder = 0.0;
        remainder = distance > 10.0 ? distance - (double)iterations * iterationDistance : distance;
        Coordinates startCoords = this;
        for (int x = 0; x < iterations; ++x) {
            double newY = -1.0 * direction.getCosDirection() * iterationDistance;
            double newX = direction.getSinDirection() * iterationDistance;
            startCoords = startCoords.convertRectToSpherical(newX, newY);
        }
        double finalY = -1.0 * direction.getCosDirection() * remainder;
        double finalX = direction.getSinDirection() * remainder;
        Coordinates finalCoordinates = startCoords.convertRectToSpherical(finalX, finalY);
        return finalCoordinates;
    }

    public static double parseLatitude(String latitude) {
        double latValue = 0.0;
        String cleanLatitude = latitude.toUpperCase().trim();
        if (cleanLatitude.isEmpty()) {
            throw new IllegalStateException("Latitude is blank");
        }
        try {
            String numberString = cleanLatitude.substring(0, cleanLatitude.length() - 1).trim();
            if (numberString.endsWith("\u00ba")) {
                numberString = numberString.substring(0, numberString.length() - 1);
            }
            numberString = numberString.replace(',', '.');
            latValue = Double.parseDouble(numberString);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Latitude number invalid: " + latitude);
        }
        if (latValue > 90.0 || latValue < 0.0) {
            throw new IllegalStateException("Latitude value out of range: " + latValue);
        }
        char direction = cleanLatitude.charAt(latitude.length() - 1);
        if (direction == 'N') {
            latValue = 90.0 - latValue;
        } else if (direction == 'S') {
            latValue += 90.0;
        } else {
            throw new IllegalStateException("Latitude direction wrong: " + direction);
        }
        double phi = Math.PI * (latValue / 180.0);
        return phi;
    }

    public static double parseLongitude(String longitude) {
        double longValue = 0.0;
        String cleanLongitude = longitude.toUpperCase().trim();
        if (cleanLongitude.isEmpty()) {
            throw new IllegalStateException("Longitude is blank");
        }
        try {
            String numberString = cleanLongitude.substring(0, cleanLongitude.length() - 1).trim();
            if (numberString.endsWith("\u00ba")) {
                numberString = numberString.substring(0, numberString.length() - 1);
            }
            numberString = numberString.replace(',', '.');
            longValue = Double.parseDouble(numberString);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Longitude number invalid: " + longitude);
        }
        if (longValue > 180.0 || longValue < 0.0) {
            throw new IllegalStateException("Longitude value out of range: " + longValue);
        }
        char direction = cleanLongitude.charAt(cleanLongitude.length() - 1);
        if (direction == 'W') {
            longValue = 360.0 - longValue;
        } else if (direction != 'E') {
            throw new IllegalStateException("Longitude direction wrong: " + direction);
        }
        double theta = Math.PI * 2 * (longValue / 360.0);
        return theta;
    }

    public static double getRandomLatitude() {
        double phi = RandomUtil.getRandomDouble(1.5707963267948966) + RandomUtil.getRandomDouble(1.5707963267948966);
        return phi;
    }

    public static double getRandomLongitude() {
        double theta = Math.random() * (Math.PI * 2);
        return theta;
    }
}

