/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Container;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.AmountResourceStorage;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Phase;

public class Inventory
implements Serializable {
    public static final String INVENTORY_STORING_UNIT_EVENT = "inventory storing unit";
    public static final String INVENTORY_RETRIEVING_UNIT_EVENT = "inventory retrieving unit";
    public static final String INVENTORY_RESOURCE_EVENT = "inventory resource event";
    private static final double SMALL_AMOUNT_COMPARISON = 1.0E-7;
    private Unit owner;
    private Collection<Unit> containedUnits = null;
    private Map<ItemResource, Integer> containedItemResources = null;
    private double generalCapacity = 0.0;
    private AmountResourceStorage resourceStorage = null;
    private transient Map<AmountResource, Double> amountResourceCapacityCache = null;
    private transient Map<AmountResource, Boolean> amountResourceCapacityCacheDirty = null;
    private transient Map<AmountResource, Double> amountResourceStoredCache = null;
    private transient Map<AmountResource, Boolean> amountResourceStoredCacheDirty = null;
    private transient Set<AmountResource> allStoredAmountResourcesCache = null;
    private transient boolean allStoredAmountResourcesCacheDirty = true;
    private transient double totalAmountResourcesStoredCache;
    private transient boolean totalAmountResourcesStoredCacheDirty = true;
    private transient double itemResourceTotalMassCache;
    private transient boolean itemResourceTotalMassCacheDirty = true;
    private transient double unitTotalMassCache;
    private transient boolean unitTotalMassCacheDirty = true;
    private transient double totalInventoryMassCache;
    private transient boolean totalInventoryMassCacheDirty = true;

    public Inventory(Unit owner) {
        this.owner = owner;
    }

    public void addAmountResourceTypeCapacity(AmountResource resource, double capacity) {
        this.setAmountResourceCapacityCacheDirty(resource);
        if (this.resourceStorage == null) {
            this.resourceStorage = new AmountResourceStorage();
        }
        this.resourceStorage.addAmountResourceTypeCapacity(resource, capacity);
    }

    public void removeAmountResourceTypeCapacity(AmountResource resource, double capacity) {
        this.setAmountResourceCapacityCacheDirty(resource);
        if (this.resourceStorage == null) {
            this.resourceStorage = new AmountResourceStorage();
        }
        this.resourceStorage.removeAmountResourceTypeCapacity(resource, capacity);
    }

    public void addAmountResourcePhaseCapacity(Phase phase, double capacity) {
        this.setAmountResourceCapacityCacheAllDirty();
        if (this.resourceStorage == null) {
            this.resourceStorage = new AmountResourceStorage();
        }
        this.resourceStorage.addAmountResourcePhaseCapacity(phase, capacity);
    }

    public boolean hasAmountResourceCapacity(AmountResource resource, boolean allowDirty) {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null.");
        }
        return this.getAmountResourceCapacityCacheValue(resource, allowDirty) > 0.0;
    }

    public boolean hasAmountResourceCapacity(AmountResource resource, double amount, boolean allowDirty) {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null.");
        }
        if (amount < 0.0) {
            throw new IllegalArgumentException("amount cannot be a negative value.");
        }
        return this.getAmountResourceCapacityCacheValue(resource, allowDirty) >= amount;
    }

    public double getAmountResourceCapacity(AmountResource resource, boolean allowDirty) {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null.");
        }
        return this.getAmountResourceCapacityCacheValue(resource, allowDirty);
    }

    public double getAmountResourceStored(AmountResource resource, boolean allowDirty) {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        return this.getAmountResourceStoredCacheValue(resource, allowDirty);
    }

    public Set<AmountResource> getAllAmountResourcesStored(boolean allowDirty) {
        return new HashSet<AmountResource>(this.getAllStoredAmountResourcesCache(allowDirty));
    }

    private double getTotalAmountResourcesStored(boolean allowDirty) {
        return this.getTotalAmountResourcesStoredCache(allowDirty);
    }

    public double getAmountResourceRemainingCapacity(AmountResource resource, boolean useContainedUnits, boolean allowDirty) {
        double result = 0.0;
        if (useContainedUnits) {
            double capacity = this.getAmountResourceCapacity(resource, allowDirty);
            double stored = this.getAmountResourceStored(resource, allowDirty);
            result += capacity - stored;
        } else if (this.resourceStorage != null) {
            result += this.resourceStorage.getAmountResourceRemainingCapacity(resource);
        }
        double containerUnitLimit = this.getContainerUnitGeneralCapacityLimit(allowDirty);
        if (result > containerUnitLimit) {
            result = containerUnitLimit;
        }
        return result;
    }

    public void storeAmountResource(AmountResource resource, double amount, boolean useContainedUnits) {
        if (amount < 0.0) {
            throw new IllegalStateException("Cannot store negative amount of resource: " + amount);
        }
        if (amount > 0.0) {
            if (amount <= this.getAmountResourceRemainingCapacity(resource, useContainedUnits, false)) {
                this.setAmountResourceCapacityCacheAllDirty();
                this.setAmountResourceStoredCacheAllDirty();
                this.setAllStoredAmountResourcesCacheDirty();
                this.setTotalAmountResourcesStoredCacheDirty();
                double remainingAmount = amount;
                double remainingStorageCapacity = 0.0;
                if (this.resourceStorage != null) {
                    remainingStorageCapacity += this.resourceStorage.getAmountResourceRemainingCapacity(resource);
                }
                if (!useContainedUnits && remainingAmount > remainingStorageCapacity) {
                    throw new IllegalStateException(resource.getName() + " could not be totally stored. Remaining: " + (remainingAmount - remainingStorageCapacity));
                }
                double storageAmount = remainingAmount;
                if (storageAmount > remainingStorageCapacity) {
                    storageAmount = remainingStorageCapacity;
                }
                if (storageAmount > 0.0 && this.resourceStorage != null) {
                    this.resourceStorage.storeAmountResource(resource, storageAmount);
                    remainingAmount -= storageAmount;
                }
                if (useContainedUnits && remainingAmount > 0.0 && this.containedUnits != null) {
                    for (Unit unit : this.containedUnits) {
                        if (!(unit instanceof Container)) continue;
                        double unitStorageAmount = remainingAmount;
                        Inventory unitInventory = unit.getInventory();
                        double remainingUnitCapacity = unitInventory.getAmountResourceRemainingCapacity(resource, true, false);
                        if (unitStorageAmount > remainingUnitCapacity) {
                            unitStorageAmount = remainingUnitCapacity;
                        }
                        if (!(unitStorageAmount > 0.0)) continue;
                        unitInventory.storeAmountResource(resource, unitStorageAmount, true);
                        remainingAmount -= unitStorageAmount;
                    }
                }
                if (remainingAmount > 1.0E-7) {
                    throw new IllegalStateException(resource.getName() + " could not be totally stored. Remaining: " + remainingAmount);
                }
                if (this.owner != null) {
                    this.owner.fireUnitUpdate(INVENTORY_RESOURCE_EVENT, resource);
                }
            } else {
                throw new IllegalStateException("Insufficiant capacity to store " + resource.getName() + ", capacity: " + this.getAmountResourceRemainingCapacity(resource, useContainedUnits, false) + ", attempted: " + amount);
            }
        }
    }

    public void retrieveAmountResource(AmountResource resource, double amount) {
        if (amount < 0.0) {
            throw new IllegalStateException("Cannot retrieve negative amount of resource: " + amount);
        }
        if (amount > 0.0) {
            if (amount <= this.getAmountResourceStored(resource, false)) {
                double retrieveAmount;
                this.setAmountResourceCapacityCacheAllDirty();
                this.setAmountResourceStoredCacheAllDirty();
                this.setAllStoredAmountResourcesCacheDirty();
                this.setTotalAmountResourcesStoredCacheDirty();
                double remainingAmount = amount;
                double resourceStored = 0.0;
                if (this.resourceStorage != null) {
                    resourceStored += this.resourceStorage.getAmountResourceStored(resource);
                }
                if ((retrieveAmount = remainingAmount) > resourceStored) {
                    retrieveAmount = resourceStored;
                }
                if (retrieveAmount > 0.0 && this.resourceStorage != null) {
                    this.resourceStorage.retrieveAmountResource(resource, retrieveAmount);
                    remainingAmount -= retrieveAmount;
                }
                if (remainingAmount > 0.0 && this.containedUnits != null) {
                    for (Unit unit : this.containedUnits) {
                        if (!(unit instanceof Container)) continue;
                        double unitRetrieveAmount = remainingAmount;
                        Inventory unitInventory = unit.getInventory();
                        double unitResourceStored = unitInventory.getAmountResourceStored(resource, false);
                        if (unitRetrieveAmount > unitResourceStored) {
                            unitRetrieveAmount = unitResourceStored;
                        }
                        if (!(unitRetrieveAmount > 0.0)) continue;
                        unitInventory.retrieveAmountResource(resource, unitRetrieveAmount);
                        remainingAmount -= unitRetrieveAmount;
                    }
                }
                if (remainingAmount > 1.0E-7) {
                    throw new IllegalStateException(resource.getName() + " could not be totally retrieved. Remaining: " + remainingAmount);
                }
                this.updateAmountResourceCapacityCache(resource);
                this.updateAmountResourceStoredCache(resource);
                if (this.owner != null) {
                    this.owner.fireUnitUpdate(INVENTORY_RESOURCE_EVENT, resource);
                }
            } else {
                throw new IllegalStateException("Insufficiant stored amount to retrieve " + resource.getName() + ", stored: " + this.getAmountResourceStored(resource, false) + ", attempted: " + amount);
            }
        }
    }

    public void addGeneralCapacity(double capacity) {
        this.generalCapacity += capacity;
        this.setAmountResourceCapacityCacheAllDirty();
    }

    public double getGeneralCapacity() {
        return this.generalCapacity;
    }

    public double getGeneralStoredMass(boolean allowDirty) {
        return this.getItemResourceTotalMass(allowDirty) + this.getUnitTotalMass(allowDirty);
    }

    public double getRemainingGeneralCapacity(boolean allowDirty) {
        double containerUnitGeneralCapacityLimit;
        double result = this.generalCapacity - this.getGeneralStoredMass(allowDirty);
        if (result > (containerUnitGeneralCapacityLimit = this.getContainerUnitGeneralCapacityLimit(allowDirty))) {
            result = containerUnitGeneralCapacityLimit;
        }
        return result;
    }

    public boolean hasItemResource(ItemResource resource) {
        boolean result = false;
        if (this.containedItemResources != null && this.containedItemResources.containsKey(resource)) {
            if (this.containedItemResources.get(resource) > 0) {
                result = true;
            }
        } else if (this.containedUnits != null) {
            Iterator<Unit> i = this.containedUnits.iterator();
            while (i.hasNext()) {
                if (!i.next().getInventory().hasItemResource(resource)) continue;
                result = true;
            }
        }
        return result;
    }

    public int getItemResourceNum(ItemResource resource) {
        int result = 0;
        if (this.containedItemResources != null && this.containedItemResources.containsKey(resource)) {
            result += this.containedItemResources.get(resource).intValue();
        }
        return result;
    }

    public Set<ItemResource> getAllItemResourcesStored() {
        HashSet<ItemResource> result = null;
        result = this.containedItemResources != null ? new HashSet<ItemResource>(this.containedItemResources.keySet()) : new HashSet<ItemResource>(0);
        return result;
    }

    private double getItemResourceTotalMass(boolean allowDirty) {
        return this.getItemResourceTotalMassCache(allowDirty);
    }

    public void storeItemResources(ItemResource resource, int number) {
        if (number < 0) {
            throw new IllegalStateException("Cannot store negative number of resources.");
        }
        double totalMass = resource.getMassPerItem() * (double)number;
        if (number > 0) {
            if (totalMass <= this.getRemainingGeneralCapacity(false)) {
                int totalNum;
                this.setAmountResourceCapacityCacheAllDirty();
                this.setItemResourceTotalMassCacheDirty();
                if (this.containedItemResources == null) {
                    this.containedItemResources = new ConcurrentHashMap<ItemResource, Integer>();
                }
                if ((totalNum = number + this.getItemResourceNum(resource)) > 0) {
                    this.containedItemResources.put(resource, totalNum);
                }
                if (this.owner != null) {
                    this.owner.fireUnitUpdate(INVENTORY_RESOURCE_EVENT, resource);
                }
            } else {
                throw new IllegalStateException("Could not store item resources.");
            }
        }
    }

    public void retrieveItemResources(ItemResource resource, int number) {
        if (number < 0) {
            throw new IllegalStateException("Cannot retrieve negative number of resources.");
        }
        if (number > 0) {
            if (number <= this.getItemResourceNum(resource)) {
                int remainingNum = number;
                this.setAmountResourceCapacityCacheAllDirty();
                this.setItemResourceTotalMassCacheDirty();
                if (this.containedItemResources != null && this.containedItemResources.containsKey(resource)) {
                    int remainingLocal;
                    int retrieveNum = remainingNum;
                    int storedLocal = this.containedItemResources.get(resource);
                    if (retrieveNum > storedLocal) {
                        retrieveNum = storedLocal;
                    }
                    if ((remainingLocal = storedLocal - retrieveNum) > 0) {
                        this.containedItemResources.put(resource, remainingLocal);
                    } else {
                        this.containedItemResources.remove(resource);
                    }
                    remainingNum -= retrieveNum;
                }
                if (this.owner != null) {
                    this.owner.fireUnitUpdate(INVENTORY_RESOURCE_EVENT, resource);
                }
                if (remainingNum > 0) {
                    throw new IllegalStateException(resource.getName() + " could not be totally retrieved. Remaining: " + remainingNum);
                }
            } else {
                throw new IllegalStateException("Insufficiant stored number to retrieve " + resource.getName() + ", stored: " + this.getItemResourceNum(resource) + ", attempted: " + number);
            }
        }
    }

    public double getUnitTotalMass(boolean allowDirty) {
        return this.getUnitTotalMassCache(allowDirty);
    }

    public Collection<Unit> getContainedUnits() {
        ArrayList<Unit> result = null;
        result = this.containedUnits != null ? new ArrayList<Unit>(this.containedUnits) : new ArrayList(0);
        return result;
    }

    public boolean containsUnit(Unit unit) {
        boolean result = false;
        if (this.containedUnits != null) {
            result = this.containedUnits.contains(unit);
        }
        return result;
    }

    private boolean containsUnitClassLocal(Class<? extends Unit> unitClass) {
        boolean result = false;
        if (this.containedUnits != null) {
            Iterator<Unit> i = this.containedUnits.iterator();
            while (i.hasNext()) {
                if (!unitClass.isInstance(i.next())) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean containsUnitClass(Class<? extends Unit> unitClass) {
        boolean result = false;
        if (this.containsUnitClassLocal(unitClass)) {
            result = true;
        }
        return result;
    }

    public Unit findUnitOfClass(Class<? extends Unit> unitClass) {
        Unit result = null;
        if (this.containsUnitClass(unitClass)) {
            for (Unit unit : this.containedUnits) {
                if (!unitClass.isInstance(unit)) continue;
                result = unit;
                break;
            }
        }
        return result;
    }

    public Collection<Unit> findAllUnitsOfClass(Class<? extends Unit> unitClass) {
        ConcurrentLinkedQueue<Unit> result = new ConcurrentLinkedQueue<Unit>();
        if (this.containsUnitClass(unitClass)) {
            for (Unit unit : this.containedUnits) {
                if (!unitClass.isInstance(unit)) continue;
                result.add(unit);
            }
        }
        return result;
    }

    public int findNumUnitsOfClass(Class<? extends Unit> unitClass) {
        int result = 0;
        if (this.containsUnitClass(unitClass)) {
            for (Unit unit : this.containedUnits) {
                if (!unitClass.isInstance(unit)) continue;
                ++result;
            }
        }
        return result;
    }

    public int findNumEmptyUnitsOfClass(Class<? extends Unit> unitClass, boolean allowDirty) {
        int result = 0;
        if (this.containsUnitClass(unitClass)) {
            for (Unit unit : this.containedUnits) {
                Inventory inv;
                if (!unitClass.isInstance(unit) || (inv = unit.getInventory()) == null || !inv.isEmpty(allowDirty)) continue;
                ++result;
            }
        }
        return result;
    }

    public boolean canStoreUnit(Unit unit, boolean allowDirty) {
        boolean result = false;
        if (unit != null) {
            if (unit.getMass() <= this.getRemainingGeneralCapacity(allowDirty)) {
                result = true;
            }
            if (unit == this.owner) {
                result = false;
            }
            if (this.containsUnit(unit)) {
                result = false;
            }
            if (unit.getInventory().containsUnit(this.owner)) {
                result = false;
            }
        }
        return result;
    }

    public void storeUnit(Unit unit) {
        if (this.canStoreUnit(unit, false)) {
            this.setAmountResourceCapacityCacheAllDirty();
            this.setAmountResourceStoredCacheAllDirty();
            this.setAllStoredAmountResourcesCacheDirty();
            this.setTotalAmountResourcesStoredCacheDirty();
            this.setUnitTotalMassCacheDirty();
            if (this.containedUnits == null) {
                this.containedUnits = new ConcurrentLinkedQueue<Unit>();
            }
            this.containedUnits.add(unit);
            unit.setContainerUnit(this.owner);
            if (unit instanceof Container) {
                Inventory containerInv = unit.getInventory();
                for (AmountResource resource : containerInv.getAllAmountResourcesStored(false)) {
                    double containerAmount = containerInv.getAmountResourceStored(resource, false);
                    if (!(this.getAmountResourceRemainingCapacity(resource, false, false) >= containerAmount)) continue;
                    containerInv.retrieveAmountResource(resource, containerAmount);
                    this.storeAmountResource(resource, containerAmount, false);
                }
            }
            if (this.owner != null) {
                unit.setCoordinates(this.owner.getCoordinates());
                this.owner.fireUnitUpdate(INVENTORY_STORING_UNIT_EVENT, unit);
                for (AmountResource resource : unit.getInventory().getAllAmountResourcesStored(false)) {
                    this.updateAmountResourceCapacityCache(resource);
                    this.updateAmountResourceStoredCache(resource);
                    this.owner.fireUnitUpdate(INVENTORY_RESOURCE_EVENT, resource);
                }
                Iterator<ItemResource> j = unit.getInventory().getAllItemResourcesStored().iterator();
                while (j.hasNext()) {
                    this.owner.fireUnitUpdate(INVENTORY_RESOURCE_EVENT, j.next());
                }
            }
        } else {
            throw new IllegalStateException("Unit: " + unit + " could not be stored.");
        }
    }

    public void retrieveUnit(Unit unit) {
        boolean retrieved = false;
        if (this.containsUnit(unit)) {
            this.setAmountResourceCapacityCacheAllDirty();
            this.setAmountResourceStoredCacheAllDirty();
            this.setAllStoredAmountResourcesCacheDirty();
            this.setTotalAmountResourcesStoredCacheDirty();
            this.setUnitTotalMassCacheDirty();
            if (this.containedUnits.contains(unit)) {
                this.containedUnits.remove(unit);
                if (this.owner != null) {
                    this.owner.fireUnitUpdate(INVENTORY_RETRIEVING_UNIT_EVENT, unit);
                    for (AmountResource resource : unit.getInventory().getAllAmountResourcesStored(false)) {
                        this.updateAmountResourceCapacityCache(resource);
                        this.updateAmountResourceStoredCache(resource);
                        this.owner.fireUnitUpdate(INVENTORY_RESOURCE_EVENT, resource);
                    }
                    Iterator<ItemResource> j = unit.getInventory().getAllItemResourcesStored().iterator();
                    while (j.hasNext()) {
                        this.owner.fireUnitUpdate(INVENTORY_RESOURCE_EVENT, j.next());
                    }
                }
                retrieved = true;
            }
        }
        if (!retrieved) {
            throw new IllegalStateException("Unit: " + unit + " could not be retrived.");
        }
        unit.setContainerUnit(null);
    }

    public void setCoordinates(Coordinates newLocation) {
        if (this.containedUnits != null) {
            Iterator<Unit> i = this.containedUnits.iterator();
            while (i.hasNext()) {
                i.next().setCoordinates(newLocation);
            }
        }
    }

    public double getTotalInventoryMass(boolean allowDirty) {
        return this.getTotalInventoryMassCache(allowDirty);
    }

    public boolean isEmpty(boolean allowDirty) {
        return this.getTotalInventoryMass(allowDirty) == 0.0;
    }

    private double getContainerUnitGeneralCapacityLimit(boolean allowDirty) {
        double result = Double.MAX_VALUE;
        if (this.owner != null && this.owner.getContainerUnit() != null) {
            Inventory containerInv = this.owner.getContainerUnit().getInventory();
            if (containerInv.getRemainingGeneralCapacity(allowDirty) < result) {
                result = containerInv.getRemainingGeneralCapacity(allowDirty);
            }
            if (containerInv.getContainerUnitGeneralCapacityLimit(allowDirty) < result) {
                result = containerInv.getContainerUnitGeneralCapacityLimit(allowDirty);
            }
        }
        return result;
    }

    private synchronized void initializeAmountResourceCapacityCache() {
        Set<AmountResource> resources = AmountResource.getAmountResources();
        this.amountResourceCapacityCache = new HashMap<AmountResource, Double>(resources.size());
        this.amountResourceCapacityCacheDirty = new HashMap<AmountResource, Boolean>(resources.size());
        for (AmountResource resource : resources) {
            this.amountResourceCapacityCache.put(resource, 0.0);
            this.amountResourceCapacityCacheDirty.put(resource, true);
        }
    }

    private boolean isAmountResourceCapacityCacheDirty(AmountResource resource) {
        if (this.amountResourceCapacityCache == null) {
            this.initializeAmountResourceCapacityCache();
        }
        return this.amountResourceCapacityCacheDirty.get(resource);
    }

    private void setAmountResourceCapacityCacheDirty(AmountResource resource) {
        if (this.amountResourceCapacityCache == null) {
            this.initializeAmountResourceCapacityCache();
        }
        this.amountResourceCapacityCacheDirty.put(resource, true);
    }

    private void setAmountResourceCapacityCacheAllDirty() {
        Unit container;
        if (this.amountResourceCapacityCache == null) {
            this.initializeAmountResourceCapacityCache();
        }
        Iterator<AmountResource> i = AmountResource.getAmountResources().iterator();
        while (i.hasNext()) {
            this.setAmountResourceCapacityCacheDirty(i.next());
        }
        if (this.owner != null && (container = this.owner.getContainerUnit()) != null) {
            container.getInventory().setAmountResourceCapacityCacheAllDirty();
        }
    }

    private double getAmountResourceCapacityCacheValue(AmountResource resource, boolean allowDirty) {
        if (this.amountResourceCapacityCache == null) {
            this.initializeAmountResourceCapacityCache();
        }
        if (this.isAmountResourceCapacityCacheDirty(resource) && !allowDirty) {
            this.updateAmountResourceCapacityCache(resource);
        }
        return this.amountResourceCapacityCache.get(resource);
    }

    private void updateAmountResourceCapacityCache(AmountResource resource) {
        double generalResourceCapacity;
        if (this.amountResourceCapacityCache == null) {
            this.initializeAmountResourceCapacityCache();
        }
        double capacity = 0.0;
        if (this.resourceStorage != null) {
            capacity += this.resourceStorage.getAmountResourceCapacity(resource);
        }
        double containedCapacity = 0.0;
        double containedStored = 0.0;
        if (this.containedUnits != null) {
            for (Unit unit : this.containedUnits) {
                if (!(unit instanceof Container)) continue;
                containedCapacity += unit.getInventory().getAmountResourceCapacity(resource, false);
                containedStored += unit.getInventory().getAmountResourceStored(resource, false);
            }
        }
        if (containedCapacity > (generalResourceCapacity = this.getRemainingGeneralCapacity(false) + containedStored)) {
            containedCapacity = generalResourceCapacity;
        }
        this.amountResourceCapacityCache.put(resource, capacity += containedCapacity);
        this.amountResourceCapacityCacheDirty.put(resource, false);
    }

    private synchronized void initializeAmountResourceStoredCache() {
        Set<AmountResource> resources = AmountResource.getAmountResources();
        this.amountResourceStoredCache = new HashMap<AmountResource, Double>(resources.size());
        this.amountResourceStoredCacheDirty = new HashMap<AmountResource, Boolean>(resources.size());
        for (AmountResource resource : resources) {
            this.amountResourceStoredCache.put(resource, 0.0);
            this.amountResourceStoredCacheDirty.put(resource, true);
        }
    }

    private boolean isAmountResourceStoredCacheDirty(AmountResource resource) {
        if (this.amountResourceStoredCache == null) {
            this.initializeAmountResourceStoredCache();
        }
        return this.amountResourceStoredCacheDirty.get(resource);
    }

    private void setAmountResourceStoredCacheDirty(AmountResource resource) {
        if (this.amountResourceStoredCache == null) {
            this.initializeAmountResourceStoredCache();
        }
        this.amountResourceStoredCacheDirty.put(resource, true);
    }

    private void setAmountResourceStoredCacheAllDirty() {
        Unit container;
        if (this.amountResourceStoredCache == null) {
            this.initializeAmountResourceStoredCache();
        }
        Iterator<AmountResource> i = AmountResource.getAmountResources().iterator();
        while (i.hasNext()) {
            this.setAmountResourceStoredCacheDirty(i.next());
        }
        if (this.owner != null && (container = this.owner.getContainerUnit()) != null) {
            container.getInventory().setAmountResourceStoredCacheAllDirty();
        }
    }

    private double getAmountResourceStoredCacheValue(AmountResource resource, boolean allowDirty) {
        if (this.amountResourceStoredCache == null) {
            this.initializeAmountResourceStoredCache();
        }
        if (this.isAmountResourceStoredCacheDirty(resource) && !allowDirty) {
            this.updateAmountResourceStoredCache(resource);
        }
        return this.amountResourceStoredCache.get(resource);
    }

    private void updateAmountResourceStoredCache(AmountResource resource) {
        double stored = 0.0;
        if (this.resourceStorage != null) {
            stored += this.resourceStorage.getAmountResourceStored(resource);
        }
        if (this.containedUnits != null) {
            for (Unit unit : this.containedUnits) {
                if (!(unit instanceof Container)) continue;
                stored += unit.getInventory().getAmountResourceStored(resource, false);
            }
        }
        this.amountResourceStoredCache.put(resource, stored);
        this.amountResourceStoredCacheDirty.put(resource, false);
    }

    private synchronized void initializeAllStoredAmountResourcesCache() {
        this.allStoredAmountResourcesCache = new HashSet<AmountResource>();
        this.allStoredAmountResourcesCacheDirty = true;
    }

    private void setAllStoredAmountResourcesCacheDirty() {
        Unit container;
        if (this.allStoredAmountResourcesCache == null) {
            this.initializeAllStoredAmountResourcesCache();
        }
        this.allStoredAmountResourcesCacheDirty = true;
        if (this.owner != null && (container = this.owner.getContainerUnit()) != null) {
            container.getInventory().setAllStoredAmountResourcesCacheDirty();
        }
    }

    private Set<AmountResource> getAllStoredAmountResourcesCache(boolean allowDirty) {
        if (this.allStoredAmountResourcesCache == null) {
            this.initializeAllStoredAmountResourcesCache();
        }
        if (this.allStoredAmountResourcesCacheDirty && !allowDirty) {
            this.updateAllStoredAmountResourcesCache();
        }
        return this.allStoredAmountResourcesCache;
    }

    private void updateAllStoredAmountResourcesCache() {
        HashSet<AmountResource> tempAllStored = new HashSet<AmountResource>();
        if (this.resourceStorage != null) {
            tempAllStored.addAll(this.resourceStorage.getAllAmountResourcesStored(false));
        }
        if (this.containedUnits != null) {
            for (Unit unit : this.containedUnits) {
                if (!(unit instanceof Container)) continue;
                tempAllStored.addAll(unit.getInventory().getAllAmountResourcesStored(false));
            }
        }
        this.allStoredAmountResourcesCache = tempAllStored;
        this.allStoredAmountResourcesCacheDirty = false;
    }

    private void setTotalAmountResourcesStoredCacheDirty() {
        Unit container;
        this.totalAmountResourcesStoredCacheDirty = true;
        this.setTotalInventoryMassCacheDirty();
        if (this.owner != null && (container = this.owner.getContainerUnit()) != null) {
            container.getInventory().setTotalAmountResourcesStoredCacheDirty();
        }
    }

    private double getTotalAmountResourcesStoredCache(boolean allowDirty) {
        if (this.totalAmountResourcesStoredCacheDirty && !allowDirty) {
            this.updateTotalAmountResourcesStoredCache();
        }
        return this.totalAmountResourcesStoredCache;
    }

    private void updateTotalAmountResourcesStoredCache() {
        double tempStored = 0.0;
        if (this.resourceStorage != null) {
            tempStored += this.resourceStorage.getTotalAmountResourcesStored(false);
        }
        if (this.containedUnits != null) {
            for (Unit unit : this.containedUnits) {
                tempStored = unit.getInventory().getTotalAmountResourcesStored(false);
            }
        }
        this.totalAmountResourcesStoredCache = tempStored;
        this.totalAmountResourcesStoredCacheDirty = false;
    }

    private void setItemResourceTotalMassCacheDirty() {
        this.itemResourceTotalMassCacheDirty = true;
        this.setTotalInventoryMassCacheDirty();
    }

    private double getItemResourceTotalMassCache(boolean allowDirty) {
        if (this.itemResourceTotalMassCacheDirty && !allowDirty) {
            this.updateItemResourceTotalMassCache();
        }
        return this.itemResourceTotalMassCache;
    }

    private void updateItemResourceTotalMassCache() {
        double tempMass = 0.0;
        if (this.containedItemResources != null) {
            Set<Map.Entry<ItemResource, Integer>> es = this.containedItemResources.entrySet();
            for (Map.Entry<ItemResource, Integer> e : es) {
                tempMass += (double)e.getValue().intValue() * e.getKey().getMassPerItem();
            }
        }
        this.itemResourceTotalMassCache = tempMass;
        this.itemResourceTotalMassCacheDirty = false;
    }

    private void setUnitTotalMassCacheDirty() {
        this.unitTotalMassCacheDirty = true;
        this.setTotalInventoryMassCacheDirty();
    }

    private double getUnitTotalMassCache(boolean allowDirty) {
        if (this.unitTotalMassCacheDirty && !allowDirty) {
            this.updateUnitTotalMassCache();
        }
        return this.unitTotalMassCache;
    }

    private void updateUnitTotalMassCache() {
        double tempMass = 0.0;
        if (this.containedUnits != null) {
            Iterator<Unit> unitIt = this.containedUnits.iterator();
            while (unitIt.hasNext()) {
                tempMass += unitIt.next().getMass();
            }
        }
        this.unitTotalMassCache = tempMass;
        this.unitTotalMassCacheDirty = false;
    }

    private void setTotalInventoryMassCacheDirty() {
        Unit container;
        this.totalInventoryMassCacheDirty = true;
        if (this.owner != null && (container = this.owner.getContainerUnit()) != null) {
            container.getInventory().setUnitTotalMassCacheDirty();
        }
    }

    private double getTotalInventoryMassCache(boolean allowDirty) {
        if (this.totalInventoryMassCacheDirty && !allowDirty) {
            this.updateTotalInventoryMassCache();
        }
        return this.totalInventoryMassCache;
    }

    private void updateTotalInventoryMassCache() {
        double tempMass = 0.0;
        tempMass += this.getTotalAmountResourcesStored(false);
        this.totalInventoryMassCache = tempMass += this.getGeneralStoredMass(false);
        this.totalInventoryMassCacheDirty = false;
    }

    public Inventory clone(Unit owner) {
        Inventory result = new Inventory(owner);
        result.addGeneralCapacity(this.generalCapacity);
        if (this.resourceStorage != null) {
            Map<AmountResource, Double> typeCapacities = this.resourceStorage.getAmountResourceTypeCapacities();
            for (AmountResource type : typeCapacities.keySet()) {
                result.addAmountResourceTypeCapacity(type, typeCapacities.get(type));
            }
            Map<Phase, Double> phaseCapacities = this.resourceStorage.getAmountResourcePhaseCapacities();
            for (Phase phase : phaseCapacities.keySet()) {
                result.addAmountResourcePhaseCapacity(phase, phaseCapacities.get(phase));
            }
        }
        return result;
    }

    public void destroy() {
        this.owner = null;
        if (this.containedUnits != null) {
            this.containedUnits.clear();
        }
        this.containedUnits = null;
        if (this.containedItemResources != null) {
            this.containedItemResources.clear();
        }
        this.containedItemResources = null;
        if (this.resourceStorage != null) {
            this.resourceStorage.destroy();
        }
        this.resourceStorage = null;
        if (this.amountResourceCapacityCache != null) {
            this.amountResourceCapacityCache.clear();
        }
        this.amountResourceCapacityCache = null;
        if (this.amountResourceCapacityCacheDirty != null) {
            this.amountResourceCapacityCacheDirty.clear();
        }
        this.amountResourceCapacityCacheDirty = null;
        if (this.amountResourceStoredCache != null) {
            this.amountResourceStoredCache.clear();
        }
        if (this.amountResourceStoredCacheDirty != null) {
            this.amountResourceStoredCacheDirty.clear();
        }
        this.amountResourceStoredCacheDirty = null;
        this.amountResourceStoredCache = null;
        if (this.allStoredAmountResourcesCache != null) {
            this.allStoredAmountResourcesCache.clear();
        }
        this.allStoredAmountResourcesCache = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.allStoredAmountResourcesCacheDirty = true;
        this.totalAmountResourcesStoredCacheDirty = true;
        this.itemResourceTotalMassCacheDirty = true;
        this.unitTotalMassCacheDirty = true;
        this.totalInventoryMassCacheDirty = true;
    }
}

