/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.util.Iterator;
import java.util.Map;
import org.mars_sim.msp.core.MersenneTwisterFast;

public final class RandomUtil {
    private static final MersenneTwisterFast random = new MersenneTwisterFast();

    public static boolean lessThanRandPercent(int randomLimit) {
        int rand = random.nextInt(100) + 1;
        return rand < randomLimit;
    }

    public static boolean lessThanRandPercent(double randomLimit) {
        double rand = random.nextDouble() * 100.0;
        return rand < randomLimit;
    }

    public static int getRandomInt(int ceiling) {
        if (ceiling < 0) {
            throw new IllegalArgumentException("ceiling must be positive: " + ceiling);
        }
        return random.nextInt(ceiling + 1);
    }

    public static int getRandomInt(int base, int ceiling) {
        if (ceiling < base) {
            throw new IllegalArgumentException("ceiling must be greater than base.");
        }
        return random.nextInt(ceiling - base + 1) + base;
    }

    public static double getRandomDouble(double ceiling) {
        return random.nextDouble() * ceiling;
    }

    public static int getRandomRegressionInteger(int ceiling) {
        double totalWeight = 0.0;
        double weight = 1.0;
        for (int x = 0; x < ceiling; ++x) {
            totalWeight += weight;
            weight /= 2.0;
        }
        double randWeight = RandomUtil.getRandomDouble(totalWeight);
        totalWeight = 0.0;
        weight = 1.0;
        int result = 0;
        for (int x = 0; x < ceiling; ++x) {
            totalWeight += weight;
            weight /= 2.0;
            if (!(randWeight < totalWeight)) continue;
            result = x + 1;
            break;
        }
        return result;
    }

    public static double getRandomRegressionIntegerAverageValue(int ceiling) {
        double totalProbability = 0.0;
        double totalValue = 0.0;
        double probability = 1.0;
        for (int x = 0; x < ceiling; ++x) {
            totalValue += (double)(x + 1) * probability;
            totalProbability += probability;
            probability /= 2.0;
        }
        return totalValue / totalProbability;
    }

    public static <T> T getWeightedRandomObject(Map<T, Double> weightedMap) {
        if (weightedMap == null) {
            throw new IllegalArgumentException("weightedMap is null");
        }
        T result = null;
        double totalWeight = 0.0;
        Iterator<Double> i = weightedMap.values().iterator();
        while (i.hasNext()) {
            totalWeight += i.next().doubleValue();
        }
        double randWeight = RandomUtil.getRandomDouble(totalWeight);
        for (T key : weightedMap.keySet()) {
            double weight = weightedMap.get(key);
            if (randWeight <= weight) {
                result = key;
                break;
            }
            randWeight -= weight;
        }
        return result;
    }
}

