/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.events.HistoricalEventManager;
import org.mars_sim.msp.core.interplanetary.transport.TransportManager;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.person.medical.MedicalManager;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.core.structure.goods.CreditManager;
import org.mars_sim.msp.core.time.ClockListener;
import org.mars_sim.msp.core.time.MasterClock;
import org.mars_sim.msp.core.time.UpTimer;

public class Simulation
implements ClockListener,
Serializable {
    private static final long serialVersionUID = -631308653510974249L;
    private static Logger logger = Logger.getLogger(Simulation.class.getName());
    public static final String VERSION = "3.05";
    public static final String DEFAULT_FILE = "default.sim";
    public static final String DEFAULT_DIR = System.getProperty("user.home") + File.separator + ".mars-sim" + File.separator + "saved";
    private static final Simulation instance = new Simulation();
    private transient HistoricalEventManager eventManager;
    private transient Thread clockThread;
    private static final boolean debug = logger.isLoggable(Level.FINE);
    private Mars mars;
    private MalfunctionFactory malfunctionFactory;
    private UnitManager unitManager;
    private MissionManager missionManager;
    private RelationshipManager relationshipManager;
    private MedicalManager medicalManager;
    private MasterClock masterClock;
    private CreditManager creditManager;
    private ScientificStudyManager scientificStudyManager;
    private TransportManager transportManager;
    private boolean defaultLoad = false;
    private boolean initialSimulationCreated = false;

    private Simulation() {
        this.initializeTransientData();
    }

    public static Simulation instance() {
        return instance;
    }

    public static void stopSimulation() {
        Simulation simulation = Simulation.instance();
        simulation.defaultLoad = false;
        simulation.stop();
        Thread.yield();
    }

    public static void createNewSimulation() {
        logger.config("Creating new simulation");
        Simulation simulation = Simulation.instance();
        if (simulation.initialSimulationCreated) {
            simulation.destroyOldSimulation();
        }
        simulation.initializeIntransientData();
        simulation.initializeTransientData();
        simulation.initialSimulationCreated = true;
    }

    private void destroyOldSimulation() {
        this.malfunctionFactory.destroy();
        this.mars.destroy();
        this.missionManager.destroy();
        this.relationshipManager.destroy();
        this.medicalManager.destroy();
        this.masterClock.destroy();
        this.unitManager.destroy();
        this.creditManager.destroy();
        this.scientificStudyManager.destroy();
        this.relationshipManager.destroy();
        this.eventManager.destroy();
    }

    private void initializeTransientData() {
        this.eventManager = new HistoricalEventManager();
    }

    private void initializeIntransientData() {
        this.malfunctionFactory = new MalfunctionFactory(SimulationConfig.instance().getMalfunctionConfiguration());
        this.mars = new Mars();
        this.missionManager = new MissionManager();
        this.relationshipManager = new RelationshipManager();
        this.medicalManager = new MedicalManager();
        this.masterClock = new MasterClock();
        this.unitManager = new UnitManager();
        this.unitManager.constructInitialUnits();
        this.creditManager = new CreditManager();
        this.scientificStudyManager = new ScientificStudyManager();
        this.transportManager = new TransportManager();
    }

    public void loadSimulation(File file) {
        File f = file;
        logger.config("Loading simulation from " + file);
        Simulation simulation = Simulation.instance();
        simulation.stop();
        if (f == null) {
            f = new File(DEFAULT_DIR, DEFAULT_FILE);
            simulation.defaultLoad = true;
        } else {
            simulation.defaultLoad = false;
        }
        if (f.exists() && f.canRead()) {
            try {
                simulation.readFromFile(f);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            throw new IllegalStateException("Load file: " + f.getPath() + " is not accessible");
        }
    }

    private void readFromFile(File file) throws ClassNotFoundException, IOException {
        ObjectInputStream p = new ObjectInputStream(new FileInputStream(file));
        if (Simulation.instance().initialSimulationCreated) {
            this.destroyOldSimulation();
        }
        SimulationConfig.setInstance((SimulationConfig)p.readObject());
        this.malfunctionFactory = (MalfunctionFactory)p.readObject();
        this.mars = (Mars)p.readObject();
        this.mars.initializeTransientData();
        this.missionManager = (MissionManager)p.readObject();
        this.relationshipManager = (RelationshipManager)p.readObject();
        this.medicalManager = (MedicalManager)p.readObject();
        this.scientificStudyManager = (ScientificStudyManager)p.readObject();
        this.transportManager = (TransportManager)p.readObject();
        this.creditManager = (CreditManager)p.readObject();
        this.unitManager = (UnitManager)p.readObject();
        this.masterClock = (MasterClock)p.readObject();
        p.close();
        this.initializeTransientData();
    }

    public void saveSimulation(File file) throws IOException {
        logger.config("Saving simulation to " + file);
        Simulation simulation = Simulation.instance();
        simulation.stop();
        if (file == null && !(file = new File(DEFAULT_DIR, DEFAULT_FILE)).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        ObjectOutputStream p = null;
        try {
            p = new ObjectOutputStream(new FileOutputStream(file));
            p.writeObject(SimulationConfig.instance());
            p.writeObject(this.malfunctionFactory);
            p.writeObject(this.mars);
            p.writeObject(this.missionManager);
            p.writeObject(this.relationshipManager);
            p.writeObject(this.medicalManager);
            p.writeObject(this.scientificStudyManager);
            p.writeObject(this.transportManager);
            p.writeObject(this.creditManager);
            p.writeObject(this.unitManager);
            p.writeObject(this.masterClock);
            p.flush();
            p.close();
            p = null;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not save the simulation", e);
            throw e;
        }
        finally {
            if (p != null) {
                p.close();
            }
        }
        simulation.start();
    }

    public void start() {
        if (this.clockThread == null) {
            this.clockThread = new Thread((Runnable)this.masterClock, "Master Clock");
            this.masterClock.addClockListener(this);
            this.clockThread.start();
        }
    }

    public void stop() {
        if (this.masterClock != null) {
            this.masterClock.stop();
            this.masterClock.removeClockListener(this);
        }
        this.clockThread = null;
    }

    @Override
    public void clockPulse(double time) {
        UpTimer ut = this.masterClock.getUpTimer();
        ut.updateTime();
        if (debug) {
            logger.fine(ut.getUptime() + " Master clock sending pulse to object: mars " + this.mars.toString());
        }
        this.mars.timePassing(time);
        ut.updateTime();
        if (debug) {
            logger.fine(this.masterClock.getUpTimer().getUptime() + " Master clock sending pulse to object: missionManager " + this.missionManager.toString());
        }
        this.missionManager.timePassing(time);
        ut.updateTime();
        if (debug) {
            logger.fine(this.masterClock.getUpTimer().getUptime() + " Master clock sending pulse to object: unitManager " + this.unitManager.toString());
        }
        this.unitManager.timePassing(time);
        ut.updateTime();
        if (debug) {
            logger.fine(this.masterClock.getUpTimer().getUptime() + " Master clock sending pulse to object: scientificStudyManager " + this.scientificStudyManager);
        }
        this.scientificStudyManager.updateStudies();
        ut.updateTime();
        if (debug) {
            logger.fine(this.masterClock.getUpTimer().getUptime() + " Master clock sending pulse to object: transportManager " + this.transportManager);
        }
        this.transportManager.timePassing(time);
    }

    @Override
    public void pauseChange(boolean isPaused) {
    }

    public Mars getMars() {
        return this.mars;
    }

    public UnitManager getUnitManager() {
        return this.unitManager;
    }

    public MissionManager getMissionManager() {
        return this.missionManager;
    }

    public RelationshipManager getRelationshipManager() {
        return this.relationshipManager;
    }

    public CreditManager getCreditManager() {
        return this.creditManager;
    }

    public MalfunctionFactory getMalfunctionFactory() {
        return this.malfunctionFactory;
    }

    public HistoricalEventManager getEventManager() {
        return this.eventManager;
    }

    public MedicalManager getMedicalManager() {
        return this.medicalManager;
    }

    public ScientificStudyManager getScientificStudyManager() {
        return this.scientificStudyManager;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public MasterClock getMasterClock() {
        return this.masterClock;
    }

    public boolean isDefaultLoad() {
        return this.defaultLoad;
    }
}

