/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.mars_sim.msp.core.ClasspathEntityResolver;
import org.mars_sim.msp.core.interplanetary.transport.resupply.ResupplyConfig;
import org.mars_sim.msp.core.malfunction.MalfunctionConfig;
import org.mars_sim.msp.core.manufacture.ManufactureConfig;
import org.mars_sim.msp.core.mars.LandmarkConfig;
import org.mars_sim.msp.core.mars.MineralMapConfig;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.medical.MedicalConfig;
import org.mars_sim.msp.core.resource.AmountResourceConfig;
import org.mars_sim.msp.core.resource.PartConfig;
import org.mars_sim.msp.core.resource.PartPackageConfig;
import org.mars_sim.msp.core.structure.SettlementConfig;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.CropConfig;
import org.mars_sim.msp.core.structure.construction.ConstructionConfig;
import org.mars_sim.msp.core.vehicle.VehicleConfig;
import org.xml.sax.EntityResolver;

public class SimulationConfig
implements Serializable {
    private static final long serialVersionUID = 8571791274015892904L;
    private static final Logger logger = Logger.getLogger(SimulationConfig.class.getName());
    private static final String SIMULATION_FILE = "simulation";
    private static final String PEOPLE_FILE = "people";
    private static final String VEHICLE_FILE = "vehicles";
    private static final String SETTLEMENT_FILE = "settlements";
    private static final String RESUPPLY_FILE = "resupplies";
    private static final String MEDICAL_FILE = "medical";
    private static final String MALFUNCTION_FILE = "malfunctions";
    private static final String CROP_FILE = "crops";
    private static final String LANDMARK_FILE = "landmarks";
    private static final String MINERAL_MAP_FILE = "minerals";
    private static final String BUILDING_FILE = "buildings";
    private static final String PART_FILE = "parts";
    private static final String PART_PACKAGE_FILE = "part_packages";
    private static final String RESOURCE_FILE = "resources";
    private static final String MANUFACTURE_FILE = "manufacturing";
    private static final String CONSTRUCTION_FILE = "construction";
    private static final String VALUE = "value";
    private static final String TIME_CONFIGURATION = "time-configuration";
    private static final String TIME_RATIO = "time-ratio";
    private static final String EARTH_START_DATE_TIME = "earth-start-date-time";
    private static final String MARS_START_DATE_TIME = "mars-start-date-time";
    private static SimulationConfig instance = new SimulationConfig();
    private Document simulationDoc;
    private PartConfig partConfig;
    private PartPackageConfig partPackageConfig;
    private AmountResourceConfig resourceConfig;
    private PersonConfig personConfig;
    private MedicalConfig medicalConfig;
    private LandmarkConfig landmarkConfig;
    private MineralMapConfig mineralMapConfig;
    private MalfunctionConfig malfunctionConfig;
    private CropConfig cropConfig;
    private VehicleConfig vehicleConfig;
    private BuildingConfig buildingConfig;
    private SettlementConfig settlementConfig;
    private ManufactureConfig manufactureConfig;
    private ResupplyConfig resupplyConfig;
    private ConstructionConfig constructionConfig;

    private SimulationConfig() {
    }

    public static SimulationConfig instance() {
        return instance;
    }

    public static void setInstance(SimulationConfig instance) {
        SimulationConfig.instance = instance;
    }

    public static void loadConfig() {
        if (SimulationConfig.instance.simulationDoc != null) {
            instance.destroyOldConfiguration();
        }
        instance.loadDefaultConfiguration();
    }

    public double getSimulationTimeRatio() {
        Element root = this.simulationDoc.getRootElement();
        Element timeConfig = root.getChild(TIME_CONFIGURATION);
        Element timeRatio = timeConfig.getChild(TIME_RATIO);
        double ratio = Double.parseDouble(timeRatio.getAttributeValue(VALUE));
        if (ratio < 0.0) {
            throw new IllegalStateException("Simulation time ratio must be positive number.");
        }
        if (ratio == 0.0) {
            throw new IllegalStateException("Simulation time ratio cannot be zero.");
        }
        return ratio;
    }

    public String getEarthStartDateTime() {
        Element root = this.simulationDoc.getRootElement();
        Element timeConfig = root.getChild(TIME_CONFIGURATION);
        Element earthStartDate = timeConfig.getChild(EARTH_START_DATE_TIME);
        String startDate = earthStartDate.getAttributeValue(VALUE);
        if (startDate == null || startDate.trim().length() == 0) {
            throw new IllegalStateException("Earth start date time must not be blank.");
        }
        return startDate;
    }

    public String getMarsStartDateTime() {
        Element root = this.simulationDoc.getRootElement();
        Element timeConfig = root.getChild(TIME_CONFIGURATION);
        Element marsStartDate = timeConfig.getChild(MARS_START_DATE_TIME);
        String startDate = marsStartDate.getAttributeValue(VALUE);
        if (startDate == null || startDate.trim().length() == 0) {
            throw new IllegalStateException("Mars start date time must not be blank.");
        }
        return startDate;
    }

    public PartConfig getPartConfiguration() {
        return this.partConfig;
    }

    public PartPackageConfig getPartPackageConfiguration() {
        return this.partPackageConfig;
    }

    public AmountResourceConfig getResourceConfiguration() {
        return this.resourceConfig;
    }

    public PersonConfig getPersonConfiguration() {
        return this.personConfig;
    }

    public MedicalConfig getMedicalConfiguration() {
        return this.medicalConfig;
    }

    public LandmarkConfig getLandmarkConfiguration() {
        return this.landmarkConfig;
    }

    public MineralMapConfig getMineralMapConfiguration() {
        return this.mineralMapConfig;
    }

    public MalfunctionConfig getMalfunctionConfiguration() {
        return this.malfunctionConfig;
    }

    public CropConfig getCropConfiguration() {
        return this.cropConfig;
    }

    public VehicleConfig getVehicleConfiguration() {
        return this.vehicleConfig;
    }

    public BuildingConfig getBuildingConfiguration() {
        return this.buildingConfig;
    }

    public ResupplyConfig getResupplyConfiguration() {
        return this.resupplyConfig;
    }

    public SettlementConfig getSettlementConfiguration() {
        return this.settlementConfig;
    }

    public ManufactureConfig getManufactureConfiguration() {
        return this.manufactureConfig;
    }

    public ConstructionConfig getConstructionConfiguration() {
        return this.constructionConfig;
    }

    private void loadDefaultConfiguration() {
        try {
            this.simulationDoc = this.parseXMLFileAsJDOMDocument(SIMULATION_FILE, true);
            this.resourceConfig = new AmountResourceConfig(this.parseXMLFileAsJDOMDocument(RESOURCE_FILE, true));
            this.partConfig = new PartConfig(this.parseXMLFileAsJDOMDocument(PART_FILE, true));
            this.partPackageConfig = new PartPackageConfig(this.parseXMLFileAsJDOMDocument(PART_PACKAGE_FILE, true));
            this.personConfig = new PersonConfig(this.parseXMLFileAsJDOMDocument(PEOPLE_FILE, true));
            this.medicalConfig = new MedicalConfig(this.parseXMLFileAsJDOMDocument(MEDICAL_FILE, true));
            this.landmarkConfig = new LandmarkConfig(this.parseXMLFileAsJDOMDocument(LANDMARK_FILE, true));
            this.mineralMapConfig = new MineralMapConfig(this.parseXMLFileAsJDOMDocument(MINERAL_MAP_FILE, true));
            this.malfunctionConfig = new MalfunctionConfig(this.parseXMLFileAsJDOMDocument(MALFUNCTION_FILE, true));
            this.cropConfig = new CropConfig(this.parseXMLFileAsJDOMDocument(CROP_FILE, true));
            this.vehicleConfig = new VehicleConfig(this.parseXMLFileAsJDOMDocument(VEHICLE_FILE, true));
            this.buildingConfig = new BuildingConfig(this.parseXMLFileAsJDOMDocument(BUILDING_FILE, true));
            this.resupplyConfig = new ResupplyConfig(this.parseXMLFileAsJDOMDocument(RESUPPLY_FILE, true), this.partPackageConfig);
            this.settlementConfig = new SettlementConfig(this.parseXMLFileAsJDOMDocument(SETTLEMENT_FILE, true), this.partPackageConfig);
            this.manufactureConfig = new ManufactureConfig(this.parseXMLFileAsJDOMDocument(MANUFACTURE_FILE, true));
            this.constructionConfig = new ConstructionConfig(this.parseXMLFileAsJDOMDocument(CONSTRUCTION_FILE, true));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating simulation config: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void destroyOldConfiguration() {
        this.simulationDoc = null;
        this.resourceConfig = null;
        this.partConfig = null;
        this.partPackageConfig.destroy();
        this.personConfig.destroy();
        this.medicalConfig.destroy();
        this.landmarkConfig.destroy();
        this.mineralMapConfig.destroy();
        this.malfunctionConfig.destroy();
        this.cropConfig.destroy();
        this.vehicleConfig.destroy();
        this.buildingConfig.destroy();
        this.resupplyConfig.destroy();
        this.settlementConfig.destroy();
        this.manufactureConfig.destroy();
        this.constructionConfig.destroy();
    }

    private Document parseXMLFileAsJDOMDocument(String filename, boolean useDTD) throws IOException, JDOMException {
        InputStream stream = this.getInputStream(filename);
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        SAXBuilder saxBuilder = new SAXBuilder(useDTD);
        saxBuilder.setEntityResolver((EntityResolver)new ClasspathEntityResolver());
        Document result = saxBuilder.build((Reader)reader);
        stream.close();
        return result;
    }

    private InputStream getInputStream(String filename) throws IOException {
        String fullPathName = "/conf/" + filename + ".xml";
        InputStream stream = this.getClass().getResourceAsStream(fullPathName);
        if (stream == null) {
            throw new IOException(fullPathName + " failed to load");
        }
        return stream;
    }
}

