/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.UnitEvent;
import org.mars_sim.msp.core.UnitListener;
import org.mars_sim.msp.core.UnitManager;

public abstract class Unit
implements Serializable,
Comparable<Unit> {
    public static final String NAME_EVENT = "name";
    public static final String DESCRIPTION_EVENT = "description";
    public static final String MASS_EVENT = "mass";
    public static final String LOCATION_EVENT = "location";
    public static final String CONTAINER_UNIT_EVENT = "container unit";
    private Coordinates location;
    private String name;
    private String description;
    private double baseMass;
    private Inventory inventory;
    private Unit containerUnit;
    private transient List<UnitListener> listeners = Collections.synchronizedList(new ArrayList());
    private static Logger logger = Logger.getLogger(Unit.class.getName());

    public Unit(String name, Coordinates location) {
        this.name = name;
        this.description = name;
        this.baseMass = Double.MAX_VALUE;
        this.inventory = new Inventory(this);
        this.location = new Coordinates(0.0, 0.0);
        this.location.setCoords(location);
        this.inventory.setCoordinates(location);
    }

    public UnitManager getUnitManager() {
        return Simulation.instance().getUnitManager();
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
        this.fireUnitUpdate(NAME_EVENT, name);
    }

    public String getDescription() {
        return this.description;
    }

    protected final void setDescription(String description) {
        this.description = description;
        this.fireUnitUpdate(DESCRIPTION_EVENT, description);
    }

    public Coordinates getCoordinates() {
        return this.location;
    }

    public void setCoordinates(Coordinates newLocation) {
        this.location.setCoords(newLocation);
        this.inventory.setCoordinates(newLocation);
        this.fireUnitUpdate(LOCATION_EVENT, newLocation);
    }

    public void timePassing(double time) {
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Unit getContainerUnit() {
        return this.containerUnit;
    }

    public Unit getTopContainerUnit() {
        Unit topUnit = this.containerUnit;
        if (topUnit != null) {
            while (topUnit.containerUnit != null) {
                topUnit = topUnit.containerUnit;
            }
        }
        return topUnit;
    }

    public void setContainerUnit(Unit containerUnit) {
        this.containerUnit = containerUnit;
        this.fireUnitUpdate(CONTAINER_UNIT_EVENT, containerUnit);
    }

    public double getMass() {
        return this.baseMass + this.inventory.getTotalInventoryMass(false);
    }

    protected final void setBaseMass(double baseMass) {
        this.baseMass = baseMass;
        this.fireUnitUpdate(MASS_EVENT);
    }

    public double getBaseMass() {
        return this.baseMass;
    }

    public String toString() {
        return this.name;
    }

    public synchronized boolean hasUnitListener(UnitListener listener) {
        if (this.listeners == null) {
            return false;
        }
        return this.listeners.contains(listener);
    }

    public final synchronized void addUnitListener(UnitListener newListener) {
        if (newListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        } else {
            try {
                throw new IllegalStateException("Already contains this listener of type " + newListener.getClass().getName() + " : " + newListener + ", not adding");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.SEVERE, "Adding listener dupe", e);
            }
        }
    }

    public final synchronized void removeUnitListener(UnitListener oldListener) {
        if (oldListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (this.listeners.size() < 1) {
            return;
        }
        this.listeners.remove(oldListener);
    }

    public final void fireUnitUpdate(String updateType) {
        this.fireUnitUpdate(updateType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireUnitUpdate(String updateType, Object target) {
        if (this.listeners == null || this.listeners.size() < 1) {
            return;
        }
        UnitEvent ue = new UnitEvent(this, updateType, target);
        List<UnitListener> list = this.listeners;
        synchronized (list) {
            Iterator<UnitListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().unitUpdate(ue);
            }
        }
    }

    @Override
    public int compareTo(Unit o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public void destroy() {
        this.location = null;
        this.name = null;
        this.description = null;
        this.inventory.destroy();
        this.inventory = null;
        this.containerUnit = null;
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
    }
}

