/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitManagerEvent;
import org.mars_sim.msp.core.UnitManagerListener;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.ai.Skill;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.job.JobManager;
import org.mars_sim.msp.core.person.ai.social.Relationship;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.SettlementConfig;
import org.mars_sim.msp.core.structure.SettlementTemplate;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.core.vehicle.VehicleConfig;

public class UnitManager
implements Serializable {
    private static Logger logger = Logger.getLogger(UnitManager.class.getName());
    public static final String SETTLEMENT = "settlement";
    public static final String PERSON = "person";
    public static final String VEHICLE = "vehicle";
    public static final String EQUIPMENT = "equipment";
    private Collection<Unit> units = new ConcurrentLinkedQueue<Unit>();
    private List<String> settlementNames;
    private List<String> vehicleNames;
    private List<String> personMaleNames;
    private List<String> personFemaleNames;
    private transient List<UnitManagerListener> listeners = Collections.synchronizedList(new ArrayList());
    private Map<String, Integer> equipmentNumberMap = new HashMap<String, Integer>();
    private Map<String, Integer> vehicleNumberMap = new HashMap<String, Integer>();

    UnitManager() {
    }

    void constructInitialUnits() {
        this.initializePersonNames();
        this.initializeSettlementNames();
        this.initializeVehicleNames();
        this.createInitialSettlements();
        this.createInitialVehicles();
        this.createInitialEquipment();
        this.createInitialResources();
        this.createInitialParts();
        this.createInitialPeople();
    }

    private void initializePersonNames() {
        try {
            PersonConfig personConfig = SimulationConfig.instance().getPersonConfiguration();
            List<String> personNames = personConfig.getPersonNameList();
            this.personMaleNames = new ArrayList<String>();
            this.personFemaleNames = new ArrayList<String>();
            for (String name : personNames) {
                String gender = personConfig.getPersonGender(name);
                if (gender.equals("male")) {
                    this.personMaleNames.add(name);
                    continue;
                }
                if (!gender.equals("female")) continue;
                this.personFemaleNames.add(name);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("person names could not be loaded: " + e.getMessage(), e);
        }
    }

    private void initializeVehicleNames() {
        try {
            VehicleConfig vehicleConfig = SimulationConfig.instance().getVehicleConfiguration();
            this.vehicleNames = vehicleConfig.getRoverNameList();
        }
        catch (Exception e) {
            throw new IllegalStateException("rover names could not be loaded: " + e.getMessage(), e);
        }
    }

    private void initializeSettlementNames() {
        try {
            SettlementConfig settlementConfig = SimulationConfig.instance().getSettlementConfiguration();
            this.settlementNames = settlementConfig.getSettlementNameList();
        }
        catch (Exception e) {
            throw new IllegalStateException("settlement names could not be loaded: " + e.getMessage(), e);
        }
    }

    public void addUnit(Unit unit) {
        if (!this.units.contains(unit)) {
            this.units.add(unit);
            Iterator<Unit> i = unit.getInventory().getContainedUnits().iterator();
            while (i.hasNext()) {
                this.addUnit(i.next());
            }
            this.fireUnitManagerUpdate("add unit", unit);
        }
    }

    public void removeUnit(Unit unit) {
        if (this.units.contains(unit)) {
            this.units.remove(unit);
            this.fireUnitManagerUpdate("remove unit", unit);
        }
    }

    public String getNewName(String unitType, String baseName, String gender) {
        List<String> initialNameList = null;
        ArrayList<String> usedNames = new ArrayList<String>();
        String unitName = "";
        if (unitType.equals(SETTLEMENT)) {
            initialNameList = this.settlementNames;
            Iterator<Settlement> si = this.getSettlements().iterator();
            while (si.hasNext()) {
                usedNames.add(si.next().getName());
            }
            unitName = "Settlement";
        } else if (unitType.equals(VEHICLE)) {
            if (baseName != null) {
                int number = 1;
                if (this.vehicleNumberMap.containsKey(baseName)) {
                    number += this.vehicleNumberMap.get(baseName).intValue();
                }
                this.vehicleNumberMap.put(baseName, number);
                return baseName + " " + number;
            }
            initialNameList = this.vehicleNames;
            Iterator<Vehicle> vi = this.getVehicles().iterator();
            while (vi.hasNext()) {
                usedNames.add(vi.next().getName());
            }
            unitName = "Vehicle";
        } else if (unitType.equals(PERSON)) {
            if ("male".equals(gender)) {
                initialNameList = this.personMaleNames;
            } else if ("female".equals(gender)) {
                initialNameList = this.personFemaleNames;
            } else {
                throw new IllegalArgumentException("Improper gender for person unitType: " + gender);
            }
            Iterator<Person> pi = this.getPeople().iterator();
            while (pi.hasNext()) {
                usedNames.add(pi.next().getName());
            }
            unitName = "Person";
        } else if (unitType.equals(EQUIPMENT)) {
            if (baseName != null) {
                int number = 1;
                if (this.equipmentNumberMap.containsKey(baseName)) {
                    number += this.equipmentNumberMap.get(baseName).intValue();
                }
                this.equipmentNumberMap.put(baseName, number);
                return baseName + " " + number;
            }
        } else {
            throw new IllegalArgumentException("Improper unitType");
        }
        ArrayList<String> remainingNames = new ArrayList<String>();
        for (String name : initialNameList) {
            if (usedNames.contains(name)) continue;
            remainingNames.add(name);
        }
        String result = "";
        result = remainingNames.size() > 0 ? (String)remainingNames.get(RandomUtil.getRandomInt(remainingNames.size() - 1)) : unitName + " " + (usedNames.size() + 1);
        return result;
    }

    private void createInitialSettlements() {
        SettlementConfig config = SimulationConfig.instance().getSettlementConfiguration();
        try {
            for (int x = 0; x < config.getNumberOfInitialSettlements(); ++x) {
                String name = config.getInitialSettlementName(x);
                if (name.equals("random")) {
                    name = this.getNewName(SETTLEMENT, null, null);
                }
                String template = config.getInitialSettlementTemplate(x);
                double longitude = 0.0;
                String longitudeStr = config.getInitialSettlementLongitude(x);
                longitude = longitudeStr.equals("random") ? Coordinates.getRandomLongitude() : Coordinates.parseLongitude(longitudeStr);
                double latitude = 0.0;
                String latitudeStr = config.getInitialSettlementLatitude(x);
                latitude = latitudeStr.equals("random") ? Coordinates.getRandomLatitude() : Coordinates.parseLatitude(latitudeStr);
                Coordinates location = new Coordinates(latitude, longitude);
                int populationNumber = config.getInitialSettlementPopulationNumber(x);
                this.addUnit(new Settlement(name, template, location, populationNumber));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IllegalStateException("Settlements could not be created: " + e.getMessage(), e);
        }
    }

    private void createInitialVehicles() {
        SettlementConfig config = SimulationConfig.instance().getSettlementConfiguration();
        try {
            for (Settlement settlement : this.getSettlements()) {
                SettlementTemplate template = config.getSettlementTemplate(settlement.getTemplate());
                Map<String, Integer> vehicleMap = template.getVehicles();
                for (String vehicleType : vehicleMap.keySet()) {
                    int number = vehicleMap.get(vehicleType);
                    for (int x = 0; x < number; ++x) {
                        String name;
                        if ("Light Utility Vehicle".equals(vehicleType)) {
                            name = this.getNewName(VEHICLE, "LUV", null);
                            this.addUnit(new LightUtilityVehicle(name, vehicleType, settlement));
                            continue;
                        }
                        name = this.getNewName(VEHICLE, null, null);
                        this.addUnit(new Rover(name, vehicleType, settlement));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Vehicles could not be created: " + e.getMessage(), e);
        }
    }

    private void createInitialEquipment() {
        SettlementConfig config = SimulationConfig.instance().getSettlementConfiguration();
        try {
            for (Settlement settlement : this.getSettlements()) {
                SettlementTemplate template = config.getSettlementTemplate(settlement.getTemplate());
                Map<String, Integer> equipmentMap = template.getEquipment();
                for (String type : equipmentMap.keySet()) {
                    int number = equipmentMap.get(type);
                    for (int x = 0; x < number; ++x) {
                        Equipment equipment = EquipmentFactory.getEquipment(type, settlement.getCoordinates(), false);
                        equipment.setName(this.getNewName(EQUIPMENT, type, null));
                        settlement.getInventory().storeUnit(equipment);
                        this.addUnit(equipment);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Equipment could not be created: " + e.getMessage(), e);
        }
    }

    private void createInitialResources() {
        SettlementConfig config = SimulationConfig.instance().getSettlementConfiguration();
        try {
            for (Settlement settlement : this.getSettlements()) {
                SettlementTemplate template = config.getSettlementTemplate(settlement.getTemplate());
                Map<AmountResource, Double> resourceMap = template.getResources();
                for (AmountResource resource : resourceMap.keySet()) {
                    Inventory inv;
                    double capacity;
                    double amount = resourceMap.get(resource);
                    if (amount > (capacity = (inv = settlement.getInventory()).getAmountResourceRemainingCapacity(resource, true, false))) {
                        amount = capacity;
                    }
                    inv.storeAmountResource(resource, amount, true);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Equipment could not be created: " + e.getMessage(), e);
        }
    }

    private void createInitialParts() {
        SettlementConfig config = SimulationConfig.instance().getSettlementConfiguration();
        try {
            for (Settlement settlement : this.getSettlements()) {
                SettlementTemplate template = config.getSettlementTemplate(settlement.getTemplate());
                Map<Part, Integer> partMap = template.getParts();
                for (Part part : partMap.keySet()) {
                    Integer number = partMap.get(part);
                    Inventory inv = settlement.getInventory();
                    inv.storeItemResources(part, number);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Part could not be created: " + e.getMessage(), e);
        }
    }

    private void createInitialPeople() {
        this.createConfiguredPeople();
        PersonConfig personConfig = SimulationConfig.instance().getPersonConfiguration();
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        try {
            for (Settlement settlement : this.getSettlements()) {
                while (settlement.getCurrentPopulationNum() < settlement.getInitialPopulation()) {
                    String gender = "female";
                    if (RandomUtil.getRandomDouble(1.0) <= personConfig.getGenderRatio()) {
                        gender = "male";
                    }
                    Person person = new Person(this.getNewName(PERSON, null, gender), gender, settlement);
                    this.addUnit(person);
                    relationshipManager.addInitialSettler(person, settlement);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IllegalStateException("People could not be created: " + e.getMessage(), e);
        }
    }

    private void createConfiguredPeople() {
        PersonConfig personConfig = SimulationConfig.instance().getPersonConfiguration();
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        for (int x = 0; x < personConfig.getNumberOfConfiguredPeople(); ++x) {
            Map<String, Integer> skillMap;
            Map<String, Integer> naturalAttributeMap;
            String jobName;
            Collection<Settlement> col;
            String name = personConfig.getConfiguredPersonName(x);
            if (name == null) {
                throw new IllegalStateException("Person name is null");
            }
            String gender = personConfig.getConfiguredPersonGender(x);
            if (gender == null) {
                gender = "female";
                if (RandomUtil.getRandomDouble(1.0) <= personConfig.getGenderRatio()) {
                    gender = "male";
                }
            }
            String settlementName = personConfig.getConfiguredPersonSettlement(x);
            Settlement settlement = null;
            if (settlementName != null) {
                col = CollectionUtils.getSettlement(this.units);
                settlement = CollectionUtils.getSettlement(col, settlementName);
                if (settlement == null) {
                    logger.log(Level.WARNING, "Person " + name + " could not be located" + " at " + settlementName + " because the settlement doesn't exist.");
                    settlement = CollectionUtils.getRandomSettlement(col);
                }
            } else {
                col = CollectionUtils.getSettlement(this.units);
                settlement = CollectionUtils.getRandomSettlement(col);
            }
            if (settlement == null) {
                return;
            }
            if (settlement.getInitialPopulation() <= settlement.getCurrentPopulationNum()) {
                Iterator<Settlement> i = this.getSettlements().iterator();
                Settlement newSettlement = null;
                while (i.hasNext() && newSettlement == null) {
                    Settlement tempSettlement = i.next();
                    if (tempSettlement.getInitialPopulation() <= tempSettlement.getCurrentPopulationNum()) continue;
                    newSettlement = tempSettlement;
                }
                if (newSettlement != null) {
                    settlement = newSettlement;
                } else {
                    return;
                }
            }
            Person person = new Person(name, gender, settlement);
            this.addUnit(person);
            relationshipManager.addInitialSettler(person, settlement);
            String personalityType = personConfig.getConfiguredPersonPersonalityType(x);
            if (personalityType != null) {
                person.getMind().getPersonalityType().setTypeString(personalityType);
            }
            if ((jobName = personConfig.getConfiguredPersonJob(x)) != null) {
                Job job = JobManager.getJob(jobName);
                person.getMind().setJob(job, true);
            }
            if ((naturalAttributeMap = personConfig.getNaturalAttributeMap(x)) != null) {
                for (String attributeName : naturalAttributeMap.keySet()) {
                    int value = naturalAttributeMap.get(attributeName);
                    person.getNaturalAttributeManager().setAttribute(attributeName, value);
                }
            }
            if ((skillMap = personConfig.getSkillMap(x)) == null) continue;
            for (String skillName : skillMap.keySet()) {
                int level = skillMap.get(skillName);
                person.getMind().getSkillManager().addNewSkill(new Skill(skillName, level));
            }
        }
        this.createConfiguredRelationships();
    }

    private void createConfiguredRelationships() {
        PersonConfig personConfig = SimulationConfig.instance().getPersonConfiguration();
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        for (int x = 0; x < personConfig.getNumberOfConfiguredPeople(); ++x) {
            try {
                String name = personConfig.getConfiguredPersonName(x);
                if (name == null) {
                    throw new IllegalStateException("Person name is null");
                }
                Person person = null;
                for (Person tempPerson : this.getPeople()) {
                    if (!tempPerson.getName().equals(name)) continue;
                    person = tempPerson;
                }
                if (person == null) {
                    throw new IllegalStateException("Person: " + name + " not found.");
                }
                Map<String, Integer> relationshipMap = personConfig.getRelationshipMap(x);
                if (relationshipMap == null) continue;
                for (String relationshipName : relationshipMap.keySet()) {
                    Person relationshipPerson = null;
                    for (Person tempPerson : this.getPeople()) {
                        if (!tempPerson.getName().equals(relationshipName)) continue;
                        relationshipPerson = tempPerson;
                    }
                    if (relationshipPerson == null) {
                        throw new IllegalStateException("Person: " + relationshipName + " not found.");
                    }
                    int opinion = relationshipMap.get(relationshipName);
                    Relationship relationship = relationshipManager.getRelationship(person, relationshipPerson);
                    if (relationship != null) {
                        relationship.setPersonOpinion(person, opinion);
                        continue;
                    }
                    relationshipManager.addRelationship(person, relationshipPerson, "Existing Relationship");
                    relationship = relationshipManager.getRelationship(person, relationshipPerson);
                    relationship.setPersonOpinion(person, opinion);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                logger.log(Level.SEVERE, "Configured relationship could not be created: " + e.getMessage());
            }
        }
    }

    void timePassing(double time) {
        Iterator<Unit> i = this.units.iterator();
        while (i.hasNext()) {
            i.next().timePassing(time);
        }
    }

    public int getSettlementNum() {
        return CollectionUtils.getSettlement(this.units).size();
    }

    public Collection<Settlement> getSettlements() {
        return CollectionUtils.getSettlement(this.units);
    }

    public int getVehicleNum() {
        return CollectionUtils.getVehicle(this.units).size();
    }

    public Collection<Vehicle> getVehicles() {
        return CollectionUtils.getVehicle(this.units);
    }

    public int getPeopleNum() {
        return CollectionUtils.getPerson(this.units).size();
    }

    public Collection<Person> getPeople() {
        return CollectionUtils.getPerson(this.units);
    }

    public int getEquipmentNum() {
        return CollectionUtils.getEquipment(this.units).size();
    }

    public Collection<Equipment> getEquipment() {
        return CollectionUtils.getEquipment(this.units);
    }

    public int getUnitNum() {
        return this.units.size();
    }

    public Collection<Unit> getUnits() {
        return this.units;
    }

    public final void addUnitManagerListener(UnitManagerListener newListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public final void removeUnitManagerListener(UnitManagerListener oldListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (this.listeners.contains(oldListener)) {
            this.listeners.remove(oldListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireUnitManagerUpdate(String eventType, Unit unit) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        List<UnitManagerListener> list = this.listeners;
        synchronized (list) {
            Iterator<UnitManagerListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().unitManagerUpdate(new UnitManagerEvent(this, eventType, unit));
            }
        }
    }

    public Unit findUnit(String name) {
        Unit result = null;
        Iterator<Unit> i = this.units.iterator();
        while (i.hasNext() && result == null) {
            Unit unit = i.next();
            if (!unit.getName().equals(name)) continue;
            result = unit;
        }
        return result;
    }

    public void destroy() {
        Iterator<Unit> i = this.units.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
        this.units.clear();
        this.units = null;
        this.settlementNames.clear();
        this.settlementNames = null;
        this.vehicleNames.clear();
        this.vehicleNames = null;
        this.personMaleNames.clear();
        this.personMaleNames = null;
        this.personFemaleNames.clear();
        this.personFemaleNames = null;
        this.listeners.clear();
        this.listeners = null;
        this.equipmentNumberMap.clear();
        this.equipmentNumberMap = null;
        this.vehicleNumberMap.clear();
        this.vehicleNumberMap = null;
    }
}

