/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.equipment;

import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.equipment.Barrel;
import org.mars_sim.msp.core.equipment.Container;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.equipment.GasCanister;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Phase;

public final class ContainerUtil {
    private static final Coordinates coordinates = new Coordinates(0.0, 0.0);

    private ContainerUtil() {
    }

    public static Class<? extends Container> getContainerClassToHoldResource(AmountResource resource) {
        Class result = null;
        Phase phase = resource.getPhase();
        if (Phase.GAS.equals(phase)) {
            result = GasCanister.class;
        } else if (Phase.LIQUID.equals(phase)) {
            result = Barrel.class;
        } else if (Phase.SOLID.equals(phase)) {
            result = Bag.class;
        }
        return result;
    }

    public static double getContainerCapacity(Class<? extends Container> containerClass) {
        double result = 0.0;
        Class<? extends Container> equipmentClass = containerClass;
        Container container = (Container)((Object)EquipmentFactory.getEquipment(equipmentClass, coordinates, true));
        if (container != null) {
            result = container.getTotalCapacity();
        }
        return result;
    }
}

