/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.equipment;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.manufacture.Salvagable;
import org.mars_sim.msp.core.manufacture.SalvageInfo;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.task.Maintenance;
import org.mars_sim.msp.core.person.ai.task.Repair;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.structure.Settlement;

public abstract class Equipment
extends Unit
implements Salvagable {
    private boolean isSalvaged = false;
    private SalvageInfo salvageInfo = null;

    Equipment(String name, Coordinates location) {
        super(name, location);
    }

    public Collection<Person> getAffectedPeople() {
        ConcurrentLinkedQueue<Person> people = new ConcurrentLinkedQueue<Person>();
        for (Person person : Simulation.instance().getUnitManager().getPeople()) {
            Task task = person.getMind().getTaskManager().getTask();
            if (task instanceof Maintenance && ((Maintenance)task).getEntity() == this && !people.contains(person)) {
                people.add(person);
            }
            if (!(task instanceof Repair) || ((Repair)((Object)task)).getEntity() != this || people.contains(person)) continue;
            people.add(person);
        }
        return people;
    }

    @Override
    public boolean isSalvaged() {
        return this.isSalvaged;
    }

    @Override
    public void startSalvage(SalvageProcessInfo info, Settlement settlement) {
        this.salvageInfo = new SalvageInfo(this, info, settlement);
        this.isSalvaged = true;
    }

    @Override
    public SalvageInfo getSalvageInfo() {
        return this.salvageInfo;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.salvageInfo != null) {
            this.salvageInfo.destroy();
        }
        this.salvageInfo = null;
    }
}

