/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.interplanetary.transport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.interplanetary.transport.TransportEvent;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;
import org.mars_sim.msp.core.interplanetary.transport.resupply.ResupplyUtil;
import org.mars_sim.msp.core.interplanetary.transport.settlement.ArrivingSettlementUtil;
import org.mars_sim.msp.core.time.MarsClock;

public class TransportManager
implements Serializable {
    private static Logger logger = Logger.getLogger(TransportManager.class.getName());
    private Collection<Transportable> transportItems = new ConcurrentLinkedQueue<Transportable>();

    public TransportManager() {
        this.transportItems.addAll(ArrivingSettlementUtil.createInitialArrivingSettlements());
        this.transportItems.addAll(ResupplyUtil.createInitialResupplyMissions());
    }

    public void addNewTransportItem(Transportable transportItem) {
        this.transportItems.add(transportItem);
        TransportEvent newEvent = new TransportEvent(transportItem, "Transport Item Created", "Transport item created: " + transportItem.getName());
        Simulation.instance().getEventManager().registerNewEvent(newEvent);
        logger.info("New transport item created: " + transportItem.toString());
    }

    public List<Transportable> getAllTransportItems() {
        return new ArrayList<Transportable>(this.transportItems);
    }

    public List<Transportable> getIncomingTransportItems() {
        ArrayList<Transportable> incoming = new ArrayList<Transportable>(this.transportItems.size());
        for (Transportable transportItem : this.transportItems) {
            String state = transportItem.getTransitState();
            if (!"planned".equals(state) && !"in transit".equals(state)) continue;
            incoming.add(transportItem);
        }
        return incoming;
    }

    public List<Transportable> getArrivedTransportItems() {
        ArrayList<Transportable> arrived = new ArrayList<Transportable>(this.transportItems.size());
        for (Transportable transportItem : this.transportItems) {
            String state = transportItem.getTransitState();
            if (!"arrived".equals(state)) continue;
            arrived.add(transportItem);
        }
        return arrived;
    }

    public void cancelTransportItem(Transportable transportItem) {
        transportItem.setTransitState("canceled");
        TransportEvent cancelEvent = new TransportEvent(transportItem, "Transport Item Canceled", "Transport item cancelled");
        Simulation.instance().getEventManager().registerNewEvent(cancelEvent);
        logger.info("Transport item cancelled: " + transportItem.toString());
    }

    public void timePassing(double time) {
        for (Transportable transportItem : this.transportItems) {
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            if ("planned".equals(transportItem.getTransitState())) {
                if (!(MarsClock.getTimeDiff(currentTime, transportItem.getLaunchDate()) >= 0.0)) continue;
                transportItem.setTransitState("in transit");
                TransportEvent deliverEvent = new TransportEvent(transportItem, "Transport Item Launched", "Transport item launched");
                Simulation.instance().getEventManager().registerNewEvent(deliverEvent);
                logger.info("Transport item launched: " + transportItem.toString());
                continue;
            }
            if (!"in transit".equals(transportItem.getTransitState()) || !(MarsClock.getTimeDiff(currentTime, transportItem.getArrivalDate()) >= 0.0)) continue;
            transportItem.setTransitState("arrived");
            transportItem.performArrival();
            TransportEvent arrivalEvent = new TransportEvent(transportItem, "Transport Item Arrived", "Transport item arrived on Mars");
            Simulation.instance().getEventManager().registerNewEvent(arrivalEvent);
            logger.info("Transport item arrived: " + transportItem.toString());
        }
    }

    public void destroy() {
        Iterator<Transportable> i = this.transportItems.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
        this.transportItems.clear();
        this.transportItems = null;
    }
}

