/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.interplanetary.transport.resupply;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.resource.PartPackageConfig;
import org.mars_sim.msp.core.structure.BuildingTemplate;

public class ResupplyConfig
implements Serializable {
    private static final String RESUPPLY = "resupply";
    private static final String NAME = "name";
    private static final String BUILDING = "building";
    private static final String X_LOCATION = "x-location";
    private static final String Y_LOCATION = "y-location";
    private static final String FACING = "facing";
    private static final String VEHICLE = "vehicle";
    private static final String EQUIPMENT = "equipment";
    private static final String PERSON = "person";
    private static final String RESOURCE = "resource";
    private static final String PART = "part";
    private static final String PART_PACKAGE = "part-package";
    private static final String TYPE = "type";
    private static final String NUMBER = "number";
    private static final String AMOUNT = "amount";
    Collection<ResupplyTemplate> resupplyTemplates = new ArrayList<ResupplyTemplate>();

    public ResupplyConfig(Document resupplyDoc, PartPackageConfig partPackageConfig) {
        this.loadResupplyTemplates(resupplyDoc, partPackageConfig);
    }

    private void loadResupplyTemplates(Document resupplyDoc, PartPackageConfig partPackageConfig) {
        Element root = resupplyDoc.getRootElement();
        List resupplyNodes = root.getChildren(RESUPPLY);
        for (Element resupplyElement : resupplyNodes) {
            ResupplyTemplate template = new ResupplyTemplate();
            this.resupplyTemplates.add(template);
            template.name = resupplyElement.getAttributeValue(NAME);
            List buildingNodes = resupplyElement.getChildren(BUILDING);
            for (Element buildingElement : buildingNodes) {
                String buildingType = buildingElement.getAttributeValue(TYPE);
                double xLoc = Double.parseDouble(buildingElement.getAttributeValue(X_LOCATION));
                double yLoc = Double.parseDouble(buildingElement.getAttributeValue(Y_LOCATION));
                double facing = Double.parseDouble(buildingElement.getAttributeValue(FACING));
                template.buildings.add(new BuildingTemplate(buildingType, xLoc, yLoc, facing));
            }
            List vehicleNodes = resupplyElement.getChildren(VEHICLE);
            for (Element vehicleElement : vehicleNodes) {
                String vehicleType = vehicleElement.getAttributeValue(TYPE);
                int vehicleNumber = Integer.parseInt(vehicleElement.getAttributeValue(NUMBER));
                if (template.vehicles.containsKey(vehicleType)) {
                    vehicleNumber += ((Integer)template.vehicles.get(vehicleType)).intValue();
                }
                template.vehicles.put(vehicleType, vehicleNumber);
            }
            List equipmentNodes = resupplyElement.getChildren(EQUIPMENT);
            for (Element equipmentElement : equipmentNodes) {
                String equipmentType = equipmentElement.getAttributeValue(TYPE);
                int equipmentNumber = Integer.parseInt(equipmentElement.getAttributeValue(NUMBER));
                if (template.equipment.containsKey(equipmentType)) {
                    equipmentNumber += ((Integer)template.equipment.get(equipmentType)).intValue();
                }
                template.equipment.put(equipmentType, equipmentNumber);
            }
            List personNodes = resupplyElement.getChildren(PERSON);
            for (Element personElement : personNodes) {
                int personNumber = Integer.parseInt(personElement.getAttributeValue(NUMBER));
                template.people += personNumber;
            }
            List resourceNodes = resupplyElement.getChildren(RESOURCE);
            for (Element resourceElement : resourceNodes) {
                String resourceType = resourceElement.getAttributeValue(TYPE);
                AmountResource resource = AmountResource.findAmountResource(resourceType);
                double resourceAmount = Double.parseDouble(resourceElement.getAttributeValue(AMOUNT));
                if (template.resources.containsKey(resource)) {
                    resourceAmount += ((Double)template.resources.get(resource)).doubleValue();
                }
                template.resources.put(resource, resourceAmount);
            }
            List partNodes = resupplyElement.getChildren(PART);
            for (Element partElement : partNodes) {
                String partType = partElement.getAttributeValue(TYPE);
                Part part = (Part)Part.findItemResource(partType);
                int partNumber = Integer.parseInt(partElement.getAttributeValue(NUMBER));
                if (template.parts.containsKey(part)) {
                    partNumber += ((Integer)template.parts.get(part)).intValue();
                }
                template.parts.put(part, partNumber);
            }
            List partPackageNodes = resupplyElement.getChildren(PART_PACKAGE);
            for (Element partPackageElement : partPackageNodes) {
                String packageName = partPackageElement.getAttributeValue(NAME);
                int packageNumber = Integer.parseInt(partPackageElement.getAttributeValue(NUMBER));
                if (packageNumber <= 0) continue;
                for (int z = 0; z < packageNumber; ++z) {
                    Map<Part, Integer> partPackage = partPackageConfig.getPartsInPackage(packageName);
                    for (Part part : partPackage.keySet()) {
                        int partNumber = partPackage.get(part);
                        if (template.parts.containsKey(part)) {
                            partNumber += ((Integer)template.parts.get(part)).intValue();
                        }
                        template.parts.put(part, partNumber);
                    }
                }
            }
        }
    }

    private ResupplyTemplate getResupplyTemplate(String resupplyName) {
        ResupplyTemplate result = null;
        for (ResupplyTemplate template : this.resupplyTemplates) {
            if (!template.name.equals(resupplyName)) continue;
            result = template;
        }
        if (result == null) {
            throw new IllegalArgumentException("resupplyName: " + resupplyName + " not found.");
        }
        return result;
    }

    public List<String> getResupplyBuildings(String resupplyName) {
        ArrayList<String> result = new ArrayList<String>();
        ResupplyTemplate foundTemplate = this.getResupplyTemplate(resupplyName);
        if (foundTemplate != null) {
            Iterator i = foundTemplate.buildings.iterator();
            while (i.hasNext()) {
                result.add(((BuildingTemplate)i.next()).getType());
            }
        }
        return result;
    }

    public List<String> getResupplyVehicleTypes(String resupplyName) {
        ResupplyTemplate foundTemplate = this.getResupplyTemplate(resupplyName);
        ArrayList<String> result = new ArrayList<String>();
        for (String vehicleType : foundTemplate.vehicles.keySet()) {
            int vehicleNumber = (Integer)foundTemplate.vehicles.get(vehicleType);
            for (int x = 0; x < vehicleNumber; ++x) {
                result.add(vehicleType);
            }
        }
        return result;
    }

    public Map<String, Integer> getResupplyEquipment(String resupplyName) {
        ResupplyTemplate foundTemplate = this.getResupplyTemplate(resupplyName);
        return new HashMap<String, Integer>(foundTemplate.equipment);
    }

    public int getNumberOfResupplyImmigrants(String resupplyName) {
        ResupplyTemplate foundTemplate = this.getResupplyTemplate(resupplyName);
        return foundTemplate.people;
    }

    public Map<Part, Integer> getResupplyParts(String resupplyName) {
        ResupplyTemplate foundTemplate = this.getResupplyTemplate(resupplyName);
        return new HashMap<Part, Integer>(foundTemplate.parts);
    }

    public Map<AmountResource, Double> getResupplyResources(String resupplyName) {
        ResupplyTemplate foundTemplate = this.getResupplyTemplate(resupplyName);
        return new HashMap<AmountResource, Double>(foundTemplate.resources);
    }

    public void destroy() {
        for (ResupplyTemplate template : this.resupplyTemplates) {
            template.name = null;
            template.buildings.clear();
            template.buildings = null;
            template.vehicles.clear();
            template.vehicles = null;
            template.equipment.clear();
            template.equipment = null;
            template.resources.clear();
            template.resources = null;
            template.parts.clear();
            template.parts = null;
        }
    }

    private static class ResupplyTemplate
    implements Serializable {
        private String name;
        private List<BuildingTemplate> buildings = new ArrayList<BuildingTemplate>();
        private Map<String, Integer> vehicles = new HashMap<String, Integer>();
        private Map<String, Integer> equipment = new HashMap<String, Integer>();
        private int people;
        private Map<AmountResource, Double> resources = new HashMap<AmountResource, Double>();
        private Map<Part, Integer> parts = new HashMap<Part, Integer>();

        private ResupplyTemplate() {
        }
    }
}

