/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.interplanetary.transport.resupply;

import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.interplanetary.transport.resupply.Resupply;
import org.mars_sim.msp.core.interplanetary.transport.resupply.ResupplyConfig;
import org.mars_sim.msp.core.interplanetary.transport.resupply.ResupplyMissionTemplate;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.SettlementConfig;
import org.mars_sim.msp.core.time.MarsClock;

public final class ResupplyUtil {
    public static int AVG_TRANSIT_TIME = 200;

    private ResupplyUtil() {
    }

    public static List<Resupply> createInitialResupplyMissions() {
        ArrayList<Resupply> resupplyMissions = new ArrayList<Resupply>();
        SettlementConfig settlementConfig = SimulationConfig.instance().getSettlementConfiguration();
        for (Settlement settlement : Simulation.instance().getUnitManager().getSettlements()) {
            String templateName = settlement.getTemplate();
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            for (ResupplyMissionTemplate template : settlementConfig.getSettlementTemplate(templateName).getResupplyMissionTemplates()) {
                MarsClock arrivalDate = (MarsClock)currentTime.clone();
                arrivalDate.addTime(template.getArrivalTime() * 1000.0);
                Resupply resupply = new Resupply(arrivalDate, settlement);
                MarsClock launchDate = (MarsClock)arrivalDate.clone();
                launchDate.addTime(-1.0 * (double)AVG_TRANSIT_TIME * 1000.0);
                resupply.setLaunchDate(launchDate);
                String state = "planned";
                if (MarsClock.getTimeDiff(currentTime, launchDate) >= 0.0) {
                    state = "in transit";
                    if (MarsClock.getTimeDiff(currentTime, arrivalDate) >= 0.0) {
                        state = "arrived";
                    }
                }
                resupply.setTransitState(state);
                ResupplyConfig resupplyConfig = SimulationConfig.instance().getResupplyConfiguration();
                String resupplyName = template.getName();
                resupply.setNewBuildings(resupplyConfig.getResupplyBuildings(resupplyName));
                resupply.setNewVehicles(resupplyConfig.getResupplyVehicleTypes(resupplyName));
                resupply.setNewEquipment(resupplyConfig.getResupplyEquipment(resupplyName));
                resupply.setNewImmigrantNum(resupplyConfig.getNumberOfResupplyImmigrants(resupplyName));
                resupply.setNewResources(resupplyConfig.getResupplyResources(resupplyName));
                resupply.setNewParts(resupplyConfig.getResupplyParts(resupplyName));
                resupplyMissions.add(resupply);
            }
        }
        return resupplyMissions;
    }
}

