/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.interplanetary.transport.settlement;

import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.interplanetary.transport.settlement.ArrivingSettlement;
import org.mars_sim.msp.core.structure.SettlementConfig;
import org.mars_sim.msp.core.time.MarsClock;

public class ArrivingSettlementUtil {
    public static int AVG_TRANSIT_TIME = 250;

    private ArrivingSettlementUtil() {
    }

    public static List<ArrivingSettlement> createInitialArrivingSettlements() {
        ArrayList<ArrivingSettlement> arrivingSettlements = new ArrayList<ArrivingSettlement>();
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        SettlementConfig settlementConfig = SimulationConfig.instance().getSettlementConfiguration();
        int arrivingSettlementNum = settlementConfig.getNumberOfNewArrivingSettlements();
        for (int x = 0; x < arrivingSettlementNum; ++x) {
            String name = settlementConfig.getNewArrivingSettlementName(x);
            if (name.equals("random")) {
                UnitManager unitManager = Simulation.instance().getUnitManager();
                name = unitManager.getNewName("settlement", null, null);
            }
            String template = settlementConfig.getNewArrivingSettlementTemplate(x);
            int population = settlementConfig.getNewArrivingSettlementPopulationNumber(x);
            double arrivalTime = settlementConfig.getNewArrivingSettlementArrivalTime(x);
            MarsClock arrivalDate = (MarsClock)currentTime.clone();
            arrivalDate.addTime(arrivalTime * 1000.0);
            double longitude = 0.0;
            String longitudeStr = settlementConfig.getNewArrivingSettlementLongitude(x);
            longitude = longitudeStr.equals("random") ? Coordinates.getRandomLongitude() : Coordinates.parseLongitude(longitudeStr);
            double latitude = 0.0;
            String latitudeStr = settlementConfig.getNewArrivingSettlementLatitude(x);
            latitude = latitudeStr.equals("random") ? Coordinates.getRandomLatitude() : Coordinates.parseLatitude(latitudeStr);
            Coordinates location = new Coordinates(latitude, longitude);
            ArrivingSettlement arrivingSettlement = new ArrivingSettlement(name, template, arrivalDate, location, population);
            MarsClock launchDate = (MarsClock)arrivalDate.clone();
            launchDate.addTime(-1.0 * (double)AVG_TRANSIT_TIME * 1000.0);
            arrivingSettlement.setLaunchDate(launchDate);
            String transitState = "planned";
            if (MarsClock.getTimeDiff(currentTime, launchDate) >= 0.0) {
                transitState = "in transit";
                if (MarsClock.getTimeDiff(currentTime, arrivalDate) >= 0.0) {
                    transitState = "arrived";
                }
            }
            arrivingSettlement.setTransitState(transitState);
            arrivingSettlements.add(arrivingSettlement);
        }
        return arrivingSettlements;
    }
}

