/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.malfunction;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.malfunction.MalfunctionConfig;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;

public class Malfunction
implements Serializable {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.malfunction.Malfunction";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private String name;
    private int severity;
    private double probability;
    private Collection<String> scope;
    private Map<AmountResource, Double> resourceEffects;
    private Map<String, Double> lifeSupportEffects;
    private Map<String, Double> medicalComplaints;
    private Map<Part, Integer> repairParts;
    private double workTime;
    private double workTimeCompleted;
    private double emergencyWorkTime;
    private double emergencyWorkTimeCompleted;
    private double EVAWorkTime;
    private double EVAWorkTimeCompleted;

    public Malfunction(String name, int severity, double probability, double emergencyWorkTime, double workTime, double EVAWorkTime, Collection<String> scope, Map<AmountResource, Double> resourceEffects, Map<String, Double> lifeSupportEffects, Map<String, Double> medicalComplaints) {
        this.name = name;
        this.severity = severity;
        this.probability = probability;
        this.emergencyWorkTime = emergencyWorkTime;
        this.workTime = workTime;
        this.EVAWorkTime = EVAWorkTime;
        this.scope = scope;
        this.resourceEffects = resourceEffects;
        this.lifeSupportEffects = lifeSupportEffects;
        this.medicalComplaints = medicalComplaints;
        this.repairParts = new HashMap<Part, Integer>();
        this.workTimeCompleted = 0.0;
        this.emergencyWorkTimeCompleted = 0.0;
        this.EVAWorkTimeCompleted = 0.0;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFixed() {
        boolean result = true;
        if (this.workTimeCompleted < this.workTime) {
            result = false;
        }
        if (this.emergencyWorkTimeCompleted < this.emergencyWorkTime) {
            result = false;
        }
        if (this.EVAWorkTimeCompleted < this.EVAWorkTime) {
            result = false;
        }
        return result;
    }

    public int getSeverity() {
        return this.severity;
    }

    public double getProbability() {
        return this.probability;
    }

    public double getWorkTime() {
        return this.workTime;
    }

    public double getCompletedWorkTime() {
        return this.workTimeCompleted;
    }

    public double addWorkTime(double time) {
        this.workTimeCompleted += time;
        if (this.workTimeCompleted >= this.workTime) {
            double remaining = this.workTimeCompleted - this.workTime;
            this.workTimeCompleted = this.workTime;
            return remaining;
        }
        return 0.0;
    }

    public double getEmergencyWorkTime() {
        return this.emergencyWorkTime;
    }

    public double getCompletedEmergencyWorkTime() {
        return this.emergencyWorkTimeCompleted;
    }

    public double addEmergencyWorkTime(double time) {
        this.emergencyWorkTimeCompleted += time;
        if (this.emergencyWorkTimeCompleted >= this.emergencyWorkTime) {
            double remaining = this.emergencyWorkTimeCompleted - this.emergencyWorkTime;
            this.emergencyWorkTimeCompleted = this.emergencyWorkTime;
            logger.info(this.name + "@" + Integer.toHexString(this.hashCode()) + " emergency fixed.");
            return remaining;
        }
        return 0.0;
    }

    public double getEVAWorkTime() {
        return this.EVAWorkTime;
    }

    public double getCompletedEVAWorkTime() {
        return this.EVAWorkTimeCompleted;
    }

    public double addEVAWorkTime(double time) {
        this.EVAWorkTimeCompleted += time;
        if (this.EVAWorkTimeCompleted >= this.EVAWorkTime) {
            double remaining = this.EVAWorkTimeCompleted - this.EVAWorkTime;
            this.EVAWorkTimeCompleted = this.EVAWorkTime;
            return remaining;
        }
        return 0.0;
    }

    public boolean unitScopeMatch(Collection<String> unitScope) {
        boolean result = false;
        if (this.scope.size() > 0 && unitScope.size() > 0) {
            for (String scopeString : this.scope) {
                for (String unitScopeString : unitScope) {
                    if (!scopeString.equalsIgnoreCase(unitScopeString)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    public Map<AmountResource, Double> getResourceEffects() {
        return this.resourceEffects;
    }

    public Map<String, Double> getLifeSupportEffects() {
        return this.lifeSupportEffects;
    }

    public Map<String, Double> getMedicalComplaints() {
        return this.medicalComplaints;
    }

    public Malfunction getClone() {
        Malfunction clone = new Malfunction(this.name, this.severity, this.probability, this.emergencyWorkTime, this.workTime, this.EVAWorkTime, this.scope, this.resourceEffects, this.lifeSupportEffects, this.medicalComplaints);
        if (this.emergencyWorkTime > 0.0) {
            logger.info(this.name + "@" + Integer.toHexString(clone.hashCode()) + " emergency starts");
        }
        return clone;
    }

    void determineRepairParts() {
        String[] partNames;
        MalfunctionConfig config = SimulationConfig.instance().getMalfunctionConfiguration();
        for (String partName : partNames = config.getRepairPartNamesForMalfunction(this.name)) {
            if (!RandomUtil.lessThanRandPercent(config.getRepairPartProbability(this.name, partName))) continue;
            int number = RandomUtil.getRandomRegressionInteger(config.getRepairPartNumber(this.name, partName));
            Part part = (Part)ItemResource.findItemResource(partName);
            this.repairParts.put(part, number);
            logger.info("New Malfunction: " + this.name + " - required part: " + part.getName() + " - number: " + number);
        }
    }

    public Map<Part, Integer> getRepairParts() {
        return new HashMap<Part, Integer>(this.repairParts);
    }

    public void repairWithParts(Part part, int number) {
        if (part == null) {
            throw new IllegalArgumentException("part is null");
        }
        if (this.repairParts.containsKey(part)) {
            int numberNeeded = this.repairParts.get(part);
            if (number > numberNeeded) {
                throw new IllegalArgumentException("number " + number + " is greater that number of parts needed: " + numberNeeded);
            }
            if ((numberNeeded -= number) > 0) {
                this.repairParts.put(part, numberNeeded);
            } else {
                this.repairParts.remove(part);
            }
        } else {
            throw new IllegalArgumentException("Part " + part + " is not needed for repairs.");
        }
    }

    public String toString() {
        return this.name;
    }
}

