/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.malfunction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.resource.AmountResource;

public class MalfunctionConfig
implements Serializable {
    private static final String MALFUNCTION = "malfunction";
    private static final String NAME = "name";
    private static final String SEVERITY = "severity";
    private static final String PROBABILITY = "probability";
    private static final String REPAIR_TIME = "repair-time";
    private static final String EMERGENCY_REPAIR_TIME = "emergency-repair-time";
    private static final String EVA_REPAIR_TIME = "eva-repair-time";
    private static final String ENTITY_LIST = "entity-list";
    private static final String ENTITY = "entity";
    private static final String EFFECT_LIST = "effect-list";
    private static final String EFFECT = "effect";
    private static final String TYPE = "type";
    private static final String CHANGE_RATE = "change-rate";
    private static final String MEDICAL_COMPLAINT_LIST = "medical-complaint-list";
    private static final String MEDICAL_COMPLAINT = "medical-complaint";
    private static final String REPAIR_PARTS_LIST = "repair-parts-list";
    private static final String PART = "part";
    private static final String NUMBER = "number";
    private static final String VALUE = "value";
    private Document malfunctionDoc;
    private List<Malfunction> malfunctionList;
    private Map<String, List<RepairPart>> repairParts;

    public MalfunctionConfig(Document malfunctionDoc) {
        this.malfunctionDoc = malfunctionDoc;
        this.repairParts = new HashMap<String, List<RepairPart>>();
    }

    public List<Malfunction> getMalfunctionList() {
        if (this.malfunctionList == null) {
            this.malfunctionList = new ArrayList<Malfunction>();
            Element root = this.malfunctionDoc.getRootElement();
            List malfunctionNodes = root.getChildren(MALFUNCTION);
            for (Element malfunctionElement : malfunctionNodes) {
                String name = "";
                try {
                    name = malfunctionElement.getAttributeValue(NAME);
                    Element severityElement = malfunctionElement.getChild(SEVERITY);
                    int severity = Integer.parseInt(severityElement.getAttributeValue(VALUE));
                    Element probabilityElement = malfunctionElement.getChild(PROBABILITY);
                    double probability = Double.parseDouble(probabilityElement.getAttributeValue(VALUE));
                    double repairTime = 0.0;
                    Element repairTimeElement = malfunctionElement.getChild(REPAIR_TIME);
                    if (repairTimeElement != null) {
                        repairTime = Double.parseDouble(repairTimeElement.getAttributeValue(VALUE));
                    }
                    double emergencyRepairTime = 0.0;
                    Element emergencyRepairTimeElement = malfunctionElement.getChild(EMERGENCY_REPAIR_TIME);
                    if (emergencyRepairTimeElement != null) {
                        emergencyRepairTime = Double.parseDouble(emergencyRepairTimeElement.getAttributeValue(VALUE));
                    }
                    double evaRepairTime = 0.0;
                    Element evaRepairTimeElement = malfunctionElement.getChild(EVA_REPAIR_TIME);
                    if (evaRepairTimeElement != null) {
                        evaRepairTime = Double.parseDouble(evaRepairTimeElement.getAttributeValue(VALUE));
                    }
                    ArrayList<String> entities = new ArrayList<String>();
                    Element entityListElement = malfunctionElement.getChild(ENTITY_LIST);
                    List entityNodes = entityListElement.getChildren(ENTITY);
                    for (Element entityElement : entityNodes) {
                        entities.add(entityElement.getAttributeValue(NAME));
                    }
                    HashMap<String, Double> lifeSupportEffects = new HashMap<String, Double>();
                    HashMap<AmountResource, Double> resourceEffects = new HashMap<AmountResource, Double>();
                    Element effectListElement = malfunctionElement.getChild(EFFECT_LIST);
                    if (effectListElement != null) {
                        List effectNodes = effectListElement.getChildren(EFFECT);
                        for (Element effectElement : effectNodes) {
                            String type = effectElement.getAttributeValue(TYPE);
                            String effectName = effectElement.getAttributeValue(NAME);
                            Double changeRate = new Double(effectElement.getAttributeValue(CHANGE_RATE));
                            if (type.equals("life-support")) {
                                lifeSupportEffects.put(effectName, changeRate);
                                continue;
                            }
                            if (type.equals("resource")) {
                                AmountResource resource = AmountResource.findAmountResource(effectName);
                                resourceEffects.put(resource, changeRate);
                                continue;
                            }
                            throw new IllegalStateException("Effect " + effectName + " type not correct in malfunction " + name);
                        }
                    }
                    HashMap<String, Double> medicalComplaints = new HashMap<String, Double>();
                    Element medicalComplaintListElement = malfunctionElement.getChild(MEDICAL_COMPLAINT_LIST);
                    if (medicalComplaintListElement != null) {
                        List medicalComplaintNodes = medicalComplaintListElement.getChildren(MEDICAL_COMPLAINT);
                        for (Element medicalComplaintElement : medicalComplaintNodes) {
                            String complaintName = medicalComplaintElement.getAttributeValue(NAME);
                            Double complaintProbability = new Double(medicalComplaintElement.getAttributeValue(PROBABILITY));
                            medicalComplaints.put(complaintName, complaintProbability);
                        }
                    }
                    Malfunction malfunction = new Malfunction(name, severity, probability, emergencyRepairTime, repairTime, evaRepairTime, entities, resourceEffects, lifeSupportEffects, medicalComplaints);
                    Element repairPartsListElement = malfunctionElement.getChild(REPAIR_PARTS_LIST);
                    if (repairPartsListElement != null) {
                        List partNodes = repairPartsListElement.getChildren(PART);
                        for (Element partElement : partNodes) {
                            String partName = partElement.getAttributeValue(NAME);
                            int partNumber = Integer.parseInt(partElement.getAttributeValue(NUMBER));
                            int partProbability = Integer.parseInt(partElement.getAttributeValue(PROBABILITY));
                            this.addMalfunctionRepairPart(name, partName, partNumber, partProbability);
                        }
                    }
                    this.malfunctionList.add(malfunction);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error reading malfunction " + name + ": " + e.getMessage(), e);
                }
            }
        }
        return this.malfunctionList;
    }

    private void addMalfunctionRepairPart(String malfunctionName, String partName, int number, int probability) {
        List<RepairPart> partList = this.repairParts.get(malfunctionName);
        if (partList == null) {
            partList = new ArrayList<RepairPart>();
            this.repairParts.put(malfunctionName, partList);
        }
        partList.add(new RepairPart(partName, number, probability));
    }

    public String[] getRepairPartNamesForMalfunction(String malfunctionName) {
        if (malfunctionName == null) {
            throw new IllegalArgumentException("malfunctionName is null");
        }
        List<RepairPart> partList = this.repairParts.get(malfunctionName);
        if (partList != null) {
            String[] partNames = new String[partList.size()];
            for (int x = 0; x < partList.size(); ++x) {
                partNames[x] = partList.get(x).name;
            }
            return partNames;
        }
        return new String[0];
    }

    public int getRepairPartNumber(String malfunctionName, String partName) {
        int result = 0;
        List<RepairPart> partList = this.repairParts.get(malfunctionName);
        if (partList != null) {
            for (RepairPart part : partList) {
                if (!part.name.equalsIgnoreCase(partName)) continue;
                result = part.number;
            }
        }
        return result;
    }

    public int getRepairPartProbability(String malfunctionName, String partName) {
        int result = 0;
        List<RepairPart> partList = this.repairParts.get(malfunctionName);
        if (partList != null) {
            for (RepairPart part : partList) {
                if (!part.name.equalsIgnoreCase(partName)) continue;
                result = part.probability;
            }
        }
        return result;
    }

    public void destroy() {
        this.malfunctionDoc = null;
        if (this.malfunctionList != null) {
            this.malfunctionList.clear();
            this.malfunctionList = null;
        }
        if (this.repairParts != null) {
            this.repairParts.clear();
            this.repairParts = null;
        }
    }

    private static class RepairPart
    implements Serializable {
        private String name;
        private int number;
        private int probability;

        private RepairPart(String name, int number, int probability) {
            this.name = name;
            this.number = number;
            this.probability = probability;
        }
    }
}

