/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.malfunction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionEvent;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.medical.Complaint;
import org.mars_sim.msp.core.person.medical.MedicalManager;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.time.MarsClock;

public class MalfunctionManager
implements Serializable {
    private static Logger logger = Logger.getLogger(MalfunctionManager.class.getName());
    public static final String MALFUNCTION_EVENT = "malfunction";
    private static double ESTIMATED_MALFUNCTIONS_PER_ORBIT = 10.0;
    private static double ESTIMATED_MAINTENANCES_PER_ORBIT = 10.0;
    private static double MAINTENANCE_MALFUNCTION_FACTOR = 1.0E-9;
    private static double WEAR_MALFUNCTION_FACTOR = 9.0;
    private static double WEAR_ACCIDENT_FACTOR = 1.0;
    private Malfunctionable entity;
    private double timeSinceLastMaintenance;
    private double effectiveTimeSinceLastMaintenance;
    private double maintenanceWorkTime;
    private double maintenanceTimeCompleted;
    private Collection<String> scope;
    private Collection<Malfunction> malfunctions;
    private Map<Part, Integer> partsNeededForMaintenance;
    private int numberMalfunctions;
    private int numberMaintenances;
    private double wearCondition;
    private double wearLifeTime;
    private double oxygenFlowModifier = 100.0;
    private double waterFlowModifier = 100.0;
    private double airPressureModifier = 100.0;
    private double temperatureModifier = 100.0;

    public MalfunctionManager(Malfunctionable entity, double wearLifeTime, double maintenanceWorkTime) {
        this.entity = entity;
        this.timeSinceLastMaintenance = 0.0;
        this.effectiveTimeSinceLastMaintenance = 0.0;
        this.scope = new ArrayList<String>();
        this.malfunctions = new ArrayList<Malfunction>();
        this.maintenanceWorkTime = maintenanceWorkTime;
        this.wearLifeTime = wearLifeTime;
        this.wearCondition = 100.0;
    }

    public void addScopeString(String scopeString) {
        if (scopeString != null && !this.scope.contains(scopeString)) {
            this.scope.add(scopeString);
        }
        this.determineNewMaintenanceParts();
    }

    public boolean hasMalfunction() {
        return this.malfunctions.size() > 0;
    }

    public boolean hasMalfunction(Malfunction malfunction) {
        return this.malfunctions.contains(malfunction);
    }

    public boolean hasEmergencyMalfunction() {
        boolean result = false;
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!(malfunction.getEmergencyWorkTime() - malfunction.getCompletedEmergencyWorkTime() > 0.0)) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean hasNormalMalfunction() {
        boolean result = false;
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!(malfunction.getWorkTime() - malfunction.getCompletedWorkTime() > 0.0)) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean hasEVAMalfunction() {
        boolean result = false;
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!(malfunction.getEVAWorkTime() - malfunction.getCompletedEVAWorkTime() > 0.0)) continue;
                result = true;
            }
        }
        return result;
    }

    public List<Malfunction> getMalfunctions() {
        return new ArrayList<Malfunction>(this.malfunctions);
    }

    public Malfunction getMostSeriousMalfunction() {
        Malfunction result = null;
        double highestSeverity = 0.0;
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!((double)malfunction.getSeverity() > highestSeverity) || malfunction.isFixed()) continue;
                highestSeverity = malfunction.getSeverity();
                result = malfunction;
            }
        }
        return result;
    }

    public Malfunction getMostSeriousEmergencyMalfunction() {
        Malfunction result = null;
        double highestSeverity = 0.0;
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!(malfunction.getEmergencyWorkTime() - malfunction.getCompletedEmergencyWorkTime() > 0.0) || !((double)malfunction.getSeverity() > highestSeverity)) continue;
                highestSeverity = malfunction.getSeverity();
                result = malfunction;
            }
        }
        return result;
    }

    public Malfunction getMostSeriousNormalMalfunction() {
        Malfunction result = null;
        double highestSeverity = 0.0;
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!(malfunction.getWorkTime() - malfunction.getCompletedWorkTime() > 0.0) || !((double)malfunction.getSeverity() > highestSeverity)) continue;
                highestSeverity = malfunction.getSeverity();
                result = malfunction;
            }
        }
        return result;
    }

    public List<Malfunction> getNormalMalfunctions() {
        ArrayList<Malfunction> result = new ArrayList<Malfunction>();
        for (Malfunction malfunction : this.malfunctions) {
            if (!(malfunction.getWorkTime() - malfunction.getCompletedWorkTime() > 0.0)) continue;
            result.add(malfunction);
        }
        Collections.sort(result, new MalfunctionSeverityComparator());
        return result;
    }

    public Malfunction getMostSeriousEVAMalfunction() {
        Malfunction result = null;
        double highestSeverity = 0.0;
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!(malfunction.getEVAWorkTime() - malfunction.getCompletedEVAWorkTime() > 0.0) || !((double)malfunction.getSeverity() > highestSeverity)) continue;
                highestSeverity = malfunction.getSeverity();
                result = malfunction;
            }
        }
        return result;
    }

    public List<Malfunction> getEVAMalfunctions() {
        ArrayList<Malfunction> result = new ArrayList<Malfunction>();
        for (Malfunction malfunction : this.malfunctions) {
            if (!(malfunction.getEVAWorkTime() - malfunction.getCompletedEVAWorkTime() > 0.0)) continue;
            result.add(malfunction);
        }
        Collections.sort(result, new MalfunctionSeverityComparator());
        return result;
    }

    private void addMalfunction() {
        MalfunctionFactory factory = Simulation.instance().getMalfunctionFactory();
        Malfunction malfunction = factory.getMalfunction(this.scope);
        if (malfunction != null) {
            this.addMalfunction(malfunction);
            ++this.numberMalfunctions;
        }
    }

    void addMalfunction(Malfunction malfunction) {
        if (malfunction == null) {
            throw new IllegalArgumentException("malfunction is null");
        }
        this.malfunctions.add(malfunction);
        try {
            this.getUnit().fireUnitUpdate(MALFUNCTION_EVENT, malfunction);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        MalfunctionEvent newEvent = new MalfunctionEvent(this.entity, malfunction, false);
        Simulation.instance().getEventManager().registerNewEvent(newEvent);
        this.issueMedicalComplaints(malfunction);
    }

    public void activeTimePassing(double time) {
        double wearFactor;
        double maintFactor;
        double chance;
        this.effectiveTimeSinceLastMaintenance += time;
        this.wearCondition -= time / this.wearLifeTime * 100.0;
        if (this.wearCondition < 0.0) {
            this.wearCondition = 0.0;
        }
        if (RandomUtil.lessThanRandPercent(chance = time * (maintFactor = this.effectiveTimeSinceLastMaintenance * MAINTENANCE_MALFUNCTION_FACTOR) * (wearFactor = (100.0 - this.wearCondition) / 100.0 * WEAR_MALFUNCTION_FACTOR + 1.0))) {
            int solsLastMaint = (int)(this.effectiveTimeSinceLastMaintenance / 1000.0);
            logger.info(this.entity.getName() + " has maintenance-triggered malfunction: " + "time since late maintenance: " + solsLastMaint + " Sols.");
            this.addMalfunction();
        }
    }

    public void timePassing(double time) {
        ArrayList<Malfunction> fixedMalfunctions = new ArrayList<Malfunction>();
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!malfunction.isFixed()) continue;
                fixedMalfunctions.add(malfunction);
            }
        }
        if (fixedMalfunctions.size() > 0) {
            for (Malfunction item : fixedMalfunctions) {
                this.malfunctions.remove(item);
                try {
                    this.getUnit().fireUnitUpdate(MALFUNCTION_EVENT, item);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                MalfunctionEvent newEvent = new MalfunctionEvent(this.entity, item, true);
                Simulation.instance().getEventManager().registerNewEvent(newEvent);
            }
        }
        this.setLifeSupportModifiers(time);
        try {
            this.depleteResources(time);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.timeSinceLastMaintenance += time;
    }

    public void setLifeSupportModifiers(double time) {
        double tempOxygenFlowModifier = 0.0;
        double tempWaterFlowModifier = 0.0;
        double tempAirPressureModifier = 0.0;
        double tempTemperatureModifier = 0.0;
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!(malfunction.getEmergencyWorkTime() > malfunction.getCompletedEmergencyWorkTime())) continue;
                Map<String, Double> effects = malfunction.getLifeSupportEffects();
                if (effects.get("Oxygen") != null) {
                    tempOxygenFlowModifier += effects.get("Oxygen").doubleValue();
                }
                if (effects.get("Water") != null) {
                    tempWaterFlowModifier += effects.get("Water").doubleValue();
                }
                if (effects.get("Air Pressure") != null) {
                    tempAirPressureModifier += effects.get("Air Pressure").doubleValue();
                }
                if (effects.get("Temperature") == null) continue;
                tempTemperatureModifier += effects.get("Temperature").doubleValue();
            }
        }
        this.oxygenFlowModifier = tempOxygenFlowModifier < 0.0 ? (this.oxygenFlowModifier += tempOxygenFlowModifier * time) : 100.0;
        this.waterFlowModifier = tempWaterFlowModifier < 0.0 ? (this.waterFlowModifier += tempWaterFlowModifier * time) : 100.0;
        this.airPressureModifier = tempAirPressureModifier < 0.0 ? (this.airPressureModifier += tempAirPressureModifier * time) : 100.0;
        this.temperatureModifier = tempTemperatureModifier != 0.0 ? (this.temperatureModifier += tempTemperatureModifier * time) : 100.0;
    }

    public void depleteResources(double time) {
        if (this.hasMalfunction()) {
            for (Malfunction malfunction : this.malfunctions) {
                if (!(malfunction.getEmergencyWorkTime() > malfunction.getCompletedEmergencyWorkTime())) continue;
                Map<AmountResource, Double> effects = malfunction.getResourceEffects();
                for (AmountResource resource : effects.keySet()) {
                    double amount = effects.get(resource);
                    double amountDepleted = amount * time;
                    Inventory inv = this.entity.getInventory();
                    double amountStored = inv.getAmountResourceStored(resource, false);
                    if (amountStored < amountDepleted) {
                        amountDepleted = amountStored;
                    }
                    if (!(amountDepleted >= 0.0)) continue;
                    inv.retrieveAmountResource(resource, amountDepleted);
                }
            }
        }
    }

    public void accident() {
        logger.info(this.entity.getName() + " accident()");
        boolean done = false;
        double chance = 100.0;
        while (!done) {
            if (RandomUtil.lessThanRandPercent(chance)) {
                this.addMalfunction();
                chance /= 2.0;
                continue;
            }
            done = true;
        }
        Collection<Person> people = this.entity.getAffectedPeople();
        Iterator<Person> i = people.iterator();
        while (i.hasNext()) {
            PhysicalCondition condition = i.next().getPhysicalCondition();
            condition.setStress(condition.getStress() + 40.0);
        }
    }

    public double getTimeSinceLastMaintenance() {
        return this.timeSinceLastMaintenance;
    }

    public double getEffectiveTimeSinceLastMaintenance() {
        return this.effectiveTimeSinceLastMaintenance;
    }

    public double getMaintenanceWorkTime() {
        return this.maintenanceWorkTime;
    }

    public void setMaintenanceWorkTime(double maintenanceWorkTime) {
        this.maintenanceWorkTime = maintenanceWorkTime;
    }

    public double getMaintenanceWorkTimeCompleted() {
        return this.maintenanceTimeCompleted;
    }

    public void addMaintenanceWorkTime(double time) {
        this.maintenanceTimeCompleted += time;
        if (this.maintenanceTimeCompleted >= this.maintenanceWorkTime) {
            this.maintenanceTimeCompleted = 0.0;
            this.timeSinceLastMaintenance = 0.0;
            this.effectiveTimeSinceLastMaintenance = 0.0;
            this.determineNewMaintenanceParts();
            ++this.numberMaintenances;
        }
    }

    public void issueMedicalComplaints(Malfunction malfunction) {
        for (String complaintName : malfunction.getMedicalComplaints().keySet()) {
            double probability = malfunction.getMedicalComplaints().get(complaintName);
            MedicalManager medic = Simulation.instance().getMedicalManager();
            Complaint complaint = medic.getComplaintByName(complaintName);
            if (complaint == null) continue;
            for (Person person : this.entity.getAffectedPeople()) {
                if (!RandomUtil.lessThanRandPercent(probability)) continue;
                person.getPhysicalCondition().addMedicalComplaint(complaint);
                person.fireUnitUpdate("illness event");
            }
        }
    }

    public double getOxygenFlowModifier() {
        return this.oxygenFlowModifier;
    }

    public double getWaterFlowModifier() {
        return this.waterFlowModifier;
    }

    public double getAirPressureModifier() {
        return this.airPressureModifier;
    }

    public double getTemperatureModifier() {
        return this.temperatureModifier;
    }

    private Unit getUnit() {
        if (this.entity instanceof Unit) {
            return (Unit)((Object)this.entity);
        }
        if (this.entity instanceof Building) {
            return ((Building)this.entity).getBuildingManager().getSettlement();
        }
        throw new IllegalStateException("Could not find unit associated with malfunctionable.");
    }

    private void determineNewMaintenanceParts() {
        if (this.partsNeededForMaintenance == null) {
            this.partsNeededForMaintenance = new HashMap<Part, Integer>();
        }
        this.partsNeededForMaintenance.clear();
        for (String entity : this.scope) {
            for (Part part : Part.getParts()) {
                if (!part.hasMaintenanceEntity(entity) || !RandomUtil.lessThanRandPercent(part.getMaintenanceProbability(entity))) continue;
                int number = RandomUtil.getRandomRegressionInteger(part.getMaintenanceMaximumNumber(entity));
                if (this.partsNeededForMaintenance.containsKey(part)) {
                    number += this.partsNeededForMaintenance.get(part).intValue();
                }
                this.partsNeededForMaintenance.put(part, number);
            }
        }
    }

    public Map<Part, Integer> getMaintenanceParts() {
        if (this.partsNeededForMaintenance == null) {
            this.partsNeededForMaintenance = new HashMap<Part, Integer>();
        }
        return new HashMap<Part, Integer>(this.partsNeededForMaintenance);
    }

    public void maintainWithParts(Part part, int number) {
        if (part == null) {
            throw new IllegalArgumentException("part is null");
        }
        if (this.partsNeededForMaintenance.containsKey(part)) {
            int numberNeeded = this.partsNeededForMaintenance.get(part);
            if (number > numberNeeded) {
                throw new IllegalArgumentException("number " + number + " is greater that number of parts needed: " + numberNeeded);
            }
            if ((numberNeeded -= number) > 0) {
                this.partsNeededForMaintenance.put(part, numberNeeded);
            } else {
                this.partsNeededForMaintenance.remove(part);
            }
        } else {
            throw new IllegalArgumentException("Part " + part + " is not needed for maintenance.");
        }
    }

    public Map<Part, Double> getRepairPartProbabilities() {
        MalfunctionFactory factory = Simulation.instance().getMalfunctionFactory();
        return factory.getRepairPartProbabilities(this.scope);
    }

    public Map<Part, Double> getMaintenancePartProbabilities() {
        MalfunctionFactory factory = Simulation.instance().getMalfunctionFactory();
        return factory.getMaintenancePartProbabilities(this.scope);
    }

    public double getEstimatedNumberOfMalfunctionsPerOrbit() {
        MarsClock startTime = Simulation.instance().getMasterClock().getInitialMarsTime();
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        double totalTimeMillisols = MarsClock.getTimeDiff(currentTime, startTime);
        double totalTimeOrbits = totalTimeMillisols / 1000.0 / 668.0;
        double avgMalfunctionsPerOrbit = 0.0;
        avgMalfunctionsPerOrbit = totalTimeOrbits < 1.0 ? ((double)this.numberMalfunctions + ESTIMATED_MALFUNCTIONS_PER_ORBIT) / 2.0 : (double)this.numberMalfunctions / totalTimeOrbits;
        return avgMalfunctionsPerOrbit;
    }

    public double getEstimatedNumberOfMaintenancesPerOrbit() {
        MarsClock startTime = Simulation.instance().getMasterClock().getInitialMarsTime();
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        double totalTimeMillisols = MarsClock.getTimeDiff(currentTime, startTime);
        double totalTimeOrbits = totalTimeMillisols / 1000.0 / 668.0;
        double avgMaintenancesPerOrbit = 0.0;
        avgMaintenancesPerOrbit = totalTimeOrbits < 1.0 ? ((double)this.numberMaintenances + ESTIMATED_MAINTENANCES_PER_ORBIT) / 2.0 : (double)this.numberMaintenances / totalTimeOrbits;
        return avgMaintenancesPerOrbit;
    }

    public double getWearCondition() {
        return this.wearCondition;
    }

    public double getWearConditionAccidentModifier() {
        return (100.0 - this.wearCondition) / 100.0 * WEAR_ACCIDENT_FACTOR + 1.0;
    }

    public void destroy() {
        this.entity = null;
        this.scope.clear();
        this.scope = null;
        this.malfunctions.clear();
        this.malfunctions = null;
        this.partsNeededForMaintenance.clear();
        this.partsNeededForMaintenance = null;
    }

    private static class MalfunctionSeverityComparator
    implements Comparator<Malfunction>,
    Serializable {
        private MalfunctionSeverityComparator() {
        }

        @Override
        public int compare(Malfunction malfunction1, Malfunction malfunction2) {
            int severity2;
            int severity1 = malfunction1.getSeverity();
            if (severity1 > (severity2 = malfunction2.getSeverity())) {
                return -1;
            }
            if (severity1 == severity2) {
                return 0;
            }
            return 1;
        }
    }
}

