/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.manufacture;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.manufacture.ManufactureProcessInfo;
import org.mars_sim.msp.core.manufacture.ManufactureProcessItem;
import org.mars_sim.msp.core.manufacture.PartSalvage;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;

public class ManufactureConfig
implements Serializable {
    private static final String PROCESS = "process";
    private static final String NAME = "name";
    private static final String TECH = "tech";
    private static final String SKILL = "skill";
    private static final String WORK_TIME = "work-time";
    private static final String PROCESS_TIME = "process-time";
    private static final String POWER_REQUIRED = "power-required";
    private static final String INPUTS = "inputs";
    private static final String OUTPUTS = "outputs";
    private static final String RESOURCE = "resource";
    private static final String AMOUNT = "amount";
    private static final String PART = "part";
    private static final String NUMBER = "number";
    private static final String EQUIPMENT = "equipment";
    private static final String VEHICLE = "vehicle";
    private static final String SALVAGE = "salvage";
    private static final String ITEM_NAME = "item-name";
    private static final String TYPE = "type";
    private static final String PART_SALVAGE = "part-salvage";
    private Document manufactureDoc;
    private List<ManufactureProcessInfo> manufactureProcessList;
    private List<SalvageProcessInfo> salvageList;

    public ManufactureConfig(Document manufactureDoc) {
        this.manufactureDoc = manufactureDoc;
    }

    List<ManufactureProcessInfo> getManufactureProcessList() {
        if (this.manufactureProcessList == null) {
            Element root = this.manufactureDoc.getRootElement();
            List processNodes = root.getChildren(PROCESS);
            this.manufactureProcessList = new ArrayList<ManufactureProcessInfo>(processNodes.size());
            for (Element processElement : processNodes) {
                ManufactureProcessInfo process = new ManufactureProcessInfo();
                this.manufactureProcessList.add(process);
                String name = "";
                name = processElement.getAttributeValue(NAME);
                process.setName(name);
                process.setTechLevelRequired(Integer.parseInt(processElement.getAttributeValue(TECH)));
                process.setSkillLevelRequired(Integer.parseInt(processElement.getAttributeValue(SKILL)));
                process.setWorkTimeRequired(Double.parseDouble(processElement.getAttributeValue(WORK_TIME)));
                process.setProcessTimeRequired(Double.parseDouble(processElement.getAttributeValue(PROCESS_TIME)));
                process.setPowerRequired(Double.parseDouble(processElement.getAttributeValue(POWER_REQUIRED)));
                Element inputs = processElement.getChild(INPUTS);
                ArrayList<ManufactureProcessItem> inputList = new ArrayList<ManufactureProcessItem>();
                process.setInputList(inputList);
                this.parseResources(inputList, inputs.getChildren(RESOURCE));
                this.parseParts(inputList, inputs.getChildren(PART));
                this.parseEquipment(inputList, inputs.getChildren(EQUIPMENT));
                this.parseVehicles(inputList, inputs.getChildren(VEHICLE));
                Element outputs = processElement.getChild(OUTPUTS);
                ArrayList<ManufactureProcessItem> outputList = new ArrayList<ManufactureProcessItem>();
                process.setOutputList(outputList);
                this.parseResources(outputList, outputs.getChildren(RESOURCE));
                this.parseParts(outputList, outputs.getChildren(PART));
                this.parseEquipment(outputList, outputs.getChildren(EQUIPMENT));
                this.parseVehicles(outputList, outputs.getChildren(VEHICLE));
            }
        }
        return this.manufactureProcessList;
    }

    private void parseResources(List<ManufactureProcessItem> list, List<Element> resourceNodes) {
        for (Element resourceElement : resourceNodes) {
            ManufactureProcessItem resourceItem = new ManufactureProcessItem();
            resourceItem.setType(RESOURCE);
            resourceItem.setName(resourceElement.getAttributeValue(NAME));
            resourceItem.setAmount(Double.parseDouble(resourceElement.getAttributeValue(AMOUNT)));
            list.add(resourceItem);
        }
    }

    private void parseParts(List<ManufactureProcessItem> list, List<Element> partNodes) {
        for (Element partElement : partNodes) {
            ManufactureProcessItem partItem = new ManufactureProcessItem();
            partItem.setType(PART);
            partItem.setName(partElement.getAttributeValue(NAME));
            partItem.setAmount(Integer.parseInt(partElement.getAttributeValue(NUMBER)));
            list.add(partItem);
        }
    }

    private void parseEquipment(List<ManufactureProcessItem> list, List<Element> equipmentNodes) {
        for (Element equipmentElement : equipmentNodes) {
            ManufactureProcessItem equipmentItem = new ManufactureProcessItem();
            equipmentItem.setType(EQUIPMENT);
            equipmentItem.setName(equipmentElement.getAttributeValue(NAME));
            equipmentItem.setAmount(Integer.parseInt(equipmentElement.getAttributeValue(NUMBER)));
            list.add(equipmentItem);
        }
    }

    private void parseVehicles(List<ManufactureProcessItem> list, List<Element> vehicleNodes) {
        for (Element vehicleElement : vehicleNodes) {
            ManufactureProcessItem vehicleItem = new ManufactureProcessItem();
            vehicleItem.setType(VEHICLE);
            vehicleItem.setName(vehicleElement.getAttributeValue(NAME));
            vehicleItem.setAmount(Integer.parseInt(vehicleElement.getAttributeValue(NUMBER)));
            list.add(vehicleItem);
        }
    }

    List<SalvageProcessInfo> getSalvageList() {
        if (this.salvageList == null) {
            Element root = this.manufactureDoc.getRootElement();
            List salvageNodes = root.getChildren(SALVAGE);
            this.salvageList = new ArrayList<SalvageProcessInfo>(salvageNodes.size());
            for (Element salvageElement : salvageNodes) {
                SalvageProcessInfo salvage = new SalvageProcessInfo();
                this.salvageList.add(salvage);
                String itemName = "";
                itemName = salvageElement.getAttributeValue(ITEM_NAME);
                salvage.setItemName(itemName);
                salvage.setType(salvageElement.getAttributeValue(TYPE));
                salvage.setTechLevelRequired(Integer.parseInt(salvageElement.getAttributeValue(TECH)));
                salvage.setSkillLevelRequired(Integer.parseInt(salvageElement.getAttributeValue(SKILL)));
                salvage.setWorkTimeRequired(Double.parseDouble(salvageElement.getAttributeValue(WORK_TIME)));
                List partSalvageNodes = salvageElement.getChildren(PART_SALVAGE);
                ArrayList<PartSalvage> partSalvageList = new ArrayList<PartSalvage>(partSalvageNodes.size());
                salvage.setPartSalvageList(partSalvageList);
                for (Element partSalvageElement : partSalvageNodes) {
                    PartSalvage part = new PartSalvage();
                    partSalvageList.add(part);
                    part.setName(partSalvageElement.getAttributeValue(NAME));
                    part.setNumber(Integer.parseInt(partSalvageElement.getAttributeValue(NUMBER)));
                }
            }
        }
        return this.salvageList;
    }

    public void destroy() {
        this.manufactureDoc = null;
        if (this.manufactureProcessList != null) {
            Iterator<ManufactureProcessInfo> i = this.manufactureProcessList.iterator();
            while (i.hasNext()) {
                i.next().destroy();
            }
            this.manufactureProcessList.clear();
            this.manufactureProcessList = null;
        }
        if (this.salvageList != null) {
            Iterator<SalvageProcessInfo> j = this.salvageList.iterator();
            while (j.hasNext()) {
                j.next().destroy();
            }
            this.salvageList.clear();
            this.salvageList = null;
        }
    }
}

