/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.manufacture;

import java.io.Serializable;
import org.mars_sim.msp.core.manufacture.ManufactureProcessInfo;
import org.mars_sim.msp.core.structure.building.function.Manufacture;

public class ManufactureProcess
implements Serializable {
    private Manufacture workshop;
    private ManufactureProcessInfo info;
    private double workTimeRemaining;
    private double processTimeRemaining;

    public ManufactureProcess(ManufactureProcessInfo info, Manufacture workshop) {
        this.info = info;
        this.workshop = workshop;
        this.workTimeRemaining = info.getWorkTimeRequired();
        this.processTimeRemaining = info.getProcessTimeRequired();
    }

    public ManufactureProcessInfo getInfo() {
        return this.info;
    }

    public double getWorkTimeRemaining() {
        return this.workTimeRemaining;
    }

    public void addWorkTime(double workTime) {
        this.workTimeRemaining -= workTime;
        if (this.workTimeRemaining < 0.0) {
            this.workTimeRemaining = 0.0;
        }
    }

    public double getProcessTimeRemaining() {
        return this.processTimeRemaining;
    }

    public void addProcessTime(double processTime) {
        this.processTimeRemaining -= processTime;
        if (this.processTimeRemaining < 0.0) {
            this.processTimeRemaining = 0.0;
        }
    }

    public String toString() {
        return this.info.getName();
    }

    public Manufacture getWorkshop() {
        return this.workshop;
    }

    public void destroy() {
        this.workshop = null;
        this.info.destroy();
        this.info = null;
    }
}

