/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.mars;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.mars_sim.msp.core.Coordinates;

public class AreothermalMap
implements Serializable {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.mars.AreothermalMap";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private static final String AREOTHERMAL_MAP_NAME = "TopographyVolcanic.png";
    private Set<Coordinates> hotspots;
    private Map<Coordinates, Double> areothermalPotentialCache;

    public AreothermalMap() {
        this.loadHotspots();
    }

    private void loadHotspots() {
        this.hotspots = new HashSet<Coordinates>(700);
        URL imageMapURL = this.getClass().getResource("/images/TopographyVolcanic.png");
        ImageIcon mapIcon = new ImageIcon(imageMapURL);
        Image mapImage = mapIcon.getImage();
        int[] mapPixels = new int[45000];
        PixelGrabber grabber = new PixelGrabber(mapImage, 0, 0, 300, 150, mapPixels, 0, 300);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "grabber error" + e);
        }
        if ((grabber.status() & 0x80) != 0) {
            logger.info("grabber error");
        }
        for (int x = 0; x < 150; ++x) {
            for (int y = 0; y < 300; ++y) {
                int pixel = mapPixels[x * 300 + y];
                Color color = new Color(pixel);
                if (!Color.white.equals(color)) continue;
                double pixel_offset = 0.010471975511965976;
                double phi = (double)x / 150.0 * Math.PI + pixel_offset;
                double theta = (double)y / 150.0 * Math.PI + Math.PI + pixel_offset;
                if (theta > Math.PI * 2) {
                    theta -= Math.PI * 2;
                }
                this.hotspots.add(new Coordinates(phi, theta));
            }
        }
    }

    public double getAreothermalPotential(Coordinates location) {
        double result = 0.0;
        if (this.hotspots == null) {
            this.loadHotspots();
        }
        if (this.areothermalPotentialCache == null) {
            this.areothermalPotentialCache = new HashMap<Coordinates, Double>();
        }
        if (this.areothermalPotentialCache.containsKey(location)) {
            result = this.areothermalPotentialCache.get(location);
        } else {
            Iterator<Coordinates> i = this.hotspots.iterator();
            while (i.hasNext()) {
                double T;
                double pixelRadius;
                double a = 25.0;
                double b = 15.0;
                Coordinates hotspot = i.next();
                double distance = location.getDistance(hotspot);
                double expo = (distance - (pixelRadius = 35.53141291210056)) / (T = pixelRadius);
                double heat = 100.0 - a * Math.pow(b, expo);
                if (heat < 0.0) {
                    heat = 0.0;
                }
                result += heat;
            }
            if (result > 100.0) {
                result = 100.0;
            }
            if (result < 0.0) {
                result = 0.0;
            }
            this.areothermalPotentialCache.put(new Coordinates(location), result);
        }
        return result;
    }

    public void destroy() {
        this.hotspots.clear();
        this.hotspots = null;
        if (this.areothermalPotentialCache != null) {
            this.areothermalPotentialCache.clear();
            this.areothermalPotentialCache = null;
        }
    }
}

