/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.mars;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.mars.Landmark;

public class LandmarkConfig
implements Serializable {
    private static final String LANDMARK = "landmark";
    private static final String NAME = "name";
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private Document landmarkDoc;
    private List<Landmark> landmarkList;

    public LandmarkConfig(Document landmarkDoc) {
        this.landmarkDoc = landmarkDoc;
    }

    public List<Landmark> getLandmarkList() {
        if (this.landmarkList == null) {
            this.landmarkList = new ArrayList<Landmark>();
            Element root = this.landmarkDoc.getRootElement();
            List landmarks = root.getChildren(LANDMARK);
            for (Element landmark : landmarks) {
                String name = "";
                name = landmark.getAttributeValue(NAME);
                String latitude = landmark.getAttributeValue(LATITUDE);
                String longitude = landmark.getAttributeValue(LONGITUDE);
                Coordinates location = new Coordinates(latitude, longitude);
                this.landmarkList.add(new Landmark(name, location));
            }
        }
        return this.landmarkList;
    }

    public void destroy() {
        this.landmarkDoc = null;
        if (this.landmarkList != null) {
            this.landmarkList.clear();
            this.landmarkList = null;
        }
    }
}

