/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.mars;

import java.io.Serializable;
import org.mars_sim.msp.core.mars.OrbitInfo;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.mars.Weather;

public class Mars
implements Serializable {
    public static final double MARS_RADIUS_KM = 3393.0;
    public static final double MARS_CIRCUMFERENCE = 21318.847747260337;
    private SurfaceFeatures surfaceFeatures = new SurfaceFeatures();
    private OrbitInfo orbitInfo = new OrbitInfo();
    private Weather weather = new Weather();

    public void initializeTransientData() {
        this.surfaceFeatures.initializeTransientData();
    }

    public OrbitInfo getOrbitInfo() {
        return this.orbitInfo;
    }

    public SurfaceFeatures getSurfaceFeatures() {
        return this.surfaceFeatures;
    }

    public Weather getWeather() {
        return this.weather;
    }

    public void timePassing(double time) {
        this.orbitInfo.addTime(time);
        this.surfaceFeatures.timePassing(time);
    }

    public void destroy() {
        this.surfaceFeatures.destroy();
        this.orbitInfo.destroy();
        this.weather.destroy();
    }
}

