/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.mars;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class MineralMapConfig
implements Serializable {
    private static final String MINERAL = "mineral";
    private static final String NAME = "name";
    private static final String FREQUENCY = "frequency";
    private static final String LOCALE_LIST = "locale-list";
    private static final String LOCALE = "locale";
    private Document mineralDoc;
    private List<MineralType> mineralTypes;

    public MineralMapConfig(Document mineralDoc) {
        this.mineralDoc = mineralDoc;
    }

    List<MineralType> getMineralTypes() {
        if (this.mineralTypes != null) {
            return this.mineralTypes;
        }
        this.mineralTypes = new ArrayList<MineralType>();
        Element root = this.mineralDoc.getRootElement();
        List minerals = root.getChildren(MINERAL);
        for (Element mineral : minerals) {
            String name = "";
            name = mineral.getAttributeValue(NAME).toLowerCase().trim();
            String frequency = mineral.getAttributeValue(FREQUENCY).toLowerCase().trim();
            MineralType mineralType = new MineralType(name, frequency);
            Element localeList = mineral.getChild(LOCALE_LIST);
            List locales = localeList.getChildren(LOCALE);
            for (Element locale : locales) {
                String localeName = locale.getAttributeValue(NAME).toLowerCase().trim();
                mineralType.addLocale(localeName);
            }
            this.mineralTypes.add(mineralType);
        }
        return this.mineralTypes;
    }

    public void destroy() {
        this.mineralDoc = null;
        if (this.mineralTypes != null) {
            this.mineralTypes.clear();
            this.mineralTypes = null;
        }
    }

    static class MineralType
    implements Serializable {
        String name;
        String frequency;
        List<String> locales;

        private MineralType(String name, String frequency) {
            this.name = name;
            this.frequency = frequency;
            this.locales = new ArrayList<String>(3);
        }

        private void addLocale(String localeName) {
            this.locales.add(localeName);
        }
    }
}

