/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.mars;

import java.io.Serializable;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.time.MarsClock;

public class OrbitInfo
implements Serializable {
    private static final double ORBIT_PERIOD = 5.9355072E7;
    private static final double ECCENTRICITY = 0.093;
    private static final double TILT = 0.4396;
    private static final double SOLAR_DAY = 88775.244;
    private static final double ORBIT_AREA = 9.5340749;
    private double orbitTime = 0.0;
    private double theta = 0.0;
    private double radius = 1.665732;
    private Coordinates sunDirection = new Coordinates(2.0103963267948965, Math.PI);

    public void addTime(double millisols) {
        double seconds = MarsClock.convertMillisolsToSeconds(millisols);
        this.orbitTime += seconds;
        while (this.orbitTime > 5.9355072E7) {
            this.orbitTime -= 5.9355072E7;
        }
        double area = 9.5340749 * this.orbitTime / 5.9355072E7;
        double areaTemp = 0.0;
        areaTemp = area > 4.76703745 ? area - 4.76703745 : 4.76703745 - area;
        this.theta = Math.abs(2.0 * Math.atan(1.097757562 * Math.tan(0.329512059 * areaTemp)));
        if (area < 4.76703745) {
            this.theta = 0.0 - this.theta;
        }
        this.theta += Math.PI;
        if (this.theta >= Math.PI * 2) {
            this.theta -= Math.PI * 2;
        }
        this.radius = 1.510818924 / (1.0 + 0.093 * Math.cos(this.theta));
        double sunTheta = this.sunDirection.getTheta();
        sunTheta -= Math.PI * 2 * (seconds / 88775.244);
        while (sunTheta < 0.0) {
            sunTheta += Math.PI * 2;
        }
        this.sunDirection.setTheta(sunTheta);
        double sunPhi = 1.5707963267948966 + Math.sin(this.theta + 1.5707963267948966) * 0.4396;
        this.sunDirection.setPhi(sunPhi);
    }

    public double getTheta() {
        return this.theta;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getDistanceToSun() {
        return this.radius;
    }

    public double getSunAngleFromPhi(double phi) {
        return Math.abs(phi - this.sunDirection.getPhi());
    }

    public Coordinates getSunDirection() {
        return this.sunDirection;
    }

    public void destroy() {
        this.sunDirection = null;
    }
}

