/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.mars;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.mars.MineralMap;
import org.mars_sim.msp.core.mars.MineralMapConfig;

public class RandomMineralMap
implements Serializable,
MineralMap {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.mars.RandomMineralMap";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private static final String CRATER_REGION = "crater";
    private static final String VOLCANIC_REGION = "volcanic";
    private static final String SEDIMENTARY_REGION = "sedimentary";
    private static final String COMMON_FREQUENCY = "common";
    private static final String UNCOMMON_FREQUENCY = "uncommon";
    private static final String RARE_FREQUENCY = "rare";
    private static final String VERY_RARE_FREQUENCY = "very rare";
    private List<MineralConcentration> mineralConcentrations = new ArrayList<MineralConcentration>(2000);

    RandomMineralMap() {
        this.determineMineralConcentrations();
    }

    private void determineMineralConcentrations() {
        Set<Coordinates> craterRegionSet = this.getTopoRegionSet("TopographyCrater.png");
        Set<Coordinates> volcanicRegionSet = this.getTopoRegionSet("TopographyVolcanic.png");
        Set<Coordinates> sedimentaryRegionSet = this.getTopoRegionSet("TopographySedimentary.png");
        MineralMapConfig config = SimulationConfig.instance().getMineralMapConfiguration();
        try {
            for (MineralMapConfig.MineralType mineralType : config.getMineralTypes()) {
                int x;
                int concentrationNumber;
                HashSet<Coordinates> regionSet = new HashSet<Coordinates>(4000);
                Iterator<String> j = mineralType.locales.iterator();
                while (j.hasNext()) {
                    String locale = j.next().trim();
                    if (CRATER_REGION.equalsIgnoreCase(locale)) {
                        regionSet.addAll(craterRegionSet);
                        continue;
                    }
                    if (VOLCANIC_REGION.equalsIgnoreCase(locale)) {
                        regionSet.addAll(volcanicRegionSet);
                        continue;
                    }
                    if (!SEDIMENTARY_REGION.equalsIgnoreCase(locale)) continue;
                    regionSet.addAll(sedimentaryRegionSet);
                }
                Coordinates[] regionArray = regionSet.toArray(new Coordinates[regionSet.size()]);
                if (regionArray.length > 0) {
                    concentrationNumber = Math.round((float)regionArray.length / 10.0f / this.getFrequencyModifier(mineralType.frequency));
                    for (x = 0; x < concentrationNumber; ++x) {
                        int regionLocationIndex = RandomUtil.getRandomInt(regionArray.length - 1);
                        Coordinates regionLocation = regionArray[regionLocationIndex];
                        Direction direction = new Direction(RandomUtil.getRandomDouble(Math.PI * 2));
                        double pixelRadius = 35.53141291210056;
                        double distance = RandomUtil.getRandomDouble(pixelRadius);
                        Coordinates location = regionLocation.getNewLocation(direction, distance);
                        double concentration = RandomUtil.getRandomDouble(100.0);
                        this.mineralConcentrations.add(new MineralConcentration(location, concentration, mineralType.name));
                    }
                    continue;
                }
                concentrationNumber = Math.round(100.0f / this.getFrequencyModifier(mineralType.frequency));
                for (x = 0; x < concentrationNumber; ++x) {
                    double phi = Coordinates.getRandomLatitude();
                    double theta = Coordinates.getRandomLongitude();
                    Coordinates location = new Coordinates(phi, theta);
                    double concentration = RandomUtil.getRandomDouble(100.0);
                    this.mineralConcentrations.add(new MineralConcentration(location, concentration, mineralType.name));
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating random mineral map.", e);
            e.printStackTrace();
        }
    }

    private float getFrequencyModifier(String frequency) {
        float result = 1.0f;
        if (COMMON_FREQUENCY.equalsIgnoreCase(frequency.trim())) {
            result = 1.0f;
        } else if (UNCOMMON_FREQUENCY.equalsIgnoreCase(frequency.trim())) {
            result = 5.0f;
        } else if (RARE_FREQUENCY.equalsIgnoreCase(frequency.trim())) {
            result = 10.0f;
        } else if (VERY_RARE_FREQUENCY.equalsIgnoreCase(frequency.trim())) {
            result = 15.0f;
        }
        return result;
    }

    private Set<Coordinates> getTopoRegionSet(String imageMapName) {
        HashSet<Coordinates> result = new HashSet<Coordinates>(3000);
        URL imageMapURL = this.getClass().getResource("/images/" + imageMapName);
        ImageIcon mapIcon = new ImageIcon(imageMapURL);
        Image mapImage = mapIcon.getImage();
        int[] mapPixels = new int[45000];
        PixelGrabber topoGrabber = new PixelGrabber(mapImage, 0, 0, 300, 150, mapPixels, 0, 300);
        try {
            topoGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "grabber error" + e);
        }
        if ((topoGrabber.status() & 0x80) != 0) {
            logger.info("grabber error");
        }
        for (int x = 0; x < 150; ++x) {
            for (int y = 0; y < 300; ++y) {
                int pixel = mapPixels[x * 300 + y];
                Color color = new Color(pixel);
                if (!Color.white.equals(color)) continue;
                double pixel_offset = 0.010471975511965976;
                double phi = (double)x / 150.0 * Math.PI + pixel_offset;
                double theta = (double)y / 150.0 * Math.PI + Math.PI + pixel_offset;
                if (theta > Math.PI * 2) {
                    theta -= Math.PI * 2;
                }
                result.add(new Coordinates(phi, theta));
            }
        }
        return result;
    }

    @Override
    public Map<String, Double> getAllMineralConcentrations(Coordinates location) {
        Map<String, Double> result = Collections.emptyMap();
        boolean emptyMap = true;
        for (MineralConcentration mineralConcentration : this.mineralConcentrations) {
            double effect = this.getMineralConcentrationEffect(mineralConcentration, location);
            if (!(effect > 0.0)) continue;
            if (emptyMap) {
                result = new HashMap<String, Double>();
                emptyMap = false;
            }
            double totalConcentration = 0.0;
            if (result.containsKey(mineralConcentration.mineralType)) {
                totalConcentration = result.get(mineralConcentration.mineralType);
            }
            if ((totalConcentration += effect) > 100.0) {
                totalConcentration = 100.0;
            }
            result.put(mineralConcentration.mineralType, totalConcentration);
        }
        return result;
    }

    @Override
    public double getMineralConcentration(String mineralType, Coordinates location) {
        double result = 0.0;
        for (MineralConcentration mineralConcentration : this.mineralConcentrations) {
            if (!mineralConcentration.getMineralType().equalsIgnoreCase(mineralType) || !((result += this.getMineralConcentrationEffect(mineralConcentration, location)) > 100.0)) continue;
            result = 100.0;
        }
        return result;
    }

    private double getMineralConcentrationEffect(MineralConcentration concentration, Coordinates location) {
        double concentrationRange;
        double distance;
        double result = 0.0;
        double concentrationPhi = concentration.getLocation().getPhi();
        double concentrationTheta = concentration.getLocation().getTheta();
        double phiDiff = Math.abs(location.getPhi() - concentrationPhi);
        double thetaDiff = Math.abs(location.getTheta() - concentrationTheta);
        double diffLimit = 0.04;
        if (concentrationPhi < 0.4487989505128276 || concentrationPhi > 2.6927937030769655) {
            diffLimit += Math.abs(Math.cos(concentrationPhi));
        }
        if (phiDiff < diffLimit && thetaDiff < diffLimit && (distance = location.getDistance(concentration.getLocation())) < (concentrationRange = concentration.getConcentration())) {
            result = (1.0 - distance / concentrationRange) * concentration.getConcentration();
        }
        return result;
    }

    @Override
    public String[] getMineralTypeNames() {
        String[] result = new String[]{};
        MineralMapConfig config = SimulationConfig.instance().getMineralMapConfiguration();
        try {
            List<MineralMapConfig.MineralType> mineralTypes = config.getMineralTypes();
            result = new String[mineralTypes.size()];
            for (int x = 0; x < mineralTypes.size(); ++x) {
                result[x] = mineralTypes.get((int)x).name;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error getting mineral types.", e);
        }
        return result;
    }

    @Override
    public Coordinates findRandomMineralLocation(Coordinates startingLocation, double range) {
        Coordinates result = null;
        ArrayList<MineralConcentration> locales = new ArrayList<MineralConcentration>(0);
        for (MineralConcentration mineralConc : this.mineralConcentrations) {
            double distance = startingLocation.getDistance(mineralConc.getLocation());
            if (!(range > distance - mineralConc.getConcentration())) continue;
            locales.add(mineralConc);
        }
        if (locales.size() > 0) {
            int index = RandomUtil.getRandomInt(locales.size() - 1);
            MineralConcentration concentration = (MineralConcentration)locales.get(index);
            double distance = startingLocation.getDistance(concentration.getLocation());
            if (range < distance) {
                Direction direction = startingLocation.getDirectionToPoint(concentration.getLocation());
                result = startingLocation.getNewLocation(direction, range);
            } else {
                result = new Coordinates(concentration.getLocation());
            }
        }
        return result;
    }

    @Override
    public void destroy() {
        this.mineralConcentrations.clear();
        this.mineralConcentrations = null;
    }

    private static class MineralConcentration
    implements Serializable {
        private Coordinates location;
        private double concentration;
        private String mineralType;

        private MineralConcentration(Coordinates location, double concentration, String mineralType) {
            this.location = location;
            this.concentration = concentration;
            this.mineralType = mineralType;
        }

        private Coordinates getLocation() {
            return this.location;
        }

        private double getConcentration() {
            return this.concentration;
        }

        private String getMineralType() {
            return this.mineralType;
        }
    }
}

