/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.mars;

import java.io.Serializable;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.mars.TerrainElevation;

public class Weather
implements Serializable {
    private static final double SEA_LEVEL_AIR_PRESSURE = 0.009;
    private static final double SEA_LEVEL_AIR_DENSITY = 0.0115;
    private static final double SEA_LEVEL_GRAVITY = 3.0;
    private static final double EXTREME_COLD = -120.0;

    public double getAirPressure(Coordinates location) {
        Mars mars = Simulation.instance().getMars();
        TerrainElevation terrainElevation = mars.getSurfaceFeatures().getSurfaceTerrain();
        double elevation = terrainElevation.getElevation(location);
        double pressure = 0.009 * Math.exp(-0.0038333333333333336 * elevation);
        return pressure;
    }

    public double getTemperature(Coordinates location) {
        double temperature = -120.0;
        Mars mars = Simulation.instance().getMars();
        SurfaceFeatures surfaceFeatures = mars.getSurfaceFeatures();
        if (surfaceFeatures.inDarkPolarRegion(location)) {
            temperature = -150.0;
        } else {
            temperature += surfaceFeatures.getSurfaceSunlight(location) * 0.629921;
            TerrainElevation terrainElevation = surfaceFeatures.getSurfaceTerrain();
            temperature -= terrainElevation.getElevation(location) * 5.0;
            double piHalf = 1.5707963267948966;
            double degrees = 0.0;
            double phi = location.getPhi();
            if (phi < piHalf) {
                degrees = (piHalf - phi) / piHalf;
            } else if (phi > piHalf) {
                degrees = (phi - piHalf) / piHalf;
            }
            temperature -= 20.0 * degrees;
        }
        return temperature;
    }

    public void destroy() {
    }
}

