/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person;

import java.io.Serializable;
import java.util.Hashtable;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.person.Person;

public class NaturalAttributeManager
implements Serializable {
    public static final String STRENGTH = "Strength";
    public static final String ENDURANCE = "Endurance";
    public static final String AGILITY = "Agility";
    public static final String TEACHING = "Teaching";
    public static final String ACADEMIC_APTITUDE = "Academic Aptitude";
    public static final String EXPERIENCE_APTITUDE = "Experience Aptitude";
    public static final String STRESS_RESILIENCE = "Stress Resilience";
    public static final String ATTRACTIVENESS = "Attractiveness";
    public static final String LEADERSHIP = "Leadership";
    public static final String CONVERSATION = "Conversation";
    private static String[] attributeKeys = new String[]{"Strength", "Endurance", "Agility", "Teaching", "Academic Aptitude", "Experience Aptitude", "Stress Resilience", "Attractiveness", "Leadership", "Conversation"};
    private Hashtable<String, Integer> attributeList = new Hashtable();

    NaturalAttributeManager(Person person) {
        for (String attributeKey : attributeKeys) {
            int attributeValue = 0;
            int numberOfIterations = 3;
            for (int y = 0; y < numberOfIterations; ++y) {
                attributeValue += RandomUtil.getRandomInt(100);
            }
            this.attributeList.put(attributeKey, attributeValue /= numberOfIterations);
        }
        this.addAttributeModifier(STRENGTH, 40);
        this.addAttributeModifier(ENDURANCE, 40);
        this.addAttributeModifier(AGILITY, 20);
        this.addAttributeModifier(STRESS_RESILIENCE, 80);
        this.addAttributeModifier(TEACHING, 40);
        this.addAttributeModifier(ACADEMIC_APTITUDE, 80);
        this.addAttributeModifier(EXPERIENCE_APTITUDE, 60);
        if (person.getGender().equals("male")) {
            this.addAttributeModifier(STRENGTH, 40);
        } else if (person.getGender().equals("female")) {
            this.addAttributeModifier(STRENGTH, -40);
            this.addAttributeModifier(ENDURANCE, 20);
        }
    }

    private void addAttributeModifier(String attributeName, int modifier) {
        int random = RandomUtil.getRandomInt(Math.abs(modifier));
        if (modifier < 0) {
            random *= -1;
        }
        this.setAttribute(attributeName, this.getAttribute(attributeName) + random);
    }

    public int getAttributeNum() {
        return attributeKeys.length;
    }

    public static String[] getKeys() {
        String[] result = new String[attributeKeys.length];
        System.arraycopy(attributeKeys, 0, result, 0, result.length);
        return result;
    }

    public int getAttribute(String name) {
        int result = 0;
        if (this.attributeList.containsKey(name)) {
            result = this.attributeList.get(name);
        }
        return result;
    }

    public void setAttribute(String name, int level) {
        if (level > 100) {
            level = 100;
        }
        if (level < 0) {
            level = 0;
        }
        boolean found = false;
        for (String attributeKey : attributeKeys) {
            if (!name.equals(attributeKey)) continue;
            this.attributeList.put(name, level);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Attribute: " + name + " is not a valid attribute.");
        }
    }

    public void destroy() {
        this.attributeList.clear();
        this.attributeList = null;
    }
}

